/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;

public class JdbcRowSetImpl
extends BaseRowSet
implements JdbcRowSet,
Joinable {
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;
    private RowSetMetaDataImpl rowsMD;
    private ResultSetMetaData resMD;
    private PropertyChangeSupport propertyChangeSupport;
    private Vector iMatchColumns;
    private Vector strMatchColumns;
    private transient JdbcRowSetResourceBundle jdbcResBundle;

    public JdbcRowSetImpl() {
        int n;
        this.conn = null;
        this.ps = null;
        this.rs = null;
        try {
            this.jdbcResBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        try {
            this.setShowDeleted(false);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setShowDeleted) :" + sQLException.getMessage());
        }
        try {
            this.setQueryTimeout(0);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setQueryTimeout) :" + sQLException.getMessage());
        }
        try {
            this.setMaxRows(0);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxRows) :" + sQLException.getMessage());
        }
        try {
            this.setMaxFieldSize(0);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxFieldSize) :" + sQLException.getMessage());
        }
        try {
            this.setEscapeProcessing(true);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setEscapeProcessing) :" + sQLException.getMessage());
        }
        try {
            this.setConcurrency(1008);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setConcurrency) :" + sQLException.getMessage());
        }
        this.setTypeMap((Map)null);
        try {
            this.setType(1004);
        }
        catch (SQLException sQLException) {
            sQLException.getMessage();
        }
        this.setReadOnly(true);
        try {
            this.setTransactionIsolation(2);
        }
        catch (SQLException sQLException) {
            sQLException.getMessage();
        }
        this.iMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.iMatchColumns.add(n, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.strMatchColumns.add(n, null);
        }
    }

    public JdbcRowSetImpl(Connection connection) throws SQLException {
        int n;
        this.conn = connection;
        this.ps = null;
        this.rs = null;
        try {
            this.jdbcResBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap((Map)null);
        this.iMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.iMatchColumns.add(n, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.strMatchColumns.add(n, null);
        }
    }

    public JdbcRowSetImpl(String string, String string2, String string3) throws SQLException {
        int n;
        this.conn = null;
        this.ps = null;
        this.rs = null;
        try {
            this.jdbcResBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setUsername(string2);
        this.setPassword(string3);
        this.setUrl(string);
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap((Map)null);
        this.connect();
        this.iMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.iMatchColumns.add(n, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.strMatchColumns.add(n, null);
        }
    }

    public JdbcRowSetImpl(ResultSet resultSet) throws SQLException {
        int n;
        this.conn = null;
        this.ps = null;
        this.rs = resultSet;
        try {
            this.jdbcResBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap((Map)null);
        this.resMD = this.rs.getMetaData();
        this.rowsMD = new RowSetMetaDataImpl();
        this.initMetaData(this.rowsMD, this.resMD);
        this.iMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.iMatchColumns.add(n, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.strMatchColumns.add(n, null);
        }
    }

    protected void initMetaData(RowSetMetaData rowSetMetaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        rowSetMetaData.setColumnCount(n);
        for (int i = 1; i <= n; ++i) {
            rowSetMetaData.setAutoIncrement(i, resultSetMetaData.isAutoIncrement(i));
            rowSetMetaData.setCaseSensitive(i, resultSetMetaData.isCaseSensitive(i));
            rowSetMetaData.setCurrency(i, resultSetMetaData.isCurrency(i));
            rowSetMetaData.setNullable(i, resultSetMetaData.isNullable(i));
            rowSetMetaData.setSigned(i, resultSetMetaData.isSigned(i));
            rowSetMetaData.setSearchable(i, resultSetMetaData.isSearchable(i));
            rowSetMetaData.setColumnDisplaySize(i, resultSetMetaData.getColumnDisplaySize(i));
            rowSetMetaData.setColumnLabel(i, resultSetMetaData.getColumnLabel(i));
            rowSetMetaData.setColumnName(i, resultSetMetaData.getColumnName(i));
            rowSetMetaData.setSchemaName(i, resultSetMetaData.getSchemaName(i));
            rowSetMetaData.setPrecision(i, resultSetMetaData.getPrecision(i));
            rowSetMetaData.setScale(i, resultSetMetaData.getScale(i));
            rowSetMetaData.setTableName(i, resultSetMetaData.getTableName(i));
            rowSetMetaData.setCatalogName(i, resultSetMetaData.getCatalogName(i));
            rowSetMetaData.setColumnType(i, resultSetMetaData.getColumnType(i));
            rowSetMetaData.setColumnTypeName(i, resultSetMetaData.getColumnTypeName(i));
        }
    }

    protected void checkState() throws SQLException {
        if (this.conn == null && this.ps == null && this.rs == null) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.invalstate").toString());
        }
    }

    public void execute() throws SQLException {
        this.prepare();
        this.setProperties(this.ps);
        this.decodeParams(this.getParams(), this.ps);
        this.rs = this.ps.executeQuery();
        this.notifyRowSetChanged();
    }

    protected void setProperties(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setEscapeProcessing): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxFieldSize): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxRows(this.getMaxRows());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxRows): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setQueryTimeout): " + sQLException.getMessage());
        }
    }

    protected Connection connect() throws SQLException {
        if (this.conn != null) {
            return this.conn;
        }
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(this.getDataSourceName());
                if (this.getUsername() != null) {
                    return dataSource.getConnection(this.getUsername(), this.getPassword());
                }
                return dataSource.getConnection();
            }
            catch (NamingException namingException) {
                throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.connect").toString());
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    protected PreparedStatement prepare() throws SQLException {
        this.conn = this.connect();
        try {
            if (this.conn == null) {
                // empty if block
            }
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
            this.conn.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setTransactionIsolation): " + sQLException.getMessage());
        }
        try {
            this.conn.setTypeMap(this.getTypeMap());
        }
        catch (Throwable throwable) {
            System.err.println("JdbcRowSet (setTypeMap): " + throwable.getMessage());
        }
        try {
            this.ps = this.conn.prepareStatement(this.getCommand(), 1004, 1008);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (execute): " + sQLException.getMessage());
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            throw new SQLException(sQLException.getMessage());
        }
        return this.ps;
    }

    private void decodeParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        Object[] objectArray2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Object[]) {
                objectArray2 = (Object[])objectArray[i];
                if (objectArray2.length == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(i + 1, (Integer)objectArray2[1]);
                        continue;
                    }
                    if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        System.err.println("Detected a Date");
                        if (objectArray2[1] instanceof Calendar) {
                            System.err.println("Detected a Calendar");
                            preparedStatement.setDate(i + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                            continue;
                        }
                        throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.paramtype").toString());
                    }
                    if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(i + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                        continue;
                    }
                    if (!(objectArray2[1] instanceof Integer)) continue;
                    preparedStatement.setObject(i + 1, objectArray2[0], (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2.length == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(i + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                        continue;
                    }
                    if (objectArray2[0] instanceof InputStream) {
                        switch ((Integer)objectArray2[2]) {
                            case 0: {
                                preparedStatement.setUnicodeStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 1: {
                                preparedStatement.setBinaryStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 2: {
                                preparedStatement.setAsciiStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                        }
                        throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.paramtype").toString());
                    }
                    if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                        preparedStatement.setObject(i + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                        continue;
                    }
                    throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.paramtype").toString());
                }
                preparedStatement.setObject(i + 1, objectArray[i]);
                continue;
            }
            preparedStatement.setObject(i + 1, objectArray[i]);
        }
    }

    public boolean next() throws SQLException {
        this.checkState();
        boolean bl = this.rs.next();
        this.notifyCursorMoved();
        return bl;
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkState();
        return this.rs.wasNull();
    }

    public String getString(int n) throws SQLException {
        this.checkState();
        return this.rs.getString(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        this.checkState();
        return this.rs.getByte(n);
    }

    public short getShort(int n) throws SQLException {
        this.checkState();
        return this.rs.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        this.checkState();
        return this.rs.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        this.checkState();
        return this.rs.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        this.checkState();
        return this.rs.getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        this.checkState();
        return this.rs.getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n, n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkState();
        return this.rs.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        this.checkState();
        return this.rs.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        this.checkState();
        return this.rs.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(n);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.rs.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        this.rs.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        this.checkState();
        return this.rs.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            this.prepare();
            return this.ps.getMetaData();
        }
        return this.rs.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        this.checkState();
        return this.rs.getObject(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        this.checkState();
        return this.rs.findColumn(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        return this.rs.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkState();
        return this.rs.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.checkState();
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkState();
        return this.rs.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkState();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    public void afterLast() throws SQLException {
        this.checkState();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    public boolean first() throws SQLException {
        this.checkState();
        boolean bl = this.rs.first();
        this.notifyCursorMoved();
        return bl;
    }

    public boolean last() throws SQLException {
        this.checkState();
        boolean bl = this.rs.last();
        this.notifyCursorMoved();
        return bl;
    }

    public int getRow() throws SQLException {
        this.checkState();
        return this.rs.getRow();
    }

    public boolean absolute(int n) throws SQLException {
        this.checkState();
        boolean bl = this.rs.absolute(n);
        this.notifyCursorMoved();
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        this.checkState();
        boolean bl = this.rs.relative(n);
        this.notifyCursorMoved();
        return bl;
    }

    public boolean previous() throws SQLException {
        this.checkState();
        boolean bl = this.rs.previous();
        this.notifyCursorMoved();
        return bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkState();
        this.rs.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            super.getFetchDirection();
        }
        return this.rs.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkState();
        this.rs.setFetchSize(n);
    }

    public int getType() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            return super.getType();
        }
        return this.rs.getType();
    }

    public int getConcurrency() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            super.getConcurrency();
        }
        return this.rs.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        this.checkState();
        return this.rs.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        this.checkState();
        return this.rs.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        this.checkState();
        return this.rs.rowDeleted();
    }

    public void updateNull(int n) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateNull(n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBoolean(n, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateByte(n, by);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateShort(n, s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateInt(n, n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateLong(n, l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateFloat(n, f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateDouble(n, d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateString(n, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBytes(n, byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateDate(n, date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateTime(n, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateTimestamp(n, timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateCharacterStream(n, reader, n2);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateObject(n, object, n2);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateObject(n, object);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        this.checkState();
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        this.checkState();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        this.checkState();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        this.checkState();
        this.rs.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkState();
        this.rs.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        this.rs.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        if (this.rs != null) {
            return this.rs.getStatement();
        }
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkState();
        return this.rs.getObject(n, map);
    }

    public Ref getRef(int n) throws SQLException {
        this.checkState();
        return this.rs.getRef(n);
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkState();
        return this.rs.getBlob(n);
    }

    public Clob getClob(int n) throws SQLException {
        this.checkState();
        return this.rs.getClob(n);
    }

    public Array getArray(int n) throws SQLException {
        this.checkState();
        return this.rs.getArray(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getDate(n, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.checkState();
        this.rs.updateRef(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.checkState();
        this.rs.updateClob(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.checkState();
        this.rs.updateBlob(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.checkState();
        this.rs.updateArray(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public URL getURL(int n) throws SQLException {
        this.checkState();
        return this.rs.getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    public void unsetMatchColumn(int[] nArray) throws SQLException {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            int n2 = Integer.parseInt(this.iMatchColumns.get(n).toString());
            if (nArray[n] == n2) continue;
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.matchcols").toString());
        }
        for (n = 0; n < nArray.length; ++n) {
            this.iMatchColumns.set(n, new Integer(-1));
        }
    }

    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(this.strMatchColumns.get(n))) continue;
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.matchcols").toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.strMatchColumns.set(n, null);
        }
    }

    public String[] getMatchColumnNames() throws SQLException {
        Object[] objectArray = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.setmatchcols").toString());
        }
        this.strMatchColumns.copyInto(objectArray);
        return objectArray;
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] objectArray = new Integer[this.iMatchColumns.size()];
        int[] nArray = new int[this.iMatchColumns.size()];
        int n = (Integer)this.iMatchColumns.get(0);
        if (n == -1) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.setmatchcols").toString());
        }
        this.iMatchColumns.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }

    public void setMatchColumn(int[] nArray) throws SQLException {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0) continue;
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.matchcols1").toString());
        }
        for (n = 0; n < nArray.length; ++n) {
            this.iMatchColumns.add(n, new Integer(nArray[n]));
        }
    }

    public void setMatchColumn(String[] stringArray) throws SQLException {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && !stringArray[n].equals("")) continue;
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.matchcols2").toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.strMatchColumns.add(n, stringArray[n]);
        }
    }

    public void setMatchColumn(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.matchcols1").toString());
        }
        this.iMatchColumns.set(0, new Integer(n));
    }

    public void setMatchColumn(String string) throws SQLException {
        if ((string = string.trim()) == "" || string.equals(null)) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.matchcols2").toString());
        }
        this.strMatchColumns.set(0, string);
    }

    public void unsetMatchColumn(int n) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(n))) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.unsetmatch").toString());
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.usecolname").toString());
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    public void unsetMatchColumn(String string) throws SQLException {
        string = string.trim();
        if (!this.strMatchColumns.get(0).equals(string)) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.unsetmatch").toString());
        }
        if ((Integer)this.iMatchColumns.get(0) > 0) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.usecolid").toString());
        }
        this.strMatchColumns.set(0, null);
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        Connection connection = this.connect();
        return connection.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.prepare();
        return this.ps.getParameterMetaData();
    }

    public void commit() throws SQLException {
        this.conn.commit();
        if (this.conn.getHoldability() != 1) {
            ResultSet resultSet = this.rs;
            this.rs = null;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
        ResultSet resultSet = this.rs;
        this.rs = null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    protected void setParams() throws SQLException {
        if (this.rs == null) {
            this.setType(1004);
            this.setConcurrency(1008);
        } else {
            this.setType(this.rs.getType());
            this.setConcurrency(this.rs.getConcurrency());
        }
    }

    private void checkTypeConcurrency() throws SQLException {
        if (this.rs.getType() == 1003 || this.rs.getConcurrency() == 1007) {
            throw new SQLException(this.jdbcResBundle.handleGetObject("jdbcrowsetimpl.resnotupd").toString());
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(Connection connection) {
        this.conn = connection;
    }

    protected PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    protected void setPreparedStatement(PreparedStatement preparedStatement) {
        this.ps = preparedStatement;
    }

    protected ResultSet getResultSet() throws SQLException {
        this.checkState();
        return this.rs;
    }

    protected void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    public void setCommand(String string) throws SQLException {
        if (this.getCommand() != null) {
            if (!this.getCommand().equals(string)) {
                String string2 = this.getCommand();
                super.setCommand(string);
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("command", string2, string);
            }
        } else {
            super.setCommand(string);
            this.propertyChangeSupport.firePropertyChange("command", null, string);
        }
    }

    public void setDataSourceName(String string) throws SQLException {
        if (this.getDataSourceName() != null) {
            if (!this.getDataSourceName().equals(string)) {
                String string2 = this.getDataSourceName();
                super.setDataSourceName(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("dataSourceName", string2, string);
            }
        } else {
            super.setDataSourceName(string);
            this.propertyChangeSupport.firePropertyChange("dataSourceName", null, string);
        }
    }

    public void setUrl(String string) throws SQLException {
        if (this.getUrl() != null) {
            if (!this.getUrl().equals(string)) {
                String string2 = this.getUrl();
                super.setUrl(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("url", string2, string);
            }
        } else {
            super.setUrl(string);
            this.propertyChangeSupport.firePropertyChange("url", null, string);
        }
    }

    public void setUsername(String string) {
        if (this.getUsername() != null) {
            if (!this.getUsername().equals(string)) {
                String string2 = this.getUsername();
                super.setUsername(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("username", string2, string);
            }
        } else {
            super.setUsername(string);
            this.propertyChangeSupport.firePropertyChange("username", null, string);
        }
    }

    public void setPassword(String string) {
        if (this.getPassword() != null) {
            if (!this.getPassword().equals(string)) {
                String string2 = this.getPassword();
                super.setPassword(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("password", string2, string);
            }
        } else {
            super.setPassword(string);
            this.propertyChangeSupport.firePropertyChange("password", null, string);
        }
    }

    public void setType(int n) throws SQLException {
        int n2;
        try {
            n2 = this.getType();
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
        }
        if (n2 != n) {
            super.setType(n);
            this.propertyChangeSupport.firePropertyChange("type", n2, n);
        }
    }

    public void setConcurrency(int n) throws SQLException {
        int n2;
        try {
            n2 = this.getConcurrency();
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
        }
        if (n2 != n) {
            super.setConcurrency(n);
            this.propertyChangeSupport.firePropertyChange("concurrency", n2, n);
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        int n2;
        try {
            n2 = this.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
        }
        if (n2 != n) {
            super.setTransactionIsolation(n);
            this.propertyChangeSupport.firePropertyChange("transactionIsolation", n2, n);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        int n2;
        try {
            n2 = this.getMaxRows();
        }
        catch (NullPointerException nullPointerException) {
            n2 = 0;
        }
        if (n2 != n) {
            super.setMaxRows(n);
            this.propertyChangeSupport.firePropertyChange("maxRows", n2, n);
        }
    }
}

