/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class StandaloneJarProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(File from, File to, JarProcessor proc) throws IOException {
        byte[] buf = new byte[8192];
        File tmp = null;
        if (from.equals(to)) {
            tmp = File.createTempFile("jarjar", null);
            StandaloneJarProcessor.copy(from, tmp, buf);
            from = tmp;
        }
        JarFile in = new JarFile(from);
        JarOutputStream out = new JarOutputStream(new FileOutputStream(to));
        try {
            EntryStruct struct = new EntryStruct();
            Enumeration<JarEntry> e = in.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                struct.name = entry.getName();
                struct.time = entry.getTime();
                struct.file = from;
                struct.in = in.getInputStream(entry);
                try {
                    if (!proc.process(struct)) continue;
                    entry = new JarEntry(struct.name);
                    entry.setTime(struct.time);
                    entry.setCompressedSize(-1L);
                    out.putNextEntry(entry);
                    StandaloneJarProcessor.pipe(struct.in, out, buf);
                }
                finally {
                    struct.in.close();
                }
            }
        }
        finally {
            out.close();
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File from, File to, byte[] buf) throws IOException {
        FileInputStream in = new FileInputStream(from);
        try {
            FileOutputStream out = new FileOutputStream(to);
            try {
                StandaloneJarProcessor.pipe(in, out, buf);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void pipe(InputStream is, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = is.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }
}

