/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class DOMReader
extends XMLReader {
    ContentHandler contentHandler;
    LexicalHandler lexicalHandler;
    private Node currentNode;
    private DocumentPreservationPolicy docPresPolicy;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource input) {
    }

    public void parse(String systemId) {
    }

    public void parse(Node node) throws SAXException {
        if (this.getContentHandler() == null) {
            return;
        }
        Element rootNode = null;
        rootNode = node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : (Element)node;
        this.processParentNamespaces(rootNode);
        this.startDocument();
        this.setupLocator(rootNode.getOwnerDocument());
        this.reportElementEvents(rootNode);
        this.endDocument();
    }

    protected void processParentNamespaces(Element element) throws SAXException {
        Node parent = element.getParentNode();
        if (parent != null && parent.getNodeType() == 9) {
            return;
        }
        Stack<Node> parentElements = new Stack<Node>();
        while (parent != null && parent.getNodeType() != 9) {
            parentElements.push(parent);
            parent = parent.getParentNode();
        }
        Iterator stackIt = parentElements.iterator();
        while (stackIt.hasNext()) {
            NamedNodeMap attrs = ((Node)parentElements.pop()).getAttributes();
            if (attrs == null) continue;
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr next = (Attr)attrs.item(i);
                String attrPrefix = next.getPrefix();
                if (attrPrefix == null || !attrPrefix.equals("xmlns")) continue;
                this.getContentHandler().startPrefixMapping(next.getLocalName(), next.getValue());
            }
        }
    }

    protected void reportElementEvents(Element elem) throws SAXException {
        this.currentNode = elem;
        IndexedAttributeList attributes = this.buildAttributeList(elem);
        String lname = elem.getLocalName();
        String qname = lname == null ? (lname = elem.getNodeName()) : this.getQName(elem);
        this.getContentHandler().startElement(elem.getNamespaceURI(), lname, qname, attributes);
        this.handleChildNodes(elem.getChildNodes());
        this.endPrefixMappings(elem);
        this.getContentHandler().endElement(elem.getNamespaceURI(), lname, qname);
    }

    protected IndexedAttributeList buildAttributeList(Element elem) throws SAXException {
        IndexedAttributeList attributes = new IndexedAttributeList();
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr next = (Attr)attrs.item(i);
            String attrPrefix = next.getPrefix();
            if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                this.getContentHandler().startPrefixMapping(next.getLocalName(), next.getValue());
                this.handleXMLNSPrefixedAttribute(elem, next);
            } else if (attrPrefix == null) {
                String name = next.getLocalName();
                if (name == null) {
                    name = next.getNodeName();
                }
                if (name != null && name.equals("xmlns")) {
                    this.getContentHandler().startPrefixMapping("", next.getValue());
                }
            }
            attributes.addAttribute(next);
        }
        return attributes;
    }

    protected void endPrefixMappings(Element elem) throws SAXException {
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr next = (Attr)attrs.item(i);
            String attrPrefix = next.getPrefix();
            if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                this.getContentHandler().endPrefixMapping(next.getLocalName());
                continue;
            }
            if (attrPrefix != null) continue;
            String name = next.getLocalName();
            if (name == null) {
                name = next.getNodeName();
            }
            if (name == null) continue;
            this.getContentHandler().endPrefixMapping("");
        }
    }

    protected String getQName(Element elem) throws SAXException {
        if (elem.getLocalName() == null) {
            return elem.getNodeName();
        }
        String qname = "";
        String prefix = elem.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            qname = prefix + ":" + elem.getLocalName();
            this.handlePrefixedAttribute(elem);
        } else {
            qname = elem.getLocalName();
        }
        return qname;
    }

    protected void handleXMLNSPrefixedAttribute(Element elem, Attr attr) {
    }

    protected void handlePrefixedAttribute(Element elem) throws SAXException {
    }

    protected void handleChildNodes(NodeList children) throws SAXException {
        for (int i = 0; i < children.getLength(); ++i) {
            char[] value;
            Node next = children.item(i);
            if (next.getNodeType() == 3) {
                value = ((Text)next).getNodeValue().toCharArray();
                this.getContentHandler().characters(value, 0, value.length);
                continue;
            }
            if (next.getNodeType() == 8) {
                value = ((Comment)next).getNodeValue().toCharArray();
                if (this.lexicalHandler == null) continue;
                this.lexicalHandler.comment(value, 0, value.length);
                continue;
            }
            if (next.getNodeType() == 1) {
                Element childElement = (Element)next;
                this.reportElementEvents(childElement);
                continue;
            }
            if (next.getNodeType() != 4) continue;
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
            value = ((CDATASection)next).getData().toCharArray();
            this.getContentHandler().characters(value, 0, value.length);
            if (this.lexicalHandler == null) continue;
            this.lexicalHandler.endCDATA();
        }
    }

    protected void endDocument() throws SAXException {
        this.getContentHandler().endDocument();
    }

    protected void startDocument() throws SAXException {
        this.getContentHandler().startDocument();
    }

    public void newObjectEvent(Object object, Object parent, XMLMapping selfRecordMapping) {
        this.docPresPolicy.addObjectToCache(object, this.currentNode, selfRecordMapping);
    }

    public Object getCurrentObject(AbstractSession session, XMLMapping selfRecordMapping) {
        if (session == null && this.docPresPolicy == null) {
            return null;
        }
        if (this.docPresPolicy == null) {
            XMLLogin login = (XMLLogin)session.getDatasourceLogin();
            this.docPresPolicy = login.getDocumentPreservationPolicy();
        }
        return this.docPresPolicy.getObjectForNode(this.currentNode, selfRecordMapping);
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.docPresPolicy;
    }

    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.docPresPolicy = policy;
    }

    protected void setupLocator(Document doc) {
        LocatorImpl locator = new LocatorImpl();
        try {
            Method getEncoding = PrivilegedAccessHelper.getMethod(doc.getClass(), "getXmlEncoding", new Class[0], true);
            Method getVersion = PrivilegedAccessHelper.getMethod(doc.getClass(), "getXmlVersion", new Class[0], true);
            String encoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, doc, new Object[0]);
            String version = (String)PrivilegedAccessHelper.invokeMethod(getVersion, doc, new Object[0]);
            locator.setEncoding(encoding);
            locator.setXMLVersion(version);
        }
        catch (Exception ex) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    protected class LocatorImpl
    implements Locator2 {
        private String encoding = "UTF-8";
        private String version = "1.0";

        public String getEncoding() {
            return this.encoding;
        }

        public int getColumnNumber() {
            return 0;
        }

        public String getSystemId() {
            return "";
        }

        public String getPublicId() {
            return "";
        }

        public String getXMLVersion() {
            return this.version;
        }

        public int getLineNumber() {
            return 0;
        }

        protected void setEncoding(String enc) {
            this.encoding = enc;
        }

        protected void setXMLVersion(String xmlVersion) {
            this.version = xmlVersion;
        }
    }

    protected class IndexedAttributeList
    implements Attributes {
        private ArrayList<Attr> attrs = new ArrayList();

        public void addAttribute(Attr attribute) {
            this.attrs.add(attribute);
        }

        public String getQName(int index) {
            try {
                Attr item = this.attrs.get(index);
                if (item.getName() != null) {
                    return item.getName();
                }
                return "";
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }

        public String getType(String namespaceUri, String localName) {
            return "CDATA";
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String qname) {
            return "CDATA";
        }

        public int getIndex(String qname) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attr item = this.attrs.get(i);
                if (!item.getName().equals(qname)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attr item = this.attrs.get(i);
                try {
                    if (!item.getNamespaceURI().equals(uri) || !item.getLocalName().equals(localName)) continue;
                    return i;
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            return -1;
        }

        public int getLength() {
            return this.attrs.size();
        }

        public String getLocalName(int index) {
            try {
                Attr item = this.attrs.get(index);
                if (item.getLocalName() != null) {
                    return item.getLocalName();
                }
                return "";
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }

        public String getURI(int index) {
            return this.attrs.get(index).getNamespaceURI();
        }

        public String getValue(int index) {
            return this.attrs.get(index).getValue();
        }

        public String getValue(String qname) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attr item = this.attrs.get(i);
                if (!item.getName().equals(qname)) continue;
                return item.getValue();
            }
            return null;
        }

        public String getValue(String uri, String localName) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attr item = this.attrs.get(i);
                if (item == null) continue;
                String itemNS = item.getNamespaceURI();
                if (item.getNamespaceURI() == null) {
                    itemNS = "";
                }
                if (!itemNS.equals(uri) || item.getLocalName() == null || !item.getLocalName().equals(localName)) continue;
                return item.getValue();
            }
            return null;
        }
    }
}

