/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Hashtable;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteFunctionCall;
import org.eclipse.persistence.internal.sessions.remote.SequencingFunctionCall;

class RemoteConnectionSequencing
implements Sequencing {
    protected RemoteConnection remoteConnection;
    protected Hashtable classToShouldAcquireValueAfterInsert;
    protected int whenShouldAcquireValueForAll;

    public static boolean masterSequencingExists(RemoteConnection con) {
        return (Boolean)con.getSequenceNumberNamed(new SequencingFunctionCall.DoesExist());
    }

    public RemoteConnectionSequencing(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.whenShouldAcquireValueForAll = (Integer)this.processFunctionCall(new SequencingFunctionCall.WhenShouldAcquireValueForAll());
        if (this.whenShouldAcquireValueForAll == 0) {
            this.classToShouldAcquireValueAfterInsert = new Hashtable(20);
        }
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    public boolean shouldAcquireValueAfterInsert(Class cls) {
        if (this.whenShouldAcquireValueForAll == -1) {
            return false;
        }
        if (this.whenShouldAcquireValueForAll == 1) {
            return true;
        }
        Boolean after = (Boolean)this.classToShouldAcquireValueAfterInsert.get(cls);
        if (after == null) {
            after = (Boolean)this.processFunctionCall(new SequencingFunctionCall.ShouldAcquireValueAfterInsert(cls));
            this.classToShouldAcquireValueAfterInsert.put(cls, after);
        }
        return after;
    }

    public boolean shouldOverrideExistingValue(Class cls, Object existingValue) {
        Boolean shouldOverride = (Boolean)this.processFunctionCall(new SequencingFunctionCall.ShouldOverrideExistingValue(cls, existingValue));
        return shouldOverride;
    }

    public Object getNextValue(Class cls) {
        return this.processFunctionCall(new SequencingFunctionCall.GetNextValue(cls));
    }

    protected Object processFunctionCall(RemoteFunctionCall call) {
        return this.remoteConnection.getSequenceNumberNamed(call);
    }
}

