/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.io.Serializable;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.FunctionExpression;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class ReportItem
implements Serializable {
    protected Expression attributeExpression;
    protected String name;
    protected DatabaseMapping mapping;
    protected ClassDescriptor descriptor;
    protected Class resultType;
    protected JoinedAttributeManager joinManager;
    protected int resultIndex;

    public ReportItem() {
    }

    public ReportItem(String name, Expression attributeExpression) {
        this.name = name;
        this.attributeExpression = attributeExpression;
        this.joinManager = new JoinedAttributeManager();
    }

    public Expression getAttributeExpression() {
        return this.attributeExpression;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public JoinedAttributeManager getJoinedAttributeManager() {
        return this.joinManager;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public void initialize(ReportQuery query) throws QueryException {
        if (this.getMapping() == null) {
            DatabaseMapping mapping = query.getLeafMappingFor(this.getAttributeExpression(), query.getDescriptor());
            if (mapping == null) {
                if (this.getAttributeExpression() != null && this.getAttributeExpression().isExpressionBuilder()) {
                    Class resultClass = ((ExpressionBuilder)this.getAttributeExpression()).getQueryClass();
                    if (resultClass == null) {
                        resultClass = query.getReferenceClass();
                    }
                    this.setDescriptor(query.getSession().getDescriptor(resultClass));
                    if (this.getDescriptor().hasInheritance()) {
                        ((ExpressionBuilder)this.getAttributeExpression()).setShouldUseOuterJoinForMultitableInheritance(true);
                    }
                }
            } else if (mapping.isForeignReferenceMapping()) {
                this.setDescriptor(mapping.getReferenceDescriptor());
                if (this.getDescriptor().hasInheritance()) {
                    ((QueryKeyExpression)this.getAttributeExpression()).setShouldUseOuterJoinForMultitableInheritance(true);
                }
            } else if (mapping.isAbstractDirectMapping()) {
                this.setMapping(mapping);
            } else {
                throw QueryException.invalidExpressionForQueryItem(this.getAttributeExpression(), query);
            }
            this.joinManager.setDescriptor(this.descriptor);
            this.joinManager.setBaseQuery(query);
            if (this.getAttributeExpression() != null) {
                if (this.getAttributeExpression().getBuilder().wasQueryClassSetInternally()) {
                    this.attributeExpression = this.getAttributeExpression().rebuildOn(query.getExpressionBuilder());
                }
                this.joinManager.setBaseExpressionBuilder(this.attributeExpression.getBuilder());
            } else {
                this.joinManager.setBaseExpressionBuilder(query.getExpressionBuilder());
            }
            this.joinManager.prepareJoinExpressions(query.getSession());
        }
    }

    public boolean isContructorItem() {
        return false;
    }

    public boolean isPlaceHolder() {
        return this.getAttributeExpression() == null;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void setResultIndex(int resultIndex) {
        this.resultIndex = resultIndex;
        this.joinManager.setParentResultIndex(resultIndex);
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
        if (this.getAttributeExpression() != null && this.getAttributeExpression().isFunctionExpression()) {
            ((FunctionExpression)this.getAttributeExpression()).setResultType(resultType);
        }
    }

    public String toString() {
        return "ReportQueryItem(" + this.getName() + " -> " + this.getAttributeExpression() + ")";
    }
}

