/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.InterruptableInputStream;

public class HttpMethodReleaseInputStream
extends InputStream
implements InputStreamWrapper {
    private final Log log = LogFactory.getLog((Class)HttpMethodReleaseInputStream.class);
    private InputStream inputStream = null;
    private HttpMethod httpMethod = null;
    private boolean alreadyReleased = false;
    private boolean underlyingStreamConsumed = false;

    public HttpMethodReleaseInputStream(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        try {
            this.inputStream = new InterruptableInputStream(httpMethod.getResponseBodyAsStream());
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to obtain HttpMethod's response data stream", (Throwable)e);
            httpMethod.releaseConnection();
            this.inputStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    protected void releaseConnection() throws IOException {
        if (!this.alreadyReleased) {
            if (!this.underlyingStreamConsumed) {
                this.httpMethod.abort();
            }
            this.httpMethod.releaseConnection();
            this.alreadyReleased = true;
        }
    }

    public int read() throws IOException {
        int read = this.inputStream.read();
        if (read == -1) {
            this.underlyingStreamConsumed = true;
            if (!this.alreadyReleased) {
                this.releaseConnection();
                this.log.debug((Object)"Released HttpMethod as its response data stream is fully consumed");
            }
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        if (read == -1) {
            this.underlyingStreamConsumed = true;
            if (!this.alreadyReleased) {
                this.releaseConnection();
                this.log.debug((Object)"Released HttpMethod as its response data stream is fully consumed");
            }
        }
        return read;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        if (!this.alreadyReleased) {
            this.releaseConnection();
            this.log.debug((Object)"Released HttpMethod as its response data stream is closed");
        }
        this.inputStream.close();
    }

    protected void finalize() throws Throwable {
        if (!this.alreadyReleased) {
            this.releaseConnection();
            this.log.warn((Object)"Released HttpMethod in finalize() as response data stream has gone out of scope. This behaviour is not guarenteed! Please close all response data streams yourself.");
        }
        super.finalize();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

