/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.aspect;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredMethodInvocationRegistry
extends ThreadLocal<Set<String>> {
    @Override
    protected Set<String> initialValue() {
        return new HashSet<String>();
    }

    public void registerMethodInvocation(Object bean, String className, String methodName) {
        ((Set)this.get()).add(this.qualifyMethodName(bean, className, methodName));
    }

    public void interrogateRequiredMethods(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method requiredMethod) throws IllegalArgumentException, IllegalAccessException {
                if (!RequiredMethodInvocationRegistry.this.hasMethodBeenInvoked(bean, requiredMethod)) {
                    throw new BeanInitializationException(String.format("Method '%s' is required for bean '%s'", requiredMethod.getName(), beanName));
                }
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method candidate) {
                return !candidate.getDeclaringClass().equals(Object.class) && AnnotationUtils.findAnnotation((Method)candidate, Required.class) != null;
            }
        });
    }

    public void clear() {
        ((Set)this.get()).clear();
    }

    private boolean hasMethodBeenInvoked(Object bean, Method requiredMethod) {
        return ((Set)this.get()).contains(this.qualifyMethodName(bean, requiredMethod.getDeclaringClass().getName(), requiredMethod.getName()));
    }

    private String qualifyMethodName(Object bean, String className, String methodName) {
        return String.format("%s#%s#%s", System.identityHashCode(bean), className, methodName);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

