/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.internal.model.AutoBeanMethod;
import org.springframework.config.java.internal.model.BeanMethod;
import org.springframework.config.java.internal.model.ExternalBeanMethod;
import org.springframework.config.java.internal.model.ExternalValueMethod;
import org.springframework.config.java.internal.model.JavaConfigMethod;
import org.springframework.config.java.internal.model.NonJavaConfigMethod;
import org.springframework.config.java.internal.model.UsageError;
import org.springframework.config.java.internal.util.AnnotationExtractionUtils;
import org.springframework.config.java.model.ModelClass;
import org.springframework.config.java.model.ModelMethod;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationClass
extends ModelClass {
    public static final String IS_CONFIGURATION_CLASS = "IS_CONFIGURATION_CLASS";
    private static final Configuration DEFAULT_METADATA = AnnotationExtractionUtils.extractClassAnnotation(Configuration.class, Prototype.class);
    private String id;
    private int modifiers;
    private Configuration metadata;
    private HashSet<BeanMethod> beanMethods = new HashSet();
    private HashSet<ExternalBeanMethod> externalBeanMethods = new HashSet();
    private HashSet<ExternalValueMethod> externalValueMethods = new HashSet();
    private HashSet<AutoBeanMethod> autoBeanMethods = new HashSet();
    private transient HashMap<String, LinkedHashSet<JavaConfigMethod>> javaConfigMethods = new HashMap();
    private HashSet<NonJavaConfigMethod> nonJavaConfigMethods = new HashSet();
    private HashSet<Annotation> pluginAnnotations = new HashSet();
    private ArrayList<ConfigurationClass> importedClasses = new ArrayList();
    private ConfigurationClass declaringClass;

    public ConfigurationClass() {
    }

    ConfigurationClass(String name) {
        this(name, null, DEFAULT_METADATA, 0);
    }

    ConfigurationClass(String name, Configuration metadata) {
        this(name, null, metadata, 0);
    }

    ConfigurationClass(String name, int modifiers) {
        this(name, null, DEFAULT_METADATA, modifiers);
    }

    public ConfigurationClass(String name, String id, Configuration metadata, int modifiers) {
        super(name);
        Assert.hasText((String)name, (String)"Configuration class name must have text");
        this.setId(id);
        this.setMetadata(metadata);
        this.setModifiers(modifiers);
    }

    public ConfigurationClass add(BeanMethod method) {
        this.beanMethods.add(method);
        this.addJavaConfigMethod(method);
        method.setDeclaringClass(this);
        return this;
    }

    public ConfigurationClass add(ExternalBeanMethod method) {
        this.externalBeanMethods.add(method);
        this.addJavaConfigMethod(method);
        method.setDeclaringClass(this);
        return this;
    }

    public ConfigurationClass add(ExternalValueMethod method) {
        this.externalValueMethods.add(method);
        this.addJavaConfigMethod(method);
        method.setDeclaringClass(this);
        return this;
    }

    public ConfigurationClass add(AutoBeanMethod method) {
        this.autoBeanMethods.add(method);
        this.addJavaConfigMethod(method);
        method.setDeclaringClass(this);
        return this;
    }

    public ConfigurationClass add(NonJavaConfigMethod method) {
        this.nonJavaConfigMethods.add(method);
        method.setDeclaringClass(this);
        return this;
    }

    private void addJavaConfigMethod(JavaConfigMethod method) {
        LinkedHashSet<JavaConfigMethod> configMethods = this.javaConfigMethods.get(method.getName());
        if (configMethods == null) {
            configMethods = new LinkedHashSet();
            this.javaConfigMethods.put(method.getName(), configMethods);
        }
        configMethods.add(method);
    }

    public String getId() {
        return this.id == null ? this.getName() : this.id;
    }

    public ConfigurationClass setId(String id) {
        this.id = id;
        return this;
    }

    public BeanMethod[] getBeanMethods() {
        return this.beanMethods.toArray(new BeanMethod[this.beanMethods.size()]);
    }

    public AutoBeanMethod[] getAutoBeanMethods() {
        return this.autoBeanMethods.toArray(new AutoBeanMethod[this.autoBeanMethods.size()]);
    }

    public Annotation[] getPluginAnnotations() {
        return this.pluginAnnotations.toArray(new Annotation[this.pluginAnnotations.size()]);
    }

    public BeanMethod[] getFinalBeanMethods() {
        ArrayList<BeanMethod> finalBeanMethods = new ArrayList<BeanMethod>();
        for (BeanMethod beanMethod : this.beanMethods) {
            if (((Bean)beanMethod.getMetadata()).allowOverriding()) continue;
            finalBeanMethods.add(beanMethod);
        }
        return finalBeanMethods.toArray(new BeanMethod[finalBeanMethods.size()]);
    }

    public boolean containsBeanMethod(String beanMethodName) {
        Assert.hasText((String)beanMethodName, (String)"beanMethodName must be non-empty");
        for (BeanMethod beanMethod : this.beanMethods) {
            if (!beanMethod.getName().equals(beanMethodName)) continue;
            return true;
        }
        return false;
    }

    public ConfigurationClass addImportedClass(ConfigurationClass importedClass) {
        this.importedClasses.add(importedClass);
        return this;
    }

    public ConfigurationClass addPluginAnnotation(Annotation pluginAnno) {
        this.pluginAnnotations.add(pluginAnno);
        return this;
    }

    public Collection<ConfigurationClass> getSelfAndAllImports() {
        ArrayList<ConfigurationClass> selfAndAllImports = new ArrayList<ConfigurationClass>();
        for (ConfigurationClass importedClass : this.importedClasses) {
            selfAndAllImports.addAll(importedClass.getSelfAndAllImports());
        }
        selfAndAllImports.add(this);
        return selfAndAllImports;
    }

    public ConfigurationClass setDeclaringClass(ConfigurationClass configurationClass) {
        this.declaringClass = configurationClass;
        return this;
    }

    public ConfigurationClass getDeclaringClass() {
        return this.declaringClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ConfigurationClass setModifiers(int modifiers) {
        Assert.isTrue((modifiers >= 0 ? 1 : 0) != 0, (String)"modifiers must be non-negative");
        this.modifiers = modifiers;
        return this;
    }

    public Configuration getMetadata() {
        return this.metadata;
    }

    public ConfigurationClass setMetadata(Configuration configAnno) {
        this.metadata = configAnno;
        return this;
    }

    public void detectUsageErrors(List<UsageError> errors) {
        for (ConfigurationClass configurationClass : this.importedClasses) {
            configurationClass.detectUsageErrors(errors);
        }
        if (this.metadata == null) {
            errors.add(new NonAnnotatedConfigurationError());
        }
        if (Modifier.isFinal(this.modifiers)) {
            errors.add(new FinalConfigurationError());
        }
        for (LinkedHashSet linkedHashSet : this.javaConfigMethods.values()) {
            if (linkedHashSet.size() <= 1) continue;
            JavaConfigMethod primaryAnnotatedMethod = null;
            for (JavaConfigMethod method : linkedHashSet) {
                if (primaryAnnotatedMethod == null) {
                    primaryAnnotatedMethod = method;
                    continue;
                }
                JavaConfigMethod javaConfigMethod = primaryAnnotatedMethod;
                javaConfigMethod.getClass();
                errors.add(new JavaConfigMethod.IncompatibleAnnotationError(javaConfigMethod, method.getMetadata()));
            }
        }
        for (BeanMethod beanMethod : this.beanMethods) {
            beanMethod.detectUsageErrors(errors);
        }
        for (ExternalBeanMethod externalBeanMethod : this.externalBeanMethods) {
            externalBeanMethod.detectUsageErrors(errors);
        }
        for (ExternalValueMethod externalValueMethod : this.externalValueMethods) {
            externalValueMethod.detectUsageErrors(errors);
        }
        for (AutoBeanMethod autoBeanMethod : this.autoBeanMethods) {
            autoBeanMethod.detectUsageErrors(errors);
        }
        for (NonJavaConfigMethod nonJavaConfigMethod : this.nonJavaConfigMethods) {
            nonJavaConfigMethod.detectUsageErrors(errors);
        }
    }

    @Override
    public String toString() {
        return String.format("%s; modifiers=%d; beanMethods=%s; externalBeanMethods=%s;externalValueMethods=%s; autoBeanMethods=%s", super.toString(), this.modifiers, this.beanMethods, this.externalBeanMethods, this.externalValueMethods, this.autoBeanMethods);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.autoBeanMethods == null ? 0 : this.autoBeanMethods.hashCode());
        result = 31 * result + (this.beanMethods == null ? 0 : this.beanMethods.hashCode());
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.externalBeanMethods == null ? 0 : this.externalBeanMethods.hashCode());
        result = 31 * result + (this.externalValueMethods == null ? 0 : this.externalValueMethods.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.importedClasses == null ? 0 : this.importedClasses.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + this.modifiers;
        result = 31 * result + (this.nonJavaConfigMethods == null ? 0 : this.nonJavaConfigMethods.hashCode());
        result = 31 * result + (this.pluginAnnotations == null ? 0 : this.pluginAnnotations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationClass other = (ConfigurationClass)obj;
        if (this.autoBeanMethods == null ? other.autoBeanMethods != null : !this.autoBeanMethods.equals(other.autoBeanMethods)) {
            return false;
        }
        if (this.beanMethods == null ? other.beanMethods != null : !this.beanMethods.equals(other.beanMethods)) {
            return false;
        }
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.externalBeanMethods == null ? other.externalBeanMethods != null : !this.externalBeanMethods.equals(other.externalBeanMethods)) {
            return false;
        }
        if (this.externalValueMethods == null ? other.externalValueMethods != null : !this.externalValueMethods.equals(other.externalValueMethods)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.importedClasses == null ? other.importedClasses != null : !this.importedClasses.equals(other.importedClasses)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.modifiers != other.modifiers) {
            return false;
        }
        if (this.nonJavaConfigMethods == null ? other.nonJavaConfigMethods != null : !this.nonJavaConfigMethods.equals(other.nonJavaConfigMethods)) {
            return false;
        }
        return !(this.pluginAnnotations == null ? other.pluginAnnotations != null : !this.pluginAnnotations.equals(other.pluginAnnotations));
    }

    public boolean hasMethod(String methodName) {
        return this.getMethod(methodName) != null;
    }

    public ModelMethod getMethod(String methodName) {
        for (BeanMethod beanMethod : this.beanMethods) {
            if (!methodName.equals(beanMethod.getName())) continue;
            return beanMethod;
        }
        for (ExternalBeanMethod externalBeanMethod : this.externalBeanMethods) {
            if (!methodName.equals(externalBeanMethod.getName())) continue;
            return externalBeanMethod;
        }
        for (ExternalValueMethod externalValueMethod : this.externalValueMethods) {
            if (!methodName.equals(externalValueMethod.getName())) continue;
            return externalValueMethod;
        }
        for (AutoBeanMethod autoBeanMethod : this.autoBeanMethods) {
            if (!methodName.equals(autoBeanMethod.getName())) continue;
            return autoBeanMethod;
        }
        for (NonJavaConfigMethod nonJavaConfigMethod : this.nonJavaConfigMethods) {
            if (!methodName.equals(nonJavaConfigMethod.getName())) continue;
            return nonJavaConfigMethod;
        }
        return null;
    }

    public class FinalConfigurationError
    extends UsageError {
        public FinalConfigurationError() {
            super(ConfigurationClass.this, -1);
        }

        public String getDescription() {
            return String.format("@%s class may not be final. Remove the final modifier to continue.", Configuration.class.getSimpleName());
        }
    }

    public class IllegalBeanOverrideError
    extends UsageError {
        private final ConfigurationClass authoritativeClass;
        private final BeanMethod finalMethodInQuestion;

        public IllegalBeanOverrideError(ConfigurationClass violatingClass, BeanMethod finalMethodInQuestion) {
            super(violatingClass, -1);
            this.authoritativeClass = ConfigurationClass.this;
            this.finalMethodInQuestion = finalMethodInQuestion;
        }

        public String getDescription() {
            return String.format("Illegal attempt by '%s' to override bean definition originally specified by %s.%s. Consider removing 'allowOverride=false' from original method.", this.finalMethodInQuestion.getName(), this.authoritativeClass.getSimpleName(), this.finalMethodInQuestion.getName());
        }
    }

    public class InvalidPluginException
    extends UsageError {
        private final Annotation invalidPluginAnnotation;

        public InvalidPluginException(Annotation invalidPluginAnnotation) {
            super(ConfigurationClass.this, -1);
            this.invalidPluginAnnotation = invalidPluginAnnotation;
        }

        public String getDescription() {
            return String.format("Annotation [%s] was not annotated with @Plugin", this.invalidPluginAnnotation);
        }
    }

    public class NonAnnotatedConfigurationError
    extends UsageError {
        public NonAnnotatedConfigurationError() {
            super(ConfigurationClass.this, -1);
        }

        public String getDescription() {
            return String.format("%s was provided as a Java Configuration class but was not annotated with @%s. Update the class definition to continue.", ConfigurationClass.this.getSimpleName(), Configuration.class.getSimpleName());
        }
    }

    @Configuration
    private class Prototype {
        private Prototype() {
        }
    }
}

