/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.process;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildContextRefreshingListener
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog(ChildContextRefreshingListener.class);
    private final AbstractApplicationContext parent;
    private final AbstractApplicationContext child;
    private final List<String> ignoredBeanPostProcessors;

    public ChildContextRefreshingListener(AbstractApplicationContext parent, AbstractApplicationContext child, List<String> ignoredBeanPostProcessors) {
        this.parent = parent;
        this.child = child;
        this.ignoredBeanPostProcessors = ignoredBeanPostProcessors;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event.getSource() != this.parent) {
            return;
        }
        if (event instanceof ContextRefreshedEvent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Caught ContextRefreshedEvent from parent application context [%s], now refreshing [%s]", this.parent.getDisplayName(), this.child.getDisplayName()));
            }
            this.copyBeanFactoryPostProcessors();
            this.child.setParent((ApplicationContext)this.parent);
            this.child.refresh();
            return;
        }
        if (event instanceof ContextClosedEvent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Caught ContextClosedEvent from parent application context [%s], now closing [%s]", this.parent.getDisplayName(), this.child.getDisplayName()));
            }
            this.child.close();
            return;
        }
    }

    private void copyBeanFactoryPostProcessors() {
        for (Object bfpp : this.parent.getBeanFactoryPostProcessors()) {
            this.doCopyBeanFactoryPostProcessor((BeanFactoryPostProcessor)bfpp);
        }
        ConfigurableListableBeanFactory parentBF = this.parent.getBeanFactory();
        Map bfpps = parentBF.getBeansOfType(BeanFactoryPostProcessor.class);
        for (String bfppName : bfpps.keySet()) {
            if (!parentBF.containsBeanDefinition(bfppName) || parentBF.getBeanDefinition(bfppName).getAttribute("COPY_HIDDEN") == null) continue;
            this.doCopyBeanFactoryPostProcessor((BeanFactoryPostProcessor)bfpps.get(bfppName));
        }
    }

    private void doCopyBeanFactoryPostProcessor(BeanFactoryPostProcessor postProcessor) {
        if (this.ignoredBeanPostProcessors.contains(postProcessor.getClass().getName())) {
            return;
        }
        logger.debug((Object)String.format("copying BeanFactoryPostProcessor %s to child context %s", postProcessor, this.child));
        this.child.addBeanFactoryPostProcessor(postProcessor);
    }
}

