/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.naming;

import org.springframework.config.java.model.ModelClass;
import org.springframework.config.java.model.ModelMethod;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.util.Assert;

public class MethodNameStrategy
implements BeanNamingStrategy {
    private Prefix prefix = Prefix.NONE;

    public MethodNameStrategy() {
    }

    public MethodNameStrategy(Prefix prefix) {
        this.prefix = prefix;
    }

    public String getBeanName(ModelMethod modelMethod) {
        Assert.notNull((Object)modelMethod, (String)"modelMethod is required");
        String beanName = modelMethod.getName();
        ModelClass declaringClass = modelMethod.getDeclaringClass();
        Assert.notNull((Object)declaringClass, (String)("declaringClass was not specified for " + modelMethod));
        switch (this.prefix) {
            case CLASS: {
                beanName = declaringClass.getSimpleName().concat(".").concat(beanName);
                break;
            }
            case FQN: {
                beanName = declaringClass.getName().concat(".").concat(beanName);
                break;
            }
        }
        return beanName;
    }

    public void setPrefix(Prefix prefix) {
        this.prefix = prefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prefix {
        NONE(0),
        CLASS(1),
        FQN(2);

        private final int value;

        private Prefix(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

