/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.plugin.aop;

import org.springframework.aop.config.AopConfigUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.plugin.ProxyTargetClass;
import org.springframework.config.java.plugin.aop.AspectJAutoProxyDeclaration;

abstract class AopNamespaceUtils {
    public static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";

    AopNamespaceUtils() {
    }

    public static void registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, AspectJAutoProxyDeclaration declaration) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry, null);
        AopNamespaceUtils.useClassProxyingIfNecessary(registry, null);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, registry);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, AspectJAutoProxyDeclaration declaration) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAspectJAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry, null);
        AopNamespaceUtils.useClassProxyingIfNecessary(registry, declaration);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, null);
    }

    public static void registerAspectJAnnotationAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, AspectJAutoProxyDeclaration declaration) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry, null);
        AopNamespaceUtils.useClassProxyingIfNecessary(registry, declaration);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, registry);
    }

    @Deprecated
    public static void registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, Object source) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry, (Object)source);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, registry);
    }

    @Deprecated
    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        AopConfigUtils.forceAutoProxyCreatorToUseClassProxying((BeanDefinitionRegistry)registry);
    }

    private static void useClassProxyingIfNecessary(BeanDefinitionRegistry registry, AspectJAutoProxyDeclaration declaration) {
        if (declaration.getProxyTargetClass() == ProxyTargetClass.TRUE) {
            AopConfigUtils.forceAutoProxyCreatorToUseClassProxying((BeanDefinitionRegistry)registry);
        }
    }

    private static void registerComponentIfNecessary(BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        if (beanDefinition != null) {
            registry.registerBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator", beanDefinition);
        }
    }
}

