/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.FilterHelper;
import org.apache.tools.ant.BuildException;

public class IvyResolve
extends IvyTask {
    private File file = null;
    private String conf = null;
    private String organisation = null;
    private String module = null;
    private String revision = null;
    private String pubdate = null;
    private boolean inline = false;
    private boolean haltOnFailure = true;
    private boolean useCacheOnly = false;
    private String type = null;
    private boolean transitive = true;
    private boolean refresh = false;
    private boolean changing = false;
    private Boolean keep = null;
    private String failureProperty = null;
    private boolean useOrigin = false;
    private String resolveId = null;
    private String log = "default";

    public boolean isUseOrigin() {
        return this.useOrigin;
    }

    public void setUseOrigin(boolean useOrigin) {
        this.useOrigin = useOrigin;
    }

    public String getDate() {
        return this.pubdate;
    }

    public void setDate(String pubdate) {
        this.pubdate = pubdate;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setCache(File cache) {
        this.cacheAttributeNotSupported();
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isHaltonfailure() {
        return this.haltOnFailure;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setShowprogress(boolean show) {
        Message.setShowProgress(show);
    }

    public boolean isUseCacheOnly() {
        return this.useCacheOnly;
    }

    public void setUseCacheOnly(boolean useCacheOnly) {
        this.useCacheOnly = useCacheOnly;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setFailurePropery(String failureProperty) {
        this.log("The 'failurepropery' attribute is deprecated. Please use the 'failureproperty' attribute instead", 1);
        this.setFailureProperty(failureProperty);
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        try {
            ResolveReport report;
            this.conf = this.getProperty(this.conf, settings, "ivy.configurations");
            this.type = this.getProperty(this.type, settings, "ivy.resolve.default.type.filter");
            String[] confs = this.splitConfs(this.conf);
            if (this.isInline()) {
                if (this.organisation == null) {
                    throw new BuildException("'organisation' is required when using inline mode");
                }
                if (this.module == null) {
                    throw new BuildException("'module' is required when using inline mode");
                }
                if (this.file != null) {
                    throw new BuildException("'file' not allowed when using inline mode");
                }
                if (!this.getAllowedLogOptions().contains(this.log)) {
                    throw new BuildException("invalid option for 'log': " + this.log + ". Available options are " + this.getAllowedLogOptions());
                }
                for (int i = 0; i < confs.length; ++i) {
                    if (!"*".equals(confs[i])) continue;
                    confs[i] = "*(public)";
                }
                if (this.revision == null) {
                    this.revision = "latest.integration";
                }
                report = ivy.resolve(ModuleRevisionId.newInstance(this.organisation, this.module, this.revision), this.getResolveOptions(ivy, confs, settings), this.changing);
            } else {
                if (this.organisation != null) {
                    throw new BuildException("'organisation' not allowed when not using 'org' attribute");
                }
                if (this.module != null) {
                    throw new BuildException("'module' not allowed when not using 'org' attribute");
                }
                if (this.file == null) {
                    this.file = this.getProject().resolveFile(this.getProperty(settings, "ivy.dep.file"));
                }
                report = ivy.resolve(this.file.toURL(), this.getResolveOptions(ivy, confs, settings));
            }
            if (report.hasError()) {
                if (this.failureProperty != null) {
                    this.getProject().setProperty(this.failureProperty, "true");
                }
                if (this.isHaltonfailure()) {
                    throw new BuildException("resolve failed - see output for details");
                }
            }
            this.setResolved(report, this.resolveId, this.isKeep());
            if (this.isKeep()) {
                ModuleDescriptor md = report.getModuleDescriptor();
                this.getProject().setProperty("ivy.organisation", md.getModuleRevisionId().getOrganisation());
                settings.setVariable("ivy.organisation", md.getModuleRevisionId().getOrganisation());
                this.getProject().setProperty("ivy.module", md.getModuleRevisionId().getName());
                settings.setVariable("ivy.module", md.getModuleRevisionId().getName());
                this.getProject().setProperty("ivy.revision", md.getResolvedModuleRevisionId().getRevision());
                settings.setVariable("ivy.revision", md.getResolvedModuleRevisionId().getRevision());
                boolean hasChanged = report.hasChanged();
                this.getProject().setProperty("ivy.deps.changed", String.valueOf(hasChanged));
                settings.setVariable("ivy.deps.changed", String.valueOf(hasChanged));
                if (this.conf.trim().equals("*")) {
                    this.getProject().setProperty("ivy.resolved.configurations", this.mergeConfs(md.getConfigurationsNames()));
                    settings.setVariable("ivy.resolved.configurations", this.mergeConfs(md.getConfigurationsNames()));
                } else {
                    this.getProject().setProperty("ivy.resolved.configurations", this.conf);
                    settings.setVariable("ivy.resolved.configurations", this.conf);
                }
                if (this.file != null) {
                    this.getProject().setProperty("ivy.resolved.file", this.file.getAbsolutePath());
                    settings.setVariable("ivy.resolved.file", this.file.getAbsolutePath());
                }
                if (this.resolveId != null) {
                    this.getProject().setProperty("ivy.organisation." + this.resolveId, md.getModuleRevisionId().getOrganisation());
                    settings.setVariable("ivy.organisation." + this.resolveId, md.getModuleRevisionId().getOrganisation());
                    this.getProject().setProperty("ivy.module." + this.resolveId, md.getModuleRevisionId().getName());
                    settings.setVariable("ivy.module." + this.resolveId, md.getModuleRevisionId().getName());
                    this.getProject().setProperty("ivy.revision." + this.resolveId, md.getResolvedModuleRevisionId().getRevision());
                    settings.setVariable("ivy.revision." + this.resolveId, md.getResolvedModuleRevisionId().getRevision());
                    this.getProject().setProperty("ivy.deps.changed." + this.resolveId, String.valueOf(hasChanged));
                    settings.setVariable("ivy.deps.changed." + this.resolveId, String.valueOf(hasChanged));
                    if (this.conf.trim().equals("*")) {
                        this.getProject().setProperty("ivy.resolved.configurations." + this.resolveId, this.mergeConfs(md.getConfigurationsNames()));
                        settings.setVariable("ivy.resolved.configurations." + this.resolveId, this.mergeConfs(md.getConfigurationsNames()));
                    } else {
                        this.getProject().setProperty("ivy.resolved.configurations." + this.resolveId, this.conf);
                        settings.setVariable("ivy.resolved.configurations." + this.resolveId, this.conf);
                    }
                    this.getProject().setProperty("ivy.resolved.file." + this.resolveId, this.file.getAbsolutePath());
                    settings.setVariable("ivy.resolved.file." + this.resolveId, this.file.getAbsolutePath());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given ivy file to url: " + this.file + ": " + e, (Throwable)e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e, (Throwable)e);
        }
        catch (ResolveProcessException e) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + e, (Throwable)e);
        }
    }

    protected Collection getAllowedLogOptions() {
        return Arrays.asList("default", "download-only", "quiet");
    }

    private ResolveOptions getResolveOptions(Ivy ivy, String[] confs, IvySettings settings) {
        if (this.useOrigin) {
            settings.useDeprecatedUseOrigin();
        }
        return ((ResolveOptions)new ResolveOptions().setLog(this.log)).setConfs(confs).setValidate(this.doValidate(settings)).setArtifactFilter(FilterHelper.getArtifactTypeFilter(this.type)).setRevision(this.revision).setDate(this.getPubDate(this.pubdate, null)).setUseCacheOnly(this.useCacheOnly).setRefresh(this.refresh).setTransitive(this.transitive).setResolveId(this.resolveId);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    public boolean isKeep() {
        return this.keep == null ? this.organisation == null : this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setResolveId(String resolveId) {
        this.resolveId = resolveId;
    }
}

