/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.methodinjection;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import org.springframework.config.java.context.JavaConfigApplicationContext;

import test.common.beans.TestBean;

import test.common.config.BaseConfiguration;


/**
 * System test for JavaConfig's treatment of method injection.
 * <p/>
 *
 * See
 * http://static.springframework.org/spring/docs/2.5.x/reference/beans.html#beans-factory-method-injection<br/>
 * And http://www.jroller.com/Solomon/entry/spring_prototype_scope_lookup_methods
 *
 * @author  Chris Beams
 */
public class MethodInjectionTests {

    @Test
    public void testMethodOverrideWithJava() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(MethodOverrideConfiguration.class);

        assertTrue(ctx.containsBean(MethodOverrideConfiguration.class.getName()));

        TestBean tom = ctx.getBean(TestBean.class, "tom");
        assertEquals("overridden", tom.getName());
    }

    public static class MethodOverrideConfiguration extends BaseConfiguration {
        @Override
        public TestBean tom() {
            return new TestBean() {
                @Override
                public String getName() { return "overridden"; }
            };
        }
    }

}
