/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.plugin.tx.annotationdriven;

import static org.junit.Assert.assertTrue;
import static org.springframework.aop.config.AopConfigUtils.AUTO_PROXY_CREATOR_BEAN_NAME;
import static org.springframework.config.java.plugin.tx.GeneralizedAnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME;

import javax.sql.DataSource;

import org.junit.Test;
import org.springframework.aop.support.AopUtils;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.plugin.tx.AnnotationDrivenTx;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.Transactional;

import test.common.dataaccess.DummyDataSource;


/** TODO: JAVADOC */
public class AnnotationDrivenTxTests {
    @Test
    public void testBasicConfiguration() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(TxConfig.class);

        assertTrue("should have contained bean named: " + TRANSACTION_ADVISOR_BEAN_NAME,
                    ctx.containsBeanDefinition(TRANSACTION_ADVISOR_BEAN_NAME));

        assertTrue("should have contained bean named: " + AUTO_PROXY_CREATOR_BEAN_NAME,
                    ctx.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME));

        AccountService service = ctx.getBean(AccountService.class);

        assertTrue("'service' bean should have been proxied", AopUtils.isAopProxy(service));
    }

    @Configuration
    @AnnotationDrivenTx(transactionManager="txManager")
    static class TxConfig {
        @Bean
        public DataSourceTransactionManager txManager() {
            return new DataSourceTransactionManager(dataSource());
        }

        @Bean
        public DataSource dataSource() {
            return new DummyDataSource();
        }

        @Bean
        public DefaultAccountService accountService() {
            return new DefaultAccountService();
        }
    }

    static class DefaultAccountService implements AccountService {
        public Object getAccount() {
            return new Object();
        }
    }

    static interface AccountService {
        @Transactional
        Object getAccount();
    }
}
