/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.plugin.tx.annotationdriven;

import javax.sql.DataSource;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;

import test.common.dataaccess.DummyDataSource;


/**
 * Irreducible configuration that causes the issue tested by
 * {@link MultipleSingletonRegistrationBugTests}
 *
 * @author Chris Beams
 */
@Configuration
class Config2 {

    @Bean
    public Object transactionManager() {
        //System.out.println("Config2.transactionManager()");
        return new Object();
    }

    @Bean
    public Object foo() {
        //System.out.println("Config2.foo()");
        return "foo";
    }

    @Bean
    public DataSource dataSource() {
        //System.out.println("Config2.dataSource()");
        return new DummyDataSource();
    }

}
