/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.annotation;

import static java.lang.String.format;
import static org.springframework.util.ClassUtils.getPackageName;

import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.core.annotation.AnnotationUtils;


class ImportXmlHandler implements ConfigurationPlugin<ImportXml> {

    public void handle(ImportXml importXml, BeanDefinitionRegistry registry) {
        BeanDefinitionReader reader = new XmlBeanDefinitionReader(registry);

        String[] locations = importXml.locations();

        Object defaultRelativeClass = AnnotationUtils.getDefaultValue(importXml, "relativeTo");
        Class<?> relativeClass = importXml.relativeTo();
        if(relativeClass != defaultRelativeClass)
            // user has specified a class to use for relative pathing -> prefix all locations with the package path
            for (int i=0; i<locations.length; i++)
                locations[i] = format("%s/%s", getPackageName(relativeClass).replace('.', '/'), locations[i]);

        reader.loadBeanDefinitions(locations);
    }

}
