/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.annotation.valuesource;

import static java.lang.String.format;
import static org.springframework.beans.factory.support.BeanDefinitionBuilder.rootBeanDefinition;
import static org.springframework.util.ClassUtils.getPackageName;

import java.io.IOException;
import java.util.Properties;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.valuesource.PropertiesValueResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;


/** TODO: JAVADOC */
class PropertiesValueSourceHandler extends AbstractValueSourceHandler<PropertiesValueSource> {

    @Override
    public BeanDefinition doHandle(PropertiesValueSource anno, BeanDefinitionRegistry registry) {
        String[] locations = anno.locations();

        // TODO: consolidate with same code from ImportXmlHandler
        Object defaultRelativeTo = AnnotationUtils.getDefaultValue(anno, "relativeTo");
        Class<?> relativeTo = anno.relativeTo();
        if(relativeTo != defaultRelativeTo)
            // user has specified a class to use for relative pathing -> prefix all locations with the package path
            for (int i=0; i<locations.length; i++)
                locations[i] = format("%s/%s", getPackageName(relativeTo).replace('.', '/'), locations[i]);

        DefaultResourceLoader rl = new DefaultResourceLoader();

        Properties props = new Properties();

        try {
            for (String location : locations) {
                PropertiesLoaderUtils.fillProperties(props, rl.getResource(location));
            }
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }

        return rootBeanDefinition(PropertiesValueResolver.class)
            .addConstructorArgValue(props)
                .getBeanDefinition();
    }

}
