/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;

public class Annotation
extends ArrayCoreMap {
    private static final long serialVersionUID = 1L;

    public Annotation(Annotation map) {
        super(map);
    }

    public Annotation copy() {
        return new Annotation(this);
    }

    public Annotation(String text) {
        this.set(CoreAnnotations.TextAnnotation.class, text);
    }

    @Override
    public String toString() {
        return (String)this.get(CoreAnnotations.TextAnnotation.class);
    }

    public Annotation(List<CoreMap> sentences) {
        this.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        ArrayList tokens = new ArrayList();
        StringBuilder text = new StringBuilder();
        for (CoreMap sentence : sentences) {
            List sentenceTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            tokens.addAll(sentenceTokens);
            if (sentence.containsKey(CoreAnnotations.TextAnnotation.class)) {
                text.append((String)sentence.get(CoreAnnotations.TextAnnotation.class));
                continue;
            }
            if (text.length() > 0) {
                text.append('\n');
            }
            text.append(Sentence.listToString(sentenceTokens));
        }
        this.set(CoreAnnotations.TokensAnnotation.class, tokens);
        this.set(CoreAnnotations.TextAnnotation.class, text.toString());
    }

    @Deprecated
    public Annotation() {
        super(12);
    }
}

