/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class CoNLLUUtils {
    public static HashMap<String, String> parseFeatures(String featureString) {
        HashMap<String, String> features = new HashMap<String, String>();
        if (!featureString.equals("_")) {
            String[] featValPairs;
            for (String p : featValPairs = featureString.split("\\|")) {
                String[] featValPair = p.split("=");
                features.put(featValPair[0], featValPair[1]);
            }
        }
        return features;
    }

    public static String toFeatureString(HashMap<String, String> features) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (features != null) {
            ArrayList<String> sortedKeys = new ArrayList<String>(features.keySet());
            Collections.sort(sortedKeys, new FeatureNameComparator());
            for (String key : sortedKeys) {
                if (!first) {
                    sb.append("|");
                } else {
                    first = false;
                }
                sb.append(key).append("=").append(features.get(key));
            }
        }
        if (first) {
            sb.append("_");
        }
        return sb.toString();
    }

    public static HashMap<String, String> parseExtraDeps(String extraDepsString) {
        HashMap<String, String> extraDeps = new HashMap<String, String>();
        if (!extraDepsString.equals("_")) {
            String[] extraDepParts;
            for (String extraDepString : extraDepParts = extraDepsString.split("\\|")) {
                int sepPos = extraDepString.indexOf(":");
                String reln = extraDepString.substring(sepPos + 1);
                String gov = extraDepString.substring(0, sepPos);
                extraDeps.put(gov, reln);
            }
        }
        return extraDeps;
    }

    public static String toExtraDepsString(HashMap<String, String> extraDeps) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (extraDeps != null) {
            ArrayList<String> sortedKeys = new ArrayList<String>(extraDeps.keySet());
            Collections.sort(sortedKeys, new DepIndexComparator());
            for (String key : sortedKeys) {
                if (!first) {
                    sb.append("|");
                } else {
                    first = false;
                }
                sb.append(key).append(":").append(extraDeps.get(key));
            }
        }
        if (first) {
            sb.append("_");
        }
        return sb.toString();
    }

    public static class DepIndexComparator
    implements Comparator<String> {
        @Override
        public int compare(String depIndex1, String depIndex2) {
            return Float.valueOf(depIndex1).compareTo(Float.valueOf(depIndex2));
        }
    }

    public static class FeatureNameComparator
    implements Comparator<String> {
        @Override
        public int compare(String featureName1, String featureName2) {
            return featureName1.toLowerCase().compareTo(featureName2.toLowerCase());
        }
    }
}

