/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

class ArabicLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    private static final int[] ZZ_CMAP_TOP = ArabicLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u0001\u0100\u0001\u0200\u0001\u0300\u0001\u0400\u0001\u0500\u0001\u0600\u0001\u0700\u0001\u0800\u0001\u0900\u0001\u0a00\u0001\u0b00\u0001\u0c00\u0001\u0d00\u0001\u0e00\u0001\u0f00\u0001\u1000\u0001\u1100\u0001\u1200\u0001\u1300\u0001\u1400\u0001\u1100\u0001\u1500\u0001\u1600\u0001\u1700\u0001\u1800\u0001\u1900\u0001\u1a00\u0001\u1b00\u0001\u1c00\u0001\u1100\u0001\u1d00\u0001\u1e00\u0001\u1f00\n\u2000\u0001\u2100\u0001\u2200\u0001\u2300\u0001\u2000\u0001\u2400\u0001\u2500\u0002\u2000\u0019\u1100\u0001\u2600Q\u1100\u0001\u2700\u0004\u1100\u0001\u2800\u0001\u1100\u0001\u2900\u0001\u2a00\u0001\u2b00\u0001\u2c00\u0001\u2d00\u0001\u2e00+\u1100\u0001\u2f00\b\u3000\u0019\u2000\u0001\u1100\u0001\u3100\u0001\u3200\u0001\u1100\u0001\u3300\u0001\u3400\u0001\u3500\u0001\u3600\u0001\u2000\u0001\u3700\u0001\u3800\u0001\u3900\u0001\u3a00\u0001\u1100\u0001\u3b00\u0001\u3c00\u0001\u3d00\u0001\u3e00\u0001\u3f00\u0001\u4000\u0001\u4100\u0001\u2000\u0001\u4200\u0001\u4300\u0001\u4400\u0001\u4500\u0001\u4600\u0001\u4700\u0001\u4800\u0001\u4900\u0001\u4a00\u0001\u4b00\u0001\u4c00\u0001\u4d00\u0001\u2000\u0001\u4e00\u0001\u4f00\u0001\u5000\u0001\u2000\u0003\u1100\u0001\u5100\u0001\u5200\u0001\u5300\n\u2000\u0004\u1100\u0001\u5400\u000f\u2000\u0002\u1100\u0001\u5500!\u2000\u0002\u1100\u0001\u5600\u0001\u5700\u0002\u2000\u0001\u5800\u0001\u5900\u0017\u1100\u0001\u5a00\u0002\u1100\u0001\u5b00%\u2000\u0001\u1100\u0001\u5c00\u0001\u5d00\t\u2000\u0001\u5e00\u0017\u2000\u0001\u5f00\u0001\u6000\u0001\u6100\u0001\u6200\t\u2000\u0001\u6300\u0001\u6400\u0005\u2000\u0001\u6500\u0001\u6600\u0004\u2000\u0001\u6700\u0011\u2000\u00a6\u1100\u0001\u6800\u0010\u1100\u0001\u6900\u0001\u6a00\u0015\u1100\u0001\u6b00\u001c\u1100\u0001\u6c00\f\u2000\u0002\u1100\u0001\u6d00\u0e05\u2000";
    private static final int[] ZZ_CMAP_BLOCKS = ArabicLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0012\u0000\u0001\u0001\u0001\u0006\u0001\u0007\u0005\b\u0002\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\n\u000e\u0001\u000f\u0001\b\u0001\u0007\u0001\b\u0001\u0007\u0001\u0006\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0011\u0001\u0016\u0001\u0017\u0003\u0011\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0011\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001\u0011\u0001!\u0003\u0011\u0001\"\u0001#\u0001$\u0001\b\u0001%\u0001\b\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0011\u0001\u0016\u0001\u0017\u0003\u0011\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0011\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001\u0011\u0001!\u0003\u0011\u0001&\u0001\u0007\u0001&\u0001\b\u0006\u0000\u0001\u0003\u001a\u0000\u0001'\t\b\u0001(\u0002\b\u0001(\u0007\b\u0001(\u0004\b\u0001(\u0005\b\u0017)\u0001\u0000\u001f)\u0001\u0000\u0087)\u0001*\u01fe)\u0001\u0000\u0001)\u0004\u0000\u0003)\u0001\u0000\u0003)\u0001\u0000\u0001)\u0001\u0000\u0014)\u0001\u0000\u00df)\u0001\u0000\u0005)\u0002\u0000\u00a6)\u0001\u0000&)\u0002\u00000)\b\u0000-)\u0001\u0000\u0001)\u0001\u0000\u0002)\u0001\u0000\u0002)\u0001\u0000\u0001)\b\u0000\u001b)\u0004\u0000\u0004)\r\u0000\f\b\u0001+\u0001#\r,\u0005\b\u0001)#-\u0001.\u0001-\u0001/\u0004-\u0004,\u00010\u000f,\u0001\u0000\n1\u0001\b\u0002#\u0001\b\u0002-\u0001,c-\u0001\b\u0001-\u000f,\u0002-\u0007,\u0002-\n1\u0003-\u0002,\u0001-\u000f\u0000\u00a3)\u000e\u0000\n1,)\u0004\u0000\u0001)\u0005\u0000\u0016)\u0004\u0000\u0001)\t\u0000\u0001)\u0003\u0000\u0001)\u0017\u0000\u0019)\u0007\u0000\u000b)5\u0000\u0015)\u0001\u0000\b)B\u0000:)\u0002\u0000\u0013)\u0001\u0000\u0006)\u0002\u0000\f)\u0002\u0000\n1\u0001\u0000\u0013)\u0001\u0000\b)\u0002\u0000\u0002)\u0002\u0000\u0016)\u0001\u0000\u0007)\u0001\u0000\u0001)\u0003\u0000\u0004)\u0002\u0000\t)\u0002\u0000\u0002)\u0002\u0000\u0004)\b\u0000\u0001)\u0004\u0000\u0002)\u0001\u0000\u0005)\u0002\u0000\n1\u0002)\n\u0000\u0001)\u0004\u0000\u0003)\u0001\u0000\u0006)\u0004\u0000\u0002)\u0002\u0000\u0016)\u0001\u0000\u0007)\u0001\u0000\u0002)\u0001\u0000\u0002)\u0001\u0000\u0002)\u0002\u0000\u0001)\u0001\u0000\u0012)\t\u0000\u0004)\u0001\u0000\u0001)\u0007\u0000\n1\u0002\u0000\u0003)\f\u0000\u0003)\u0001\u0000\t)\u0001\u0000\u0003)\u0001\u0000\u0016)\u0001\u0000\u0007)\u0001\u0000\u0002)\u0001\u0000\u0005)\u0002\u0000\u0015)\u000f\u0000\u0002)\u0004\u0000\n1\t\u0000\u0001)\u000b\u0000\b)\u0002\u0000\u0002)\u0002\u0000\u0016)\u0001\u0000\u0007)\u0001\u0000\u0002)\u0001\u0000\u0005)\u0003\u0000\u0001)\u001e\u0000\u0002)\u0001\u0000\u0003)\u0004\u0000\n1\u0001\u0000\u0001)\u0010\u0000\u0002)\u0001\u0000\u0006)\u0003\u0000\u0003)\u0001\u0000\u0004)\u0003\u0000\u0002)\u0001\u0000\u0001)\u0001\u0000\u0002)\u0003\u0000\u0002)\u0003\u0000\u0003)\u0003\u0000\f)\u0004\u0000\u0005)\u0003\u0000\u0003)\u0001\u0000\u0004)\u0002\u0000\u0001)\u0015\u0000\n1\u0011\u0000\u0003)\u0001\u0000\b)\u0001\u0000\u0003)\u0001\u0000\u0017)\u0001\u0000\u0010)\u0003\u0000\u001a)\u0001\u0000\u0003)\u0005\u0000\u0002)\u0004\u0000\n1\u0010\u0000\u0001)\u0004\u0000\b)\u0001\u0000\u0003)\u0001\u0000\u0017)\u0001\u0000\n)\u0001\u0000\u0005)\u0003\u0000\u0001) \u0000\u0001)\u0001\u0000\u0002)\u0004\u0000\n1\u0001\u0000\u0002)\u0012\u0000\b)\u0001\u0000\u0003)\u0001\u0000))\u0002\u0000\b)\u0001\u0000\u0003)\u0005\u0000\u0001)\u0005\u0000\u0003)\b\u0000\u0003)\u0004\u0000\n1\n\u0000\u0006)\u0005\u0000\u0012)\u0003\u0000\u0018)\u0001\u0000\t)\u0001\u0000\u0001)\u0002\u0000\u0007)\u001f\u0000\n1\u0011\u0000:)\u0005\u0000\u000f)\u0001\u0000\n1'\u0000\u0002)\u0001\u0000\u0001)\u0001\u0000\u0005)\u0001\u0000\u0018)\u0001\u0000\u0001)\u0001\u0000\u0017)\u0002\u0000\u0005)\u0001\u0000\u0001)\u0001\u0000\u0006)\u0002\u0000\n1\u0002\u0000\u0004) \u0000\u0001)\u001f\u0000\n1\u0016\u0000\b)\u0001\u0000$)\u001b\u0000\u0005)s\u0000+)\u0014\u0000\u0001)\n1\u0006\u0000\u0006)\u0004\u0000\u0004)\u0003\u0000\u0001)\u0003\u0000\u0002)\u0007\u0000\u0003)\u0004\u0000\r)\f\u0000\u0001)\u0001\u0000\n1\u0006\u0000&)\u0001\u0000\u0001)\u0005\u0000\u0001)\u0002\u0000+)\u0001\u0000\u014d)\u0001\u0000\u0004)\u0002\u0000\u0007)\u0001\u0000\u0001)\u0001\u0000\u0004)\u0002\u0000))\u0001\u0000\u0004)\u0002\u0000!)\u0001\u0000\u0004)\u0002\u0000\u0007)\u0001\u0000\u0001)\u0001\u0000\u0004)\u0002\u0000\u000f)\u0001\u00009)\u0001\u0000\u0004)\u0002\u0000C)%\u0000\u0010)\u0010\u0000V)\u0002\u0000\u0006)\u0003\u0000\u016c)\u0002\u0000\u0011)\u0001\u0000\u001a)\u0005\u0000K)\u0006\u0000\b)\u0007\u0000\r)\u0001\u0000\u0004)\u000e\u0000\u0012)\u000e\u0000\u0012)\u000e\u0000\r)\u0001\u0000\u0003)\u000f\u00004)#\u0000\u0001)\u0004\u0000\u0001)\u0003\u0000\n1&\u0000\n1\u0006\u0000Y)\u0007\u0000\u0005)\u0002\u0000\")\u0001\u0000\u0001)\u0005\u0000F)\n\u0000\u001f)'\u0000\n1\u001e)\u0002\u0000\u0005)\u000b\u0000,)\u0004\u0000\u001a)\u0006\u0000\n1&\u0000\u0017)\t\u00005)+\u0000\n1\u0006\u0000\n1\r\u0000\u0001)]\u0000/)\u0011\u0000\u0007)\u0004\u0000\n1)\u0000\u001e)\r\u0000\u0002)\n1,)\u001a\u0000$)\u001c\u0000\n1\u0003\u0000\u0003)\n1$)\u0002\u0000\t)\u0007\u0000+)\u0002\u0000\u0003))\u0000\u0004)\u0001\u0000\u0006)\u0001\u0000\u0002)\u0003\u0000\u0001)\u0005\u0000\u00c0)@\u0000\u0016)\u0002\u0000\u0006)\u0002\u0000&)\u0002\u0000\u0006)\u0002\u0000\b)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u001f)\u0002\u00005)\u0001\u0000\u0007)\u0001\u0000\u0001)\u0003\u0000\u0003)\u0001\u0000\u0007)\u0003\u0000\u0004)\u0002\u0000\u0006)\u0004\u0000\r)\u0005\u0000\u0003)\u0001\u0000\u0007)\u0003\u0000\u000b2\u0005\u0000\u0018\b\u0002\u0003\u0005\u0000\u00012/\b\u0012\u0000\u0001)\r\u0000\u0001)\u0010\u0000\r)\u0003\u0000\u0016\bL\u0000\u0001)\u0004\u0000\u0001)\u0002\u0000\n)\u0001\u0000\u0001)\u0003\u0000\u0005)\u0006\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0004)\u0001\u0000\u000b)\u0002\u0000\u0004)\u0005\u0000\u0005)\u0004\u0000\u0001)4\u0000\u0002)\u017b\u0000/)\u0001\u0000/)\u0001\u0000\u0085)\u0006\u0000\u0004)\u0003\u0000\u0002)\f\u0000&)\u0001\u0000\u0001)\u0005\u0000\u0001)\u0002\u00008)\u0007\u0000\u0001)\u0010\u0000\u0017)\t\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000\u0007)O\u0000\u0001\b\u0001)\u00d0\u0000\u00012\u0004\u0000\u0002)*\u0000\u0005)\u0005\u0000\u0002)\u0004\u0000V)\u0006\u0000\u0003)\u0001\u0000Z)\u0001\u0000\u0004)\u0005\u0000+)\u0001\u0000^)\u0011\u0000\u001b)5\u0000\u00c6)J\u0000\u00f0)\u0010\u0000\u008d)C\u0000.)\u0002\u0000\r)\u0003\u0000\u0010)\n1\u0002)\u0014\u0000/)\u0010\u0000\u001f)\u0002\u0000F)1\u0000\t)\u0002\u0000g)\u0002\u00005)\u0002\u0000\u0005)0\u0000\u000b)\u0001\u0000\u0003)\u0001\u0000\u0004)\u0001\u0000\u0017)\u001d\u00004)\u000e\u00002)\u001c\u0000\n1\u0018\u0000\u0006)\u0003\u0000\u0001)\u0001\u0000\u0002)\u0001\u0000\n1\u001c)\n\u0000\u0017)\u0019\u0000\u001d)\u0007\u0000/)\u001c\u0000\u0001)\n1\u0006\u0000\u0005)\u0001\u0000\n)\n1\u0005)\u0001\u0000))\u0017\u0000\u0003)\u0001\u0000\b)\u0004\u0000\n1\u0006\u0000\u0017)\u0003\u0000\u0001)\u0003\u00002)\u0001\u0000\u0001)\u0003\u0000\u0002)\u0002\u0000\u0005)\u0002\u0000\u0001)\u0001\u0000\u0001)\u0018\u0000\u0003)\u0002\u0000\u000b)\u0007\u0000\u0003)\f\u0000\u0006)\u0002\u0000\u0006)\u0002\u0000\u0006)\t\u0000\u0007)\u0001\u0000\u0007)\u0001\u0000+)\u0001\u0000\f)\b\u0000s)\r\u0000\n1\u0006\u0000\u00a4)\f\u0000\u0017)\u0004\u00001)\u0004\u0000\u01003n)\u0002\u0000j)&\u0000\u0007)\f\u0000\u0005)\u0005\u0000\u0001)\u0001\u0000\n)\u0001\u0000\r)\u0001\u0000\u0005)\u0001\u0000\u0001)\u0001\u0000\u0002)\u0001\u0000\u0002)\u0001\u0000l)!\u0000k)\u0012\u0000@)\u0002\u00006)(\u0000\f)t\u0000\u0005)\u0001\u0000\u0087)\u0013\u0000\n1\u0007\u0000\u001a)\u0006\u0000\u001a)\u000b\u0000Y)\u0003\u0000\u0006)\u0002\u0000\u0006)\u0002\u0000\u0006)\u0002\u0000\u0003)#\u0000\f)\u0001\u0000\u001a)\u0001\u0000\u0013)\u0001\u0000\u0002)\u0001\u0000\u000f)\u0002\u0000\u000e)\"\u0000{)\u0085\u0000\u001d)\u0003\u00001)/\u0000 )\r\u0000\u0014)\u0001\u0000\b)\u0006\u0000&)\n\u0000\u001e)\u0002\u0000$)\u0004\u0000\b)0\u0000\u009e)\u0002\u0000\n1\u0006\u0000$)\u0004\u0000$)\u0004\u0000()\b\u00004)\u009c\u00007)\t\u0000\u0016)\n\u0000\b)\u0098\u0000\u0006)\u0002\u0000\u0001)\u0001\u0000,)\u0001\u0000\u0002)\u0003\u0000\u0001)\u0002\u0000\u0017)\n\u0000\u0017)\t\u0000\u001f)A\u0000\u0013)\u0001\u0000\u0002)\n\u0000\u0016)\n\u0000\u001a)F\u00008)\u0006\u0000\u0002)@\u0000\u0001)\u000f\u0000\u0004)\u0001\u0000\u0003)\u0001\u0000\u001d)*\u0000\u001d)\u0003\u0000\u001d)#\u0000\b)\u0001\u0000\u001c)\u001b\u00006)\n\u0000\u0016)\n\u0000\u0013)\r\u0000\u0012)n\u0000I)7\u00003)\r\u00003)\r\u0000$)\f\u0000\n1\u00c6\u0000\u001d)\n\u0000\u0001)\b\u0000\u0016)\u009a\u0000\u0017)\f\u00005).\u0000\n1\u0013\u0000-) \u0000\u0019)\u0007\u0000\n1\t\u0000$)\u000f\u0000\n1\u0004\u0000\u0001)\u000b\u0000#)\u0003\u0000\u0001)\f\u00000)\u000e\u0000\u0004)\u000b\u0000\n1\u0001)\u0001\u0000\u0001)#\u0000\u0012)\u0001\u0000\u0019)T\u0000\u0007)\u0001\u0000\u0001)\u0001\u0000\u0004)\u0001\u0000\u000f)\u0001\u0000\n)\u0007\u0000/)\u0011\u0000\n1\u000b\u0000\b)\u0002\u0000\u0002)\u0002\u0000\u0016)\u0001\u0000\u0007)\u0001\u0000\u0002)\u0001\u0000\u0005)\u0003\u0000\u0001)\u0012\u0000\u0001)\f\u0000\u0005)\u009e\u00005)\u0012\u0000\u0004)\u0005\u0000\n1\u0005\u0000\u0001) \u00000)\u0014\u0000\u0002)\u0001\u0000\u0001)\b\u0000\n1\u00a6\u0000/))\u0000\u0004)$\u00000)\u0014\u0000\u0001)\u000b\u0000\n1&\u0000+)\r\u0000\u0001)\u0007\u0000\n16\u0000\u001b)\u0015\u0000\n1\u00c6\u0000,)t\u0000@)\n1\u0015\u0000\u0001)\u00a0\u0000\b)\u0002\u0000')\u0010\u0000\u0001)\u0001\u0000\u0001)\u001c\u0000\u0001)\n\u0000()\u0007\u0000\u0001)\u0015\u0000\u0001)\u000b\u0000.)\u0013\u0000\u0001)\"\u00009)\u0007\u0000\t)\u0001\u0000%)\u0011\u0000\u0001)\u000f\u0000\n1\u0018\u0000\u001e)p\u0000\u0007)\u0001\u0000\u0002)\u0001\u0000&)\u0015\u0000\u0001)\t\u0000\n1\u0006\u0000\u0006)\u0001\u0000\u0002)\u0001\u0000 )\u000e\u0000\u0001)\u0007\u0000\n1\u0136\u0000\u0013)\r\u0000\u009a)\u00e6\u0000\u00c4)\u00bc\u0000/)\u00d1\u0000G)\u00b9\u00009)\u0007\u0000\u001f)\u0001\u0000\n1f\u0000\u001e)\u0012\u00000)\u0010\u0000\u0004)\f\u0000\n1\t\u0000\u0015)\u0005\u0000\u0013)\u00b0\u0000@)\u0080\u0000K)\u0005\u0000\u0001)B\u0000\r)@\u0000\u0002)\u0001\u0000\u0001)\u001c\u0000\u00f8)\b\u0000\u00f3)\r\u0000\u001f)1\u0000\u0003)\u0011\u0000\u0004)\b\u0000\u018c)\u0004\u0000k)\u0005\u0000\r)\u0003\u0000\t)\u0007\u0000\n)f\u0000U)\u0001\u0000G)\u0001\u0000\u0002)\u0002\u0000\u0001)\u0002\u0000\u0002)\u0002\u0000\u0004)\u0001\u0000\f)\u0001\u0000\u0001)\u0001\u0000\u0007)\u0001\u0000A)\u0001\u0000\u0004)\u0002\u0000\b)\u0001\u0000\u0007)\u0001\u0000\u001c)\u0001\u0000\u0004)\u0001\u0000\u0005)\u0001\u0000\u0001)\u0003\u0000\u0007)\u0001\u0000\u0154)\u0002\u0000\u0019)\u0001\u0000\u0019)\u0001\u0000\u001f)\u0001\u0000\u0019)\u0001\u0000\u001f)\u0001\u0000\u0019)\u0001\u0000\u001f)\u0001\u0000\u0019)\u0001\u0000\u001f)\u0001\u0000\u0019)\u0001\u0000\b)\u0002\u000021-)\n\u0000\u0007)\u0002\u0000\n1\u0004\u0000\u0001)\u0171\u0000,)\u0004\u0000\n1\u0006\u0000\u00c5);\u0000D)\u0007\u0000\u0001)\u0004\u0000\n1\u00a6\u0000\u0004)\u0001\u0000\u001b)\u0001\u0000\u0002)\u0001\u0000\u0001)\u0002\u0000\u0001)\u0001\u0000\n)\u0001\u0000\u0004)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0006\u0000\u0001)\u0004\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0003)\u0001\u0000\u0002)\u0001\u0000\u0001)\u0002\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0001)\u0001\u0000\u0002)\u0001\u0000\u0001)\u0002\u0000\u0004)\u0001\u0000\u0007)\u0001\u0000\u0004)\u0001\u0000\u0004)\u0001\u0000\u0001)\u0001\u0000\n)\u0001\u0000\u0011)\u0005\u0000\u0003)\u0001\u0000\u0005)\u0001\u0000\u0011)D\u0000\u00d7))\u00005)\u000b\u0000\u00de)\u0002\u0000\u0182)\u000e\u0000\u0131)\u001f\u0000\u001e)\u00e2\u0000";
    private static final int[] ZZ_ACTION = ArabicLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0001\u0002\u0003\u0003\f\u0004\u0001\u0002\u0001\u0004\u0001\u0005\u0001\u0004\u0002\u0005\u0001\u0004\u0002\u0000\u0001\u0004\u0001\u0000\u0002\u0004\u0001\u0005\u0007\u0000\u0001\u0004\u0001\u0000\u0001\u0005\u0002\u0004\u0001\u0000\u0002\u0004\u0001\u0005\u0003\u0000\u0001\u0004\u0006\u0000\u0001\u0004\u0001\u0006\u0001\u0000\u0002\u0004\u0006\u0000\u0002\u0004\u0001\u0000\u0002\u0004\f\u0000\u0001\u0004\u0002\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0007\u0000\u0001\u0004\u0001\u0005\n\u0000\u0006\u0004\b\u0000\u0001\u0007\u0001\u0000\u0001\u0007\u0003\u0004\u0002\u0000\u0001\u0004\u0001\u0000\u0001\b\u0004\u0004\u0001\u0000\u0007\u0004";
    private static final int[] ZZ_ROWMAP = ArabicLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00004\u0000h\u0000\u009c\u00004\u0000\u00d0\u0000\u0104\u0000\u0138\u0000\u016c\u0000\u009c\u0000\u01a0\u0000\u01d4\u0000\u0208\u0000\u023c\u0000\u0270\u0000\u02a4\u0000\u02d8\u0000\u030c\u0000\u0340\u0000\u0374\u0000\u03a8\u00004\u0000\u03dc\u0000\u0410\u0000\u0444\u00004\u0000\u0478\u0000\u04ac\u0000\u04e0\u0000\u0514\u0000\u0548\u0000\u057c\u0000\u05b0\u0000\u05e4\u0000\u0618\u0000\u064c\u0000\u0680\u0000\u06b4\u0000\u06e8\u0000\u071c\u0000\u0750\u0000\u0784\u0000\u07b8\u0000\u07ec\u0000\u0820\u0000\u0854\u0000\u0888\u0000\u08bc\u0000\u08f0\u0000\u0924\u0000\u0958\u0000\u098c\u0000\u09c0\u0000\u09f4\u0000\u0a28\u0000\u0a5c\u0000\u0a90\u0000\u0ac4\u0000\u0af8\u0000\u05b0\u0000\u0b2c\u0000\u064c\u0000\u0680\u0000\u0b60\u0000\u0b94\u0000\u0bc8\u0000\u0bfc\u0000\u0c30\u0000\u0c64\u0000\u0c98\u0000\u0ccc\u0000\u0d00\u0000\u08f0\u0000\u0924\u0000\u0d34\u0000\u0d68\u0000\u0d9c\u0000\u0dd0\u0000\u0e04\u0000\u0e38\u0000\u0e6c\u0000\u0ea0\u0000\u0ed4\u0000\u0f08\u0000\u0f3c\u0000\u0f70\u0000\u0fa4\u0000\u0fd8\u0000\u100c\u0000\u1040\u0000\u1074\u0000\u10a8\u0000\u10dc\u0000\u1110\u0000\u1144\u0000\u1178\u0000\u11ac\u0000\u11e0\u0000\u1214\u0000\u1248\u0000\u127c\u0000\u12b0\u0000\u12e4\u0000\u1318\u0000\u134c\u0000\u1380\u0000\u13b4\u0000\u13e8\u0000\u141c\u0000\u1450\u0000\u1484\u0000\u14b8\u0000\u14ec\u0000\u1520\u0000\u1554\u0000\u1588\u0000\u15bc\u0000\u10a8\u0000\u15f0\u0000\u1624\u0000\u1658\u0000\u168c\u0000\u16c0\u0000\u16f4\u0000\u1728\u0000\u175c\u0000\u1790\u0000\u17c4\u0000\u17f8\u0000\u182c\u0000\u1860\u0000\u1894\u0000\u18c8\u0000\u18fc\u0000\u1930\u0000\u009c\u0000\u1790\u0000\u0c30\u0000\u0c64\u0000\u1964\u0000\u1998\u0000\u19cc\u0000\u1a00\u0000\u1a34\u0000\u1a68\u0000\u1a9c\u0000\u1ad0\u0000\u1b04";
    private static final int[] ZZ_TRANS = ArabicLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0006\u0001\u0007\u0001\b\u0002\t\u0001\n\u0001\u000b\u0001\f\u0001\t\u0001\r\u0002\t\u0006\u000e\u0001\u000f\t\u000e\u0001\u0010\u0001\u0011\u0002\t\u0001\u0012\u0001\b\u0001\u0013\u0001\u0014\u0002\u0015\u0001\u0016\u0001\u0017\u0003\u0018\u0001\u0017\u0001\u0019\u0001\u0013\u0002\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0019\u001a\u0001\u0000\r\u001a\u0001\u0000\u0001\u0003%\u0000\u0001\u0003\n\u0000\u0001\u00037\u0000\u0001\u00047\u0000\u0001\u00074\u0000\u0003\b\u0001\u0000\u0001\b\u0001\u0000\u0001\b\u0001\u0000\u0002\b\u0011\u0000\u0005\b\u0001\u0000\u0001\b\u000b\u0000\u0001\u001a\u0002\u0000\u0001\u001a\u0003\u0000\u0001\b\u0002\t\u0001\u0000\u0001\b\u0001\u001b\u0001\t\u0001\u001a\u0002\t\u0011\u001a\u0004\t\u0001\b\u0001\u001a\u0001\t\u000b\u001a\u0007\u0000\u0003\b\u0001\u0000\u0001\u001c\u0001\u0000\u0001\b\u0001\u0000\u0002\b\u0007\u0000\u0001\u001d\u0004\u0000\u0001\u001d\u0004\u0000\u0001\u001e\u0002\b\u0001\u001f\u0001\b\u0001\u0000\u0001\b\u0003\u0000\u0005 \u000f\u0000\u0001!'\u0000\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0001\"\u0001$\u0002%\u0001&\u0001$\u0001\r\u0001\"\u0001'\u0011(\u0001\"\u0001$\u0001\"\u0001$\u0001#\u0001\u001a\u0003\"\u0001$\u0005\"\u0001\r\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u0011\u000e\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u000e\u000e\u0001+\u0002\u000e\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u0010\u000e\u0001,\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0002\"\u0001\u001a\u0002\u0000\u0001\u001a\u0003\u0000\u0001\b\u0002\t\u0001\u0000\u0001\b\u0001\u001b\u0001\t\u0001\u001a\u0002\t\u0011\u001a\u0004\t\u0001\b\u0001\u001a\u0001\t\u0006\u001a\u0001-\u0005\u001a\u0002\u0000\u0001\u001a\u0003\u0000\u0001\b\u0001\t\u0001\u0012\u0001\u0000\u0001.\u0001\u001b\u0001\t\u0001/\u0002\t\u0011\u001a\u0003\t\u0001\u0012\u0001\b\u0001\u001a\u0001\t\u0003\u001a\u0005\u0017\u0001/\u0003\u001a\u0001\u0003\u0001\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0019\u001a\u0001\u0000\u0001\u0013\n\u001a\u0001\u0013\u0002\u001a\u0002\u0000\u0001\u001a\u0003\u0000\u0001\b\u0002\t\u0001\u0000\u0001\b\u0001\u001b\u0001\t\u0001\u001a\u0002\t\u0011\u0015\u0004\t\u0001\b\u0001\u001a\u0001\u0014\u0002\u0015\u0002\u001a\u0003\u0015\u0005\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0004\u001a\u0011\u0015\u0004\u001a\u0001\u0000\u0001\u001a\u0003\u0015\u0002\u001a\u0003\u0015\u0005\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0001\u001a\u0001\u0017\u0001\u0000\u00010\u0001\u001b\u0001\u001a\u0001/\u0016\u001a\u0001\u0017\u0001\u0000\u0005\u001a\u0005\u0017\u0001/\u0003\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0001\u001a\u0001\u0017\u0001\u0000\u00010\u0001\u001b\u0001\u001a\u0001/\u0002\u001a\u0011\u0015\u0003\u001a\u0001\u0017\u0001\u0000\u0001\u001a\u0003\u0015\u0001\u001a\u0001\u0017\u0003\u0018\u0001\u0017\u0001/\u0003\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0001\u001a\u00011\u00022\u00013\u00011\u0001\u0019\u0002\u001a\u00114\u0001\u001a\u00011\u0001\u001a\u00011\u0001\u0000\u0004\u001a\u00011\u0005\u001a\u0001\u0019\u0003\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0003\u0000\u0006\u001a\u00015\u0001\u001a\u00016\u0004\u001a\u00017\u00018\n\u001a\u0001\u0000\r\u001a\u0007\u0000\u0003\b\u0001\u0000\u0001\u001c\u0001\u0000\u0001\b\u0001\u0000\u0002\b\u0011\u0000\u0001\u001e\u0002\b\u0001\u001f\u0001\b\u0001\u0000\u0001\b\u0003\u0000\u0005  \u0000\u00019\u001d\u0000\u0003\b\u0001\u0000\u0001\b\u0001\u0000\u0001\b\u0001\u0000\u0002\b\u0011\u0000\u0005\b\u0001\u0000\u0001\b\u0006\u0000\u0001:\u000b\u0000\u0002\b\u0001\u001f\u0001\u0000\u0001.\u0001\u0000\u0001\b\u0001;\u0002\b\u0011\u0000\u0003\b\u0001\u001f\u0001\b\u0001\u0000\u0001\b\u0003\u0000\u0005 \u0001;\u000b\u0000\u0001 \u0001\u0000\u00010\u0002\u0000\u0001;\u0016\u0000\u0001 \u0006\u0000\u0005 \u0001;\u000e\u0000\u0001<'\u0000\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u0015\"\u0001#\u0001\u001a\f\"\u0001#\u0002\u0000\u0001#\u0002\u0000\u0001#\u0001\u0000\b#\u0001=\u0016#\u0001\u0000\f#\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0001\"\u0001$\u0002%\u0001&\u0001$\u0001>\u0001\"\u0001'\u0012\"\u0001$\u0001\"\u0001$\u0001#\u0001\u001a\u0003\"\u0001$\u0005\"\u0001>\u0002\"\u0001#\u0002\u0000\u0001#\u0002\u0000\u0001#\u0001\u0000\u0001#\u0005%\u0001?\u0001#\u0001=\u0012#\u0001%\u0001#\u0001%\u0001#\u0001\u0000\u0003#\u0001%\u0005#\u0001?\u0002#\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0001\"\u0001$\u0003%\u0001$\u0001>\u0001\"\u0001'\u0002\"\u0001@\u0001\"\u0001A\u0004\"\u0001B\u0001C\u0007\"\u0001$\u0001\"\u0001$\u0001#\u0001\u001a\u0003\"\u0001$\u0005\"\u0001>\u0002\"\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001)\u0019D\u0001E\u0001\u001a\fD\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u0011(\u0004\"\u0001#\u0001\u001a\t\"\u0001(\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0003#\u0003\"\u0001'\u0002\"\u0001@\u0001\"\u0001A\u0004\"\u0001B\u0001C\n\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u0011*\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0005\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u000e\u000e\u0001F\u0002\u000e\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u0010\u000e\u0001G\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0002\"\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0019\u001a\u0001\u0000\t\u001a\u0001H\u0003\u001a\u0007\u0000\u0003\b\u0001\u0000\u0001.\u0001\u0000\u0001\b\u0001;\u0002\b\u0011\u0000\u0005\b\u0001\u0000\u0001\b\b\u0000\u0001;\u0002\u0000\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0001\u001a\u0001/\u0017\u001a\u0001\u0000\n\u001a\u0001/\u0002\u001a\u000b\u0000\u00010\u0002\u0000\u0001;\"\u0000\u0001;\u0002\u0000\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0001\u001a\u00011\u00022\u00013\u00011\u0001I\u0014\u001a\u00011\u0001\u001a\u00011\u0001\u0000\u0004\u001a\u00011\u0005\u001a\u0001I\u0002\u001a\t\u0000\u00052\u0001J\u0014\u0000\u00012\u0001\u0000\u00012\u0005\u0000\u00012\u0005\u0000\u0001J\u0002\u0000\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0001\u001a\u00011\u00032\u00011\u0001I\u0004\u001a\u00015\u0001\u001a\u00016\u0004\u001a\u00017\u00018\u0007\u001a\u00011\u0001\u001a\u00011\u0001\u0000\u0004\u001a\u00011\u0005\u001a\u0001I\u0003\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0001\u001a\u00014\u0002\u001a\u00114\u0004\u001a\u0001\u0000\n\u001a\u00014\u0003\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u000e\u001a\u0001K\n\u001a\u0001\u0000\u000e\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0007\u001a\u0001L\u0011\u001a\u0001\u0000\u000e\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\b\u001a\u0001M\u0010\u001a\u0001\u0000\u000e\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0010\u001a\u0001N\b\u001a\u0001\u0000\r\u001a\u0012\u0000\u0001OQ\u0000\u0001P\u0011\u0000\u0001;\"\u0000\u0001;\u0002\u0000\u0001E\u0002\u0000\u0001E\u0002\u0000\u0001E\u0001\u0000\u0004E\u0001#\u001aE\u0001\u0000\fE\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\n\"\u0001Q\n\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u0003\"\u0001R\u0011\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u0004\"\u0001S\u0010\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\f\"\u0001T\b\"\u0001#\u0001\u001a\f\"\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0019D\u0001E\u0001\u001a\fD\u0001E\u0002\u0000\u0001E\u0002\u0000\u0001E\u0001\u0000\u0004E\u0001V\u001aE\u0001\u0000\fE\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001\"\u0001'\u000b\u000e\u0001W\u0005\u000e\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001X\u0001\"\u0001(\u0001\"\u0001'\u0011\u000e\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0002\"\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0019\u001a\u0001\u0000\u0007\u001a\u0001Y\u0006\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\f\u001a\u0001Z\f\u001a\u0001\u0000\u000e\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0013\u001a\u0001Z\u0005\u001a\u0001\u0000\u000e\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0012\u001a\u0001Z\u0006\u001a\u0001\u0000\u000e\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\t\u001a\u0001Z\u000f\u001a\u0001\u0000\r\u001a\u000b\u0000\u0001\nV\u0000\u0001[\u0005\u0000\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\b\"\u0001\\\f\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u000f\"\u0001\\\u0005\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u000e\"\u0001\\\u0006\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0003\"\u0001'\u0005\"\u0001\\\u000f\"\u0001#\u0001\u001a\f\"\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001#\u0004D\u0002]\u0001^\u0001]\u0001_\u0004]\u0001`\u0001a\u0006]\u0004D\u0001E\u0001\u001a\fD\u0001E\u0002\u0000\u0001E\u0002\u0000\u0001E\u0001\u0000\u0004E\u0001#\u0004E\u0011b\u0005E\u0001\u0000\fE\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001c\u0001'\r\u000e\u0001d\u0003\u000e\u0004\"\u0001#\u0001\u001a\u0002*\u0001e\u0002\"\u0003*\u0001\"\u0001(\u0002\"\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001#\u0003f\u0001g\u0002f\u0001h\u0001f\u0001i\u0004f\u0001j\u0001k\nf\u0001#\u0001l\ff\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0019\u001a\u0001\u0000\u0007\u001a\u0001m\u0006\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0001n\u0018\u001a\u0001\u0000\r\u001a.\u0000\u0001o\u0005\u0000\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001n\u0002\"\u0001'\u0015\"\u0001#\u0001\u001a\f\"\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u0011p\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\np\u0001q\u0006p\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u0003p\u0001r\rp\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u0004p\u0001s\fp\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\fp\u0001t\u0004p\u0004D\u0001E\u0001\u001a\fD\u0001E\u0002\u0000\u0001E\u0002\u0000\u0001E\u0001\u0000\u0004E\u0001V\u0004E\u0011u\u0005E\u0001\u0000\fE\u0001\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001v\u0002\"\u0001'\u0015\"\u0001#\u0001\u001a\r\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0001\"\u0001(\u0001c\u0001'\u0011\u000e\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0001\"\u0001(\u0003\"\u0002\u0000\u0001\"\u0002\u0000\u0001#\u0001\u0000\u0002\"\u0002#\u0001)\u0002\"\u0001c\u0001'\u0011*\u0004\"\u0001#\u0001\u001a\u0003*\u0002\"\u0003*\u0004\"\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u0015f\u0001#\u0001l\ff\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001w\u0019x\u0001E\u0001l\fx\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\nf\u0001y\nf\u0001#\u0001l\rf\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u0003f\u0001z\u0011f\u0001#\u0001l\rf\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u0004f\u0001{\u0010f\u0001#\u0001l\rf\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\ff\u0001|\bf\u0001#\u0001l\ff\u0001l\u0002\u0000\u0001l\u0004\u0000\u0002l\u0001\u0000\u0001l\u0001}\u0019l\u0001\u0000\rl\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0002\u0000\u0001\u001b\u0017\u001a\u0001~\u0001\u001a\u0001\u0000\r\u001a\u0001\u007f\u0002\u0000\u0001\u007f\u0002\u0000\u0001\u007f\u0001\u0000,\u007f$\u0000\u0001\u0080\u000f\u0000\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u0011\u0081\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\b\u0081\u0001\u0082\b\u0081\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u000f\u0081\u0001\u0082\u0001\u0081\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u000e\u0081\u0001\u0082\u0002\u0081\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u0005\u0081\u0001\u0082\u000b\u0081\u0004D\u0001E\u0001\u001a\fD\u0001E\u0002\u0000\u0001E\u0002\u0000\u0001E\u0001\u0000\u0004E\u0001V\u0004E\u0011\u0083\u0005E\u0001\u0000\fE\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001#\u0003f\u0001g\u0011\u0084\u0004f\u0001#\u0001l\ff\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001\u0085\u0019x\u0001E\u0001l\fx\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\bf\u0001\u0086\ff\u0001#\u0001l\rf\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u000ff\u0001\u0086\u0005f\u0001#\u0001l\rf\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u000ef\u0001\u0086\u0006f\u0001#\u0001l\rf\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u0005f\u0001\u0086\u000ff\u0001#\u0001l\ff\u0001l\u0002\u0000\u0001l\u0004\u0000\u0002l\u0001\u0000\u0001l\u0001\u0000\u0004l\u0011\u0087\u0004l\u0001\u0000\rl\u0001\u001a\u0002\u0000\u0001\u001a\u0004\u0000\u0002\u001a\u0001\u0000\u0001\u0088\u0001\u001b\u0019\u001a\u0001\u0000\r\u001a\u0001\u0089\u0002\u0000\u0001\u0089\u0002\u0000\u0001\u007f\u0001\u0000\u0002\u0089\u0003\u007f\u0019\u0089\u0001\u007f\r\u0089\u000b\u0000\u0001\u0088(\u0000\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0004D\u0011\u008a\u0004D\u0001E\u0001\u001a\rD\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001\u0000\u0002D\u0002E\u0001U\u0001n\u0003D\u0011\u008a\u0004D\u0001E\u0001\u001a\fD\u0001E\u0002\u0000\u0001E\u0002\u0000\u0001E\u0001\u0000\u0004E\u0001V\u0004E\u0011\u008b\u0005E\u0001\u0000\fE\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0003f\u0001g\u0011\u008c\u0004f\u0001#\u0001l\ff\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001#\u0004x\u0011\u008d\u0004x\u0001E\u0001l\fx\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0001n\u0002f\u0001g\u0015f\u0001#\u0001l\ff\u0001l\u0002\u0000\u0001l\u0004\u0000\u0002l\u0001\u0000\u0001l\u0001}\u0004l\u0011\u008e\u0004l\u0001\u0000\rl\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0001n\u0002f\u0001g\u0011\u008f\u0004f\u0001#\u0001l\ff\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001\u0085\u0004x\u0011\u0090\u0004x\u0001E\u0001l\fx\u0001l\u0002\u0000\u0001l\u0004\u0000\u0002l\u0001\u0000\u0001l\u0001}\u0001n\u0003l\u0011\u0091\u0004l\u0001\u0000\rl\u0001f\u0002\u0000\u0001f\u0002\u0000\u0001#\u0001\u0000\u0002f\u0001#\u0001f\u0001w\u0001n\u0002f\u0001g\u0011\u0086\u0004f\u0001#\u0001l\ff\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001\u0085\u0001n\u0003x\u0011\u0092\u0004x\u0001E\u0001l\fx\u0001l\u0002\u0000\u0001l\u0004\u0000\u0002l\u0001\u0000\u0001l\u0001}\u0001n\u0003l\u0011\u0093\u0004l\u0001\u0000\rl\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001\u0085\u0001n\u0003x\u0011\u0094\u0004x\u0001E\u0001l\fx\u0001l\u0002\u0000\u0001l\u0004\u0000\u0002l\u0001\u0000\u0001l\u0001}\u0001n\u0018l\u0001\u0000\rl\u0001x\u0002\u0000\u0001x\u0002\u0000\u0001E\u0001\u0000\u0002x\u0001E\u0001x\u0001\u0085\u0001n\u0018x\u0001E\u0001l\fx";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = ArabicLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0002\u0001\u0001\t\u0005\u0001\u0001\t\u000f\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0007\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0001\u0000\u0003\u0001\u0003\u0000\u0001\u0001\u0006\u0000\u0002\u0001\u0001\u0000\u0002\u0001\u0006\u0000\u0002\u0001\u0001\u0000\u0002\u0001\f\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0007\u0000\u0002\u0001\n\u0000\u0006\u0001\b\u0000\u0001\u0001\u0001\u0000\u0004\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\t\u0004\u0001\u0001\u0000\u0007\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private LexedTokenFactory<?> tokenFactory;
    private boolean invertible;
    private CoreLabel prevWord;
    private StringBuilder prevWordAfter;
    private boolean normArDigits;
    private boolean normArPunc;
    private boolean tokenizeNLs;
    public static final String NEWLINE_TOKEN = "*NL*";
    private boolean useUTF8Ellipsis;
    private boolean normAlif;
    private boolean normYa;
    private boolean removeDiacritics;
    private boolean removeTatweel;
    private boolean removeQuranChars;
    private boolean removeProMarker;
    private boolean removeSegMarker;
    private boolean removeMorphMarker;
    private boolean removeLengthening;
    private final Pattern segmentationMarker = Pattern.compile("^-+|-+$");
    private boolean atbEscaping;
    private Map<String, String> normMap;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = ArabicLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[28160];
        int offset = 0;
        offset = ArabicLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[148];
        int offset = 0;
        offset = ArabicLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[148];
        int offset = 0;
        offset = ArabicLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[6968];
        int offset = 0;
        offset = ArabicLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[148];
        int offset = 0;
        offset = ArabicLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public ArabicLexer(Reader r, LexedTokenFactory<?> tf, Properties props) {
        this(r);
        this.tokenFactory = tf;
        this.tokenizeNLs = PropertiesUtils.getBool(props, "tokenizeNLs", false);
        this.useUTF8Ellipsis = PropertiesUtils.getBool(props, "useUTF8Ellipsis", false);
        this.invertible = PropertiesUtils.getBool(props, "invertible", false);
        this.normArDigits = PropertiesUtils.getBool(props, "normArDigits", false);
        this.normArPunc = PropertiesUtils.getBool(props, "normArPunc", false);
        this.normAlif = PropertiesUtils.getBool(props, "normAlif", false);
        this.normYa = PropertiesUtils.getBool(props, "normYa", false);
        this.removeDiacritics = PropertiesUtils.getBool(props, "removeDiacritics", false);
        this.removeTatweel = PropertiesUtils.getBool(props, "removeTatweel", false);
        this.removeQuranChars = PropertiesUtils.getBool(props, "removeQuranChars", false);
        this.removeProMarker = PropertiesUtils.getBool(props, "removeProMarker", false);
        this.removeSegMarker = PropertiesUtils.getBool(props, "removeSegMarker", false);
        this.removeMorphMarker = PropertiesUtils.getBool(props, "removeMorphMarker", false);
        this.removeLengthening = PropertiesUtils.getBool(props, "removeLengthening", false);
        this.atbEscaping = PropertiesUtils.getBool(props, "atbEscaping", false);
        this.setupNormalizationMap();
        if (this.invertible) {
            if (!(tf instanceof CoreLabelTokenFactory)) {
                throw new IllegalArgumentException("ArabicLexer: the invertible option requires a CoreLabelTokenFactory");
            }
            this.prevWord = (CoreLabel)tf.makeToken("", 0, 0);
            this.prevWordAfter = new StringBuilder();
        }
    }

    private void setupNormalizationMap() {
        this.normMap = Generics.newHashMap(200);
        this.normMap.put("\u0600", "#");
        this.normMap.put("\u0601", "");
        this.normMap.put("\u0602", "");
        this.normMap.put("\u0603", "");
        this.normMap.put("\u0606", "\u221b");
        this.normMap.put("\u0607", "\u221c");
        this.normMap.put("\u0608", "");
        this.normMap.put("\u0609", "%");
        this.normMap.put("\u060a", "%");
        this.normMap.put("\u060b", "");
        this.normMap.put("\u060e", "");
        this.normMap.put("\u060f", "");
        this.normMap.put("\u066e", "\u0628");
        this.normMap.put("\u066f", "\u0642");
        this.normMap.put("\u06cc", "\u0649");
        this.normMap.put("\u06d6", "");
        this.normMap.put("\u06d7", "");
        this.normMap.put("\u06d8", "");
        this.normMap.put("\u06d9", "");
        this.normMap.put("\u06da", "");
        this.normMap.put("\u06db", "");
        this.normMap.put("\u06dc", "");
        this.normMap.put("\u06dd", "");
        this.normMap.put("\u06de", "");
        this.normMap.put("\u06df", "");
        this.normMap.put("\u06e0", "");
        this.normMap.put("\u06e1", "");
        this.normMap.put("\u06e2", "");
        this.normMap.put("\u06e3", "");
        this.normMap.put("\u06e4", "");
        this.normMap.put("\u06e5", "");
        this.normMap.put("\u06e6", "");
        this.normMap.put("\u06e7", "");
        this.normMap.put("\u06e8", "");
        this.normMap.put("\u06e9", "");
        this.normMap.put("\u06ea", "");
        this.normMap.put("\u06eb", "");
        this.normMap.put("\u06ec", "");
        this.normMap.put("\u06ed", "");
        if (this.normArDigits) {
            this.normMap.put("\u0660", "0");
            this.normMap.put("\u0661", "1");
            this.normMap.put("\u0662", "2");
            this.normMap.put("\u0663", "3");
            this.normMap.put("\u0664", "4");
            this.normMap.put("\u0665", "5");
            this.normMap.put("\u0666", "6");
            this.normMap.put("\u0667", "7");
            this.normMap.put("\u0668", "8");
            this.normMap.put("\u0669", "9");
            this.normMap.put("\u06f0", "0");
            this.normMap.put("\u06f1", "1");
            this.normMap.put("\u06f2", "2");
            this.normMap.put("\u06f3", "3");
            this.normMap.put("\u06f4", "4");
            this.normMap.put("\u06f5", "5");
            this.normMap.put("\u06f6", "6");
            this.normMap.put("\u06f7", "7");
            this.normMap.put("\u06f8", "8");
            this.normMap.put("\u06f9", "9");
        }
        if (this.normArPunc) {
            this.normMap.put("\u00bb", "\"");
            this.normMap.put("\u00ab", "\"");
            this.normMap.put("\u060c", ",");
            this.normMap.put("\u060d", ",");
            this.normMap.put("\u061b", ";");
            this.normMap.put("\u061e", ".");
            this.normMap.put("\u061f", "?");
            this.normMap.put("\u066a", "%");
            this.normMap.put("\u066b", ",");
            this.normMap.put("\u066c", "'");
            this.normMap.put("\u066f", "*");
            this.normMap.put("\u06df", ".");
        }
        if (this.normAlif) {
            this.normMap.put("\u0622", "\u0627");
            this.normMap.put("\u0623", "\u0627");
            this.normMap.put("\u0625", "\u0627");
            this.normMap.put("\u0671", "\u0627");
            this.normMap.put("\u0672", "\u0627");
            this.normMap.put("\u0673", "\u0627");
        }
        if (this.normYa) {
            this.normMap.put("\u064a", "\u0649");
        }
        if (this.removeDiacritics) {
            this.normMap.put("\u064b", "");
            this.normMap.put("\u064c", "");
            this.normMap.put("\u064d", "");
            this.normMap.put("\u064e", "");
            this.normMap.put("\u064f", "");
            this.normMap.put("\u0650", "");
            this.normMap.put("\u0651", "");
            this.normMap.put("\u0652", "");
            this.normMap.put("\u0653", "");
            this.normMap.put("\u0654", "");
            this.normMap.put("\u0655", "");
            this.normMap.put("\u0656", "");
            this.normMap.put("\u0657", "");
            this.normMap.put("\u0658", "");
            this.normMap.put("\u0659", "");
            this.normMap.put("\u065a", "");
            this.normMap.put("\u065b", "");
            this.normMap.put("\u065c", "");
            this.normMap.put("\u065d", "");
            this.normMap.put("\u065e", "");
            this.normMap.put("\u0670", "");
        }
        if (this.removeTatweel) {
            this.normMap.put("\u0640", "");
            this.normMap.put("_", "");
        }
        if (this.removeQuranChars) {
            this.normMap.put("\u0610", "");
            this.normMap.put("\u0611", "");
            this.normMap.put("\u0612", "");
            this.normMap.put("\u0613", "");
            this.normMap.put("\u0614", "");
            this.normMap.put("\u0615", "");
            this.normMap.put("\u0616", "");
            this.normMap.put("\u0617", "");
            this.normMap.put("\u0618", "");
            this.normMap.put("\u0619", "");
            this.normMap.put("\u061a", "");
        }
        if (this.atbEscaping) {
            this.normMap.put("(", "-LRB-");
            this.normMap.put(")", "-RRB-");
        }
    }

    private String normalizeToken(String text, boolean isWord) {
        if (isWord && this.removeSegMarker) {
            text = this.segmentationMarker.matcher(text).replaceAll("");
        }
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            String thisChar = String.valueOf(text.charAt(i));
            if (isWord && this.removeMorphMarker && thisChar.equals("+") || this.removeLengthening && this.isLengthening(text, i)) continue;
            if (this.normMap.containsKey(thisChar)) {
                thisChar = this.normMap.get(thisChar);
            }
            if (thisChar.length() <= 0) continue;
            sb.append(thisChar);
        }
        return sb.toString();
    }

    private boolean isLengthening(String text, int pos) {
        if (pos == 0) {
            return false;
        }
        String thisChar = String.valueOf(text.charAt(pos));
        if (!thisChar.equals(String.valueOf(text.charAt(pos - 1)))) {
            return false;
        }
        if (pos < text.length() - 1 && thisChar.equals(String.valueOf(text.charAt(pos + 1)))) {
            return true;
        }
        return pos >= 2 && thisChar.equals(String.valueOf(text.charAt(pos - 2)));
    }

    private Object getNext(String txt, String originalText) {
        if (this.tokenFactory == null) {
            throw new RuntimeException(this.getClass().getName() + ": Token factory is null.");
        }
        if (this.invertible) {
            String str = this.prevWordAfter.toString();
            this.prevWordAfter.setLength(0);
            CoreLabel word = (CoreLabel)this.tokenFactory.makeToken(txt, Math.toIntExact(this.yychar), this.yylength());
            word.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
            word.set(CoreAnnotations.BeforeAnnotation.class, str);
            this.prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
            this.prevWord = word;
            return word;
        }
        return this.tokenFactory.makeToken(txt, Math.toIntExact(this.yychar), this.yylength());
    }

    private Object getNext(boolean isWord) {
        String text = this.yytext();
        String normText = this.normalizeToken(text, isWord);
        return this.getNext(normText, text);
    }

    private Object getEllipsis() {
        String ellipsisString = this.useUTF8Ellipsis ? "\u2026" : "...";
        return this.getNext(ellipsisString, this.yytext());
    }

    ArabicLexer(Reader in) {
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            ArabicLexer.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Object next() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block18: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += (long)(zzMarkedPosL - this.zzStartRead);
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + ArabicLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                if (this.invertible) {
                    String str = this.prevWordAfter.toString();
                    this.prevWord.set(CoreAnnotations.AfterAnnotation.class, str);
                    this.prevWordAfter.setLength(0);
                }
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    System.err.printf("Untokenizable: %s%n", this.yytext());
                    return this.getNext(true);
                }
                case 9: {
                    continue block18;
                }
                case 2: {
                    if (this.invertible) {
                        this.prevWordAfter.append(this.yytext());
                    }
                }
                case 10: {
                    continue block18;
                }
                case 3: {
                    if (this.tokenizeNLs) {
                        return this.getNext(NEWLINE_TOKEN, this.yytext());
                    }
                    if (this.invertible) {
                        this.prevWordAfter.append(this.yytext());
                    }
                }
                case 11: {
                    continue block18;
                }
                case 4: {
                    return this.getNext(false);
                }
                case 12: {
                    continue block18;
                }
                case 5: {
                    return this.getNext(true);
                }
                case 13: {
                    continue block18;
                }
                case 6: {
                    return this.getEllipsis();
                }
                case 14: {
                    continue block18;
                }
                case 7: {
                    if (!this.removeProMarker) {
                        return this.getNext(false);
                    }
                    if (this.invertible) {
                        this.prevWordAfter.append(this.yytext());
                    }
                }
                case 15: {
                    continue block18;
                }
                case 8: {
                    if (this.removeProMarker) {
                        if (!this.removeSegMarker) {
                            return this.getNext("-", this.yytext());
                        }
                        if (this.invertible) {
                            this.prevWordAfter.append(this.yytext());
                        }
                    } else {
                        return this.getNext(false);
                    }
                }
                case 16: {
                    continue block18;
                }
            }
            ArabicLexer.zzScanError(1);
        }
    }
}

