/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;

public class XYDrawableAnnotation
implements XYAnnotation,
Cloneable,
Serializable {
    private double x;
    private double y;
    private double width;
    private double height;
    private Drawable drawable;

    public XYDrawableAnnotation(double x, double y, double width, double height, Drawable drawable) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.drawable = drawable;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        float j2DX = (float)domainAxis.valueToJava2D(this.x, dataArea, domainEdge);
        float j2DY = (float)rangeAxis.valueToJava2D(this.y, dataArea, rangeEdge);
        Rectangle2D.Double area = new Rectangle2D.Double((double)j2DX - this.width / 2.0, (double)j2DY - this.height / 2.0, this.width, this.height);
        this.drawable.draw(g2, (Rectangle2D)area);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYDrawableAnnotation) {
            XYDrawableAnnotation a = (XYDrawableAnnotation)object;
            boolean b0 = this.x == a.x;
            boolean b1 = this.y == a.y;
            boolean b2 = this.width == a.width;
            boolean b3 = this.height == a.height;
            boolean b4 = ObjectUtils.equal((Object)this.drawable, (Object)a.drawable);
            return b0 && b1 && b2 && b3 && b4;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

