/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a\u0018\u0010\b\u001a\u00020\u0006*\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"cleanDirectoryContents", "", "Ljava/io/File;", "forceDeleteRecursively", "forceMkdirs", "isClassFile", "", "isJavaFile", "isKotlinFile", "sourceFilesExtensions", "", "", "kotlin-build-common"})
public final class FileUtilsKt {
    public static final boolean isJavaFile(@NotNull File $this$isJavaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFile, (String)"<this>");
        return StringsKt.equals((String)FilesKt.getExtension((File)$this$isJavaFile), (String)"java", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFile(@NotNull File $this$isKotlinFile, @NotNull List<String> sourceFilesExtensions) {
        String it;
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFile, (String)"<this>");
        Intrinsics.checkNotNullParameter(sourceFilesExtensions, (String)"sourceFilesExtensions");
        if (FileUtilsKt.isJavaFile($this$isKotlinFile)) return false;
        Iterable $this$any$iv = sourceFilesExtensions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.equals((String)it, (String)FilesKt.getExtension((File)$this$isKotlinFile), (boolean)true));
        return true;
    }

    public static final boolean isClassFile(@NotNull File $this$isClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassFile, (String)"<this>");
        return StringsKt.equals((String)FilesKt.getExtension((File)$this$isClassFile), (String)"class", (boolean)true);
    }

    public static final void cleanDirectoryContents(@NotNull File $this$cleanDirectoryContents) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanDirectoryContents, (String)"<this>");
        if ($this$cleanDirectoryContents.isDirectory()) {
            File[] fileArray = $this$cleanDirectoryContents.listFiles();
            Intrinsics.checkNotNull((Object)fileArray);
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FileUtilsKt.forceDeleteRecursively(it);
            }
        } else {
            if ($this$cleanDirectoryContents.isFile()) {
                throw new IllegalStateException(("File.cleanDirectoryContents does not accept a regular file: " + $this$cleanDirectoryContents.getPath()).toString());
            }
            FileUtilsKt.forceMkdirs($this$cleanDirectoryContents);
        }
    }

    public static final void forceDeleteRecursively(@NotNull File $this$forceDeleteRecursively) {
        Intrinsics.checkNotNullParameter((Object)$this$forceDeleteRecursively, (String)"<this>");
        if (!FilesKt.deleteRecursively((File)$this$forceDeleteRecursively)) {
            throw new IOException("Could not delete '" + $this$forceDeleteRecursively.getPath() + '\'');
        }
    }

    public static final void forceMkdirs(@NotNull File $this$forceMkdirs) {
        Intrinsics.checkNotNullParameter((Object)$this$forceMkdirs, (String)"<this>");
        if (!$this$forceMkdirs.isDirectory()) {
            if ($this$forceMkdirs.isFile()) {
                throw new IllegalStateException(("File.forceMkdirs does not accept a regular file: " + $this$forceMkdirs.getPath()).toString());
            }
            if (!$this$forceMkdirs.mkdirs()) {
                throw new IOException("Could not create directory '" + $this$forceMkdirs.getPath() + '\'');
            }
        }
    }
}

