/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.output;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import org.jetbrains.kotlin.org.jdom.Verifier;
import org.jetbrains.kotlin.org.jdom.output.EscapeStrategy;
import org.jetbrains.kotlin.org.jdom.output.LineSeparator;

public class Format
implements Cloneable {
    private static final EscapeStrategy UTFEscapeStrategy = new EscapeStrategyUTF();
    private static final EscapeStrategy Bits8EscapeStrategy = new EscapeStrategy8Bits();
    private static final EscapeStrategy Bits7EscapeStrategy = new EscapeStrategy7Bits();
    private static final EscapeStrategy DefaultEscapeStrategy = new EscapeStrategy(){

        @Override
        public boolean shouldEscape(char ch) {
            return Verifier.isHighSurrogate(ch);
        }
    };
    private static final String STANDARD_LINE_SEPARATOR = LineSeparator.DEFAULT.value();
    String indent = null;
    String lineSeparator = STANDARD_LINE_SEPARATOR;
    String encoding = "UTF-8";
    boolean omitDeclaration = false;
    boolean omitEncoding = false;
    boolean specifiedAttributesOnly = false;
    boolean expandEmptyElements = false;
    boolean ignoreTrAXEscapingPIs = false;
    TextMode mode = TextMode.PRESERVE;
    EscapeStrategy escapeStrategy = DefaultEscapeStrategy;

    public static Format getRawFormat() {
        return new Format();
    }

    public static Format getCompactFormat() {
        Format f = new Format();
        f.setTextMode(TextMode.NORMALIZE);
        return f;
    }

    public static final String compact(String str) {
        int left;
        int right = str.length() - 1;
        for (left = 0; left <= right && Verifier.isXMLWhitespace(str.charAt(left)); ++left) {
        }
        while (right > left && Verifier.isXMLWhitespace(str.charAt(right))) {
            --right;
        }
        if (left > right) {
            return "";
        }
        boolean space = true;
        StringBuilder buffer = new StringBuilder(right - left + 1);
        while (left <= right) {
            char c = str.charAt(left);
            if (Verifier.isXMLWhitespace(c)) {
                if (space) {
                    buffer.append(' ');
                    space = false;
                }
            } else {
                buffer.append(c);
                space = true;
            }
            ++left;
        }
        return buffer.toString();
    }

    private static final EscapeStrategy chooseStrategy(String encoding) {
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding)) {
            return UTFEscapeStrategy;
        }
        if (encoding.toUpperCase(Locale.ENGLISH).startsWith("ISO-8859-") || "Latin1".equalsIgnoreCase(encoding)) {
            return Bits8EscapeStrategy;
        }
        if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
            return Bits7EscapeStrategy;
        }
        try {
            CharsetEncoder cse = Charset.forName(encoding).newEncoder();
            return new DefaultCharsetEscapeStrategy(cse);
        }
        catch (Exception exception) {
            return DefaultEscapeStrategy;
        }
    }

    private Format() {
        this.setEncoding("UTF-8");
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    public Format setLineSeparator(String separator) {
        this.lineSeparator = "".equals(separator) ? null : separator;
        return this;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Format setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
        return this;
    }

    public boolean getOmitEncoding() {
        return this.omitEncoding;
    }

    public Format setOmitDeclaration(boolean omitDeclaration) {
        this.omitDeclaration = omitDeclaration;
        return this;
    }

    public boolean getOmitDeclaration() {
        return this.omitDeclaration;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public void setIgnoreTrAXEscapingPIs(boolean ignoreTrAXEscapingPIs) {
        this.ignoreTrAXEscapingPIs = ignoreTrAXEscapingPIs;
    }

    public boolean getIgnoreTrAXEscapingPIs() {
        return this.ignoreTrAXEscapingPIs;
    }

    public Format setTextMode(TextMode mode) {
        this.mode = mode;
        return this;
    }

    public TextMode getTextMode() {
        return this.mode;
    }

    public Format setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public Format setEncoding(String encoding) {
        this.encoding = encoding;
        this.escapeStrategy = Format.chooseStrategy(encoding);
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isSpecifiedAttributesOnly() {
        return this.specifiedAttributesOnly;
    }

    public Format clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return format;
    }

    public static enum TextMode {
        PRESERVE,
        TRIM,
        NORMALIZE,
        TRIM_FULL_WHITE;

    }

    private static final class DefaultCharsetEscapeStrategy
    implements EscapeStrategy {
        private final CharsetEncoder encoder;

        public DefaultCharsetEscapeStrategy(CharsetEncoder cse) {
            this.encoder = cse;
        }

        @Override
        public boolean shouldEscape(char ch) {
            if (Verifier.isHighSurrogate(ch)) {
                return true;
            }
            return !this.encoder.canEncode(ch);
        }
    }

    private static final class EscapeStrategy7Bits
    implements EscapeStrategy {
        private EscapeStrategy7Bits() {
        }

        @Override
        public boolean shouldEscape(char ch) {
            return ch >>> 7 != 0;
        }
    }

    private static final class EscapeStrategy8Bits
    implements EscapeStrategy {
        private EscapeStrategy8Bits() {
        }

        @Override
        public boolean shouldEscape(char ch) {
            return ch >>> 8 != 0;
        }
    }

    private static final class EscapeStrategyUTF
    implements EscapeStrategy {
        private EscapeStrategyUTF() {
        }

        @Override
        public final boolean shouldEscape(char ch) {
            return Verifier.isHighSurrogate(ch);
        }
    }
}

