/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCache;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class CrossBuildCachingKeyService
implements PublicKeyService,
Closeable {
    static final long MISSING_KEY_TIMEOUT = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    private final PersistentCache cache;
    private final BuildOperationExecutor buildOperationExecutor;
    private final PublicKeyService delegate;
    private final BuildCommencedTimeProvider timeProvider;
    private final boolean refreshKeys;
    private final PersistentIndexedCache<Fingerprint, CacheEntry<PGPPublicKeyRing>> publicKeyRings;
    private final PersistentIndexedCache<Long, CacheEntry<List<Fingerprint>>> longIdToFingerprint;
    private final ProducerGuard<Fingerprint> fingerPrintguard = ProducerGuard.adaptive();
    private final ProducerGuard<Long> longIdGuard = ProducerGuard.adaptive();

    public CrossBuildCachingKeyService(GlobalScopedCache cacheRepository, InMemoryCacheDecoratorFactory decoratorFactory, BuildOperationExecutor buildOperationExecutor, PublicKeyService delegate, BuildCommencedTimeProvider timeProvider, boolean refreshKeys) {
        this.cache = cacheRepository.crossVersionCache("keyrings").withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
        this.timeProvider = timeProvider;
        this.refreshKeys = refreshKeys;
        FingerprintSerializer fingerprintSerializer = new FingerprintSerializer();
        PersistentIndexedCacheParameters keyringParams = PersistentIndexedCacheParameters.of((String)"publickeyrings", (Serializer)fingerprintSerializer, (Serializer)new PublicKeyRingCacheEntrySerializer()).withCacheDecorator(decoratorFactory.decorator(2000, true));
        this.publicKeyRings = this.cache.createCache(keyringParams);
        PersistentIndexedCacheParameters mappingParameters = PersistentIndexedCacheParameters.of((String)"keymappings", (Serializer)BaseSerializerFactory.LONG_SERIALIZER, (Serializer)new FingerprintListCacheEntrySerializer((ListSerializer<Fingerprint>)new ListSerializer((Serializer)fingerprintSerializer))).withCacheDecorator(decoratorFactory.decorator(2000, true));
        this.longIdToFingerprint = this.cache.createCache(mappingParameters);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private boolean hasExpired(CacheEntry<?> key) {
        if (((CacheEntry)key).value != null) {
            return false;
        }
        long elapsed = this.timeProvider.getCurrentTime() - ((CacheEntry)key).timestamp;
        return this.refreshKeys || elapsed > MISSING_KEY_TIMEOUT;
    }

    public void findByLongId(final long keyId, final PublicKeyResultBuilder builder) {
        this.longIdGuard.guardByKey((Object)keyId, () -> {
            CacheEntry fingerprints = (CacheEntry)this.longIdToFingerprint.getIfPresent((Object)keyId);
            if (fingerprints == null || this.hasExpired(fingerprints)) {
                this.buildOperationExecutor.run(new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        final long currentTime = CrossBuildCachingKeyService.this.timeProvider.getCurrentTime();
                        final AtomicBoolean missing = new AtomicBoolean(true);
                        CrossBuildCachingKeyService.this.delegate.findByLongId(keyId, new PublicKeyResultBuilder(){

                            public void keyRing(PGPPublicKeyRing keyring) {
                                missing.set(false);
                                builder.keyRing(keyring);
                                Iterator pkIt = keyring.getPublicKeys();
                                while (pkIt.hasNext()) {
                                    PGPPublicKey publicKey = (PGPPublicKey)pkIt.next();
                                    Fingerprint fingerprint = Fingerprint.of((PGPPublicKey)publicKey);
                                    CrossBuildCachingKeyService.this.publicKeyRings.put((Object)fingerprint, new CacheEntry(currentTime, keyring));
                                    CrossBuildCachingKeyService.this.updateLongKeyIndex(fingerprint, keyId);
                                }
                            }

                            public void publicKey(PGPPublicKey publicKey) {
                                missing.set(false);
                                if (publicKey.getKeyID() == keyId) {
                                    builder.publicKey(publicKey);
                                }
                            }
                        });
                        if (missing.get()) {
                            CrossBuildCachingKeyService.this.longIdToFingerprint.put((Object)keyId, new CacheEntry(currentTime, null));
                        }
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)"Fetching public key").progressDisplayName("Downloading public key " + SecuritySupport.toLongIdHexString((long)keyId));
                    }
                });
            } else if (fingerprints.value != null) {
                for (Fingerprint fingerprint : (List)fingerprints.value) {
                    this.findByFingerprint(fingerprint.getBytes(), new PublicKeyResultBuilder(){

                        public void keyRing(PGPPublicKeyRing keyring) {
                            builder.keyRing(keyring);
                        }

                        public void publicKey(PGPPublicKey publicKey) {
                            if (publicKey.getKeyID() == keyId) {
                                builder.publicKey(publicKey);
                            }
                        }
                    });
                }
            }
            return null;
        });
    }

    private void updateLongKeyIndex(Fingerprint fingerprint, long keyId) {
        CacheEntry fprints = (CacheEntry)this.longIdToFingerprint.getIfPresent((Object)keyId);
        long currentTime = this.timeProvider.getCurrentTime();
        if (fprints == null) {
            this.longIdToFingerprint.put((Object)keyId, new CacheEntry(currentTime, Collections.singletonList(fingerprint)));
        } else {
            this.longIdToFingerprint.remove((Object)keyId);
            ImmutableList.Builder list = ImmutableList.builderWithExpectedSize((int)(1 + ((List)fprints.value).size()));
            list.addAll((Iterable)fprints.value);
            list.add((Object)fingerprint);
            this.longIdToFingerprint.put((Object)keyId, new CacheEntry(currentTime, list.build()));
        }
    }

    public void findByFingerprint(byte[] bytes, PublicKeyResultBuilder builder) {
        Fingerprint fingerprint = Fingerprint.wrap((byte[])bytes);
        this.fingerPrintguard.guardByKey((Object)fingerprint, () -> {
            CacheEntry<PGPPublicKeyRing> cacheEntry = (CacheEntry<PGPPublicKeyRing>)this.publicKeyRings.getIfPresent((Object)fingerprint);
            if (cacheEntry == null || this.hasExpired(cacheEntry)) {
                LookupPublicKeyResultBuilder keyResultBuilder = new LookupPublicKeyResultBuilder();
                this.delegate.findByFingerprint(bytes, (PublicKeyResultBuilder)keyResultBuilder);
                cacheEntry = keyResultBuilder.entry;
            }
            if (cacheEntry != null) {
                builder.keyRing((PGPPublicKeyRing)((CacheEntry)cacheEntry).value);
                Iterator pkIt = ((PGPPublicKeyRing)((CacheEntry)cacheEntry).value).getPublicKeys();
                while (pkIt.hasNext()) {
                    PGPPublicKey publicKey = (PGPPublicKey)pkIt.next();
                    if (!Arrays.equals(publicKey.getFingerprint(), bytes)) continue;
                    builder.publicKey(publicKey);
                }
            }
            return null;
        });
    }

    private static class FingerprintListCacheEntrySerializer
    extends AbstractSerializer<CacheEntry<List<Fingerprint>>> {
        private final ListSerializer<Fingerprint> listSerializer;

        public FingerprintListCacheEntrySerializer(ListSerializer<Fingerprint> listSerializer) {
            this.listSerializer = listSerializer;
        }

        public CacheEntry<List<Fingerprint>> read(Decoder decoder) throws EOFException, Exception {
            long timestamp = decoder.readLong();
            List fingerprints = decoder.readBoolean() ? (List)this.listSerializer.read(decoder) : null;
            return new CacheEntry<List<Fingerprint>>(timestamp, fingerprints);
        }

        public void write(Encoder encoder, CacheEntry<List<Fingerprint>> value) throws Exception {
            encoder.writeLong(((CacheEntry)value).timestamp);
            List fingerprints = (List)((CacheEntry)value).value;
            if (fingerprints == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                this.listSerializer.write(encoder, (Collection)fingerprints);
            }
        }
    }

    private class LookupPublicKeyResultBuilder
    implements PublicKeyResultBuilder {
        CacheEntry<PGPPublicKeyRing> entry;

        private LookupPublicKeyResultBuilder() {
        }

        public void keyRing(PGPPublicKeyRing keyring) {
            this.entry = new CacheEntry(CrossBuildCachingKeyService.this.timeProvider.getCurrentTime(), keyring);
            Iterator pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey publicKey = (PGPPublicKey)pkIt.next();
                Fingerprint fingerprint = Fingerprint.of((PGPPublicKey)publicKey);
                long keyID = publicKey.getKeyID();
                CrossBuildCachingKeyService.this.updateLongKeyIndex(fingerprint, keyID);
            }
        }

        public void publicKey(PGPPublicKey publicKey) {
        }
    }

    private static class FingerprintSerializer
    extends AbstractSerializer<Fingerprint> {
        private FingerprintSerializer() {
        }

        public Fingerprint read(Decoder decoder) throws Exception {
            return Fingerprint.wrap((byte[])decoder.readBinary());
        }

        public void write(Encoder encoder, Fingerprint value) throws Exception {
            encoder.writeBinary(value.getBytes());
        }
    }

    private static class CacheEntry<T> {
        private final long timestamp;
        private final T value;

        private CacheEntry(long timestamp, T value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }

    private static class PublicKeyRingCacheEntrySerializer
    extends AbstractSerializer<CacheEntry<PGPPublicKeyRing>> {
        private PublicKeyRingCacheEntrySerializer() {
        }

        public CacheEntry<PGPPublicKeyRing> read(Decoder decoder) throws Exception {
            long timestamp = decoder.readLong();
            boolean present = decoder.readBoolean();
            if (present) {
                byte[] encoded = decoder.readBinary();
                PGPObjectFactory objectFactory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(encoded)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                Object object = objectFactory.nextObject();
                if (object instanceof PGPPublicKeyRing) {
                    return new CacheEntry<PGPPublicKeyRing>(timestamp, (PGPPublicKeyRing)object);
                }
                throw new IllegalStateException("Unexpected key in cache: " + object.getClass());
            }
            return new CacheEntry<PGPPublicKeyRing>(timestamp, null);
        }

        public void write(Encoder encoder, CacheEntry<PGPPublicKeyRing> value) throws Exception {
            encoder.writeLong(((CacheEntry)value).timestamp);
            PGPPublicKeyRing key = (PGPPublicKeyRing)((CacheEntry)value).value;
            if (key != null) {
                encoder.writeBoolean(true);
                encoder.writeBinary(key.getEncoded());
            } else {
                encoder.writeBoolean(false);
            }
        }
    }
}

