/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fy" locale.
 */
public class LocalizedNamesImpl_fy extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "VI",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CA",
        "KY",
        "EA",
        "CL",
        "CP",
        "KM",
        "CG",
        "CD",
        "CK",
        "CR",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DE",
        "AT",
        "TL",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "EZ",
        "FO",
        "FK",
        "US",
        "FJ",
        "PH",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GR",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HU",
        "HK",
        "IE",
        "IN",
        "IQ",
        "IR",
        "IM",
        "IL",
        "IT",
        "CI",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "CV",
        "CM",
        "IC",
        "BQ",
        "KZ",
        "KE",
        "KG",
        "KI",
        "KW",
        "CC",
        "CO",
        "XK",
        "HR",
        "CX",
        "CU",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "UM",
        "MO",
        "MK",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NL",
        "NP",
        "NI",
        "NE",
        "NG",
        "NC",
        "NZ",
        "NU",
        "KP",
        "MP",
        "NO",
        "NF",
        "UG",
        "UA",
        "QO",
        "UZ",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "SB",
        "WS",
        "SM",
        "SA",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "CN",
        "SG",
        "SH",
        "SX",
        "CF",
        "SI",
        "SK",
        "SD",
        "SO",
        "ES",
        "SJ",
        "LK",
        "ZA",
        "GS",
        "KR",
        "SS",
        "SR",
        "SZ",
        "CH",
        "CY",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UN",
        "UY",
        "VU",
        "VA",
        "VE",
        "AE",
        "GB",
        "VN",
        "WF",
        "EH",
        "BY",
        "XA",
        "XB",
        "ID",
        "IS",
        "ZM",
        "ZW",
        "SE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Wrâld");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Noard-Amerika");
    namesMap.put("005", "Sûd-Amerika");
    namesMap.put("009", "Oceanië");
    namesMap.put("011", "West-Afrika");
    namesMap.put("013", "Midden-Amerika");
    namesMap.put("014", "East-Afrika");
    namesMap.put("015", "Noard-Afrika");
    namesMap.put("017", "Sintraal-Afrika");
    namesMap.put("018", "Sûdelijk Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Noardlik Amerika");
    namesMap.put("029", "Karibysk gebiet");
    namesMap.put("030", "East-Azië");
    namesMap.put("034", "Sûd-Azië");
    namesMap.put("035", "Sûdoost-Azië");
    namesMap.put("039", "Sûd-Europa");
    namesMap.put("053", "Australazië");
    namesMap.put("054", "Melanesië");
    namesMap.put("057", "Micronesyske regio");
    namesMap.put("061", "Polynesië");
    namesMap.put("142", "Azië");
    namesMap.put("143", "Sintraal-Azië");
    namesMap.put("145", "West-Azië");
    namesMap.put("150", "Europa");
    namesMap.put("151", "East-Europa");
    namesMap.put("154", "Noard-Europa");
    namesMap.put("155", "West-Europa");
    namesMap.put("419", "Latynsk-Amearika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Verenigde Arabyske Emiraten");
    namesMap.put("AG", "Antigua en Barbuda");
    namesMap.put("AL", "Albanië");
    namesMap.put("AM", "Armenië");
    namesMap.put("AR", "Argentinië");
    namesMap.put("AS", "Amerikaansk Samoa");
    namesMap.put("AT", "Eastenryk");
    namesMap.put("AU", "Australië");
    namesMap.put("AX", "Ålân");
    namesMap.put("AZ", "Azerbeidzjan");
    namesMap.put("BA", "Bosnië en Herzegovina");
    namesMap.put("BE", "België");
    namesMap.put("BG", "Bulgarije");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BQ", "Karibysk Nederlân");
    namesMap.put("BR", "Brazilië");
    namesMap.put("BS", "Bahama’s");
    namesMap.put("BV", "Bouveteilân");
    namesMap.put("BY", "Wit-Ruslân");
    namesMap.put("CC", "Kokosilanen");
    namesMap.put("CD", "Congo-Kinshasa");
    namesMap.put("CF", "Sintraal-Afrikaanske Republyk");
    namesMap.put("CG", "Congo-Brazzaville");
    namesMap.put("CH", "Switserlân");
    namesMap.put("CI", "Ivoorkust");
    namesMap.put("CK", "Cookeilannen");
    namesMap.put("CL", "Chili");
    namesMap.put("CM", "Kameroen");
    namesMap.put("CN", "Sina");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kaapverdië");
    namesMap.put("CX", "Krysteilan");
    namesMap.put("CY", "Syprus");
    namesMap.put("CZ", "Tsjechje");
    namesMap.put("DE", "Dútslân");
    namesMap.put("DK", "Denemarken");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikaanske Republyk");
    namesMap.put("DZ", "Algerije");
    namesMap.put("EA", "Ceuta en Melilla");
    namesMap.put("EE", "Estlân");
    namesMap.put("EG", "Egypte");
    namesMap.put("EH", "Westelijke Sahara");
    namesMap.put("ES", "Spanje");
    namesMap.put("ET", "Ethiopië");
    namesMap.put("EU", "Europeeske Unie");
    namesMap.put("FI", "Finlân");
    namesMap.put("FK", "Falklâneilannen");
    namesMap.put("FM", "Micronesië");
    namesMap.put("FO", "Faeröer");
    namesMap.put("FR", "Frankrijk");
    namesMap.put("GB", "Verenigd Koninkrijk");
    namesMap.put("GE", "Georgië");
    namesMap.put("GF", "Frans-Guyana");
    namesMap.put("GL", "Grienlân");
    namesMap.put("GN", "Guinee");
    namesMap.put("GQ", "Equatoriaal-Guinea");
    namesMap.put("GR", "Grikelân");
    namesMap.put("GS", "Sûd-Georgia en Sûdlike Sandwicheilannen");
    namesMap.put("GW", "Guinee-Bissau");
    namesMap.put("HK", "Hongkong SAR van Sina");
    namesMap.put("HM", "Heard- en McDonaldeilannen");
    namesMap.put("HR", "Kroatië");
    namesMap.put("HT", "Haïti");
    namesMap.put("HU", "Hongarije");
    namesMap.put("IC", "Kanaryske Eilânnen");
    namesMap.put("ID", "Yndonesië");
    namesMap.put("IE", "Ierlân");
    namesMap.put("IL", "Israël");
    namesMap.put("IO", "Britse Gebieden yn de Indyske Oseaan");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Yslân");
    namesMap.put("IT", "Italië");
    namesMap.put("JO", "Jordanië");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgizië");
    namesMap.put("KH", "Cambodja");
    namesMap.put("KM", "Comoren");
    namesMap.put("KN", "Saint Kitts en Nevis");
    namesMap.put("KP", "Noard-Korea");
    namesMap.put("KR", "Sûd-Korea");
    namesMap.put("KW", "Koeweit");
    namesMap.put("KY", "Caymaneilannen");
    namesMap.put("KZ", "Kazachstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Saint Lucia");
    namesMap.put("LT", "Litouwen");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Letlân");
    namesMap.put("LY", "Libië");
    namesMap.put("MA", "Marokko");
    namesMap.put("MD", "Moldavië");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("MG", "Madeiaskar");
    namesMap.put("MH", "Marshalleilannen");
    namesMap.put("MK", "Macedonië");
    namesMap.put("MM", "Myanmar (Birma)");
    namesMap.put("MN", "Mongolië");
    namesMap.put("MO", "Macao SAR van Sina");
    namesMap.put("MP", "Noardlike Marianeneilannen");
    namesMap.put("MR", "Mauritanië");
    namesMap.put("MV", "Maldiven");
    namesMap.put("MY", "Maleisië");
    namesMap.put("NA", "Namibië");
    namesMap.put("NC", "Nij-Caledonië");
    namesMap.put("NF", "Norfolkeilân");
    namesMap.put("NL", "Nederlân");
    namesMap.put("NO", "Noarwegen");
    namesMap.put("NZ", "Nij-Seelân");
    namesMap.put("PF", "Frans-Polynesië");
    namesMap.put("PG", "Papoea-Nij-Guinea");
    namesMap.put("PH", "Filipijnen");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "Saint-Pierre en Miquelon");
    namesMap.put("PN", "Pitcairneilannen");
    namesMap.put("PS", "Palestynske gebieten");
    namesMap.put("QO", "Oerig Oceanië");
    namesMap.put("RO", "Roemenië");
    namesMap.put("RS", "Servië");
    namesMap.put("RU", "Ruslân");
    namesMap.put("SA", "Saoedi-Arabië");
    namesMap.put("SB", "Salomonseilannen");
    namesMap.put("SC", "Seychellen");
    namesMap.put("SD", "Soedan");
    namesMap.put("SE", "Zweden");
    namesMap.put("SH", "Sint-Helena");
    namesMap.put("SI", "Slovenië");
    namesMap.put("SJ", "Spitsbergen en Jan Mayen");
    namesMap.put("SK", "Slowakije");
    namesMap.put("SO", "Somalië");
    namesMap.put("SS", "Sûd-Soedan");
    namesMap.put("ST", "Sao Tomé en Principe");
    namesMap.put("SX", "Sint-Maarten");
    namesMap.put("SY", "Syrië");
    namesMap.put("SZ", "Swazilân");
    namesMap.put("TC", "Turks- en Caicoseilannen");
    namesMap.put("TD", "Tsjaad");
    namesMap.put("TF", "Franse Gebieden in de zuidelijke Indyske Oseaan");
    namesMap.put("TH", "Thailân");
    namesMap.put("TJ", "Tadzjikistan");
    namesMap.put("TL", "East-Timor");
    namesMap.put("TN", "Tunesië");
    namesMap.put("TR", "Turkije");
    namesMap.put("TT", "Trinidad en Tobago");
    namesMap.put("UA", "Oekraïne");
    namesMap.put("UG", "Oeganda");
    namesMap.put("UM", "Lyts ôflizzen eilannen fan de Ferienigde Staten");
    namesMap.put("US", "Ferienigde Staten");
    namesMap.put("UZ", "Oezbekistan");
    namesMap.put("VA", "Vaticaanstêd");
    namesMap.put("VC", "Saint Vincent en de Grenadines");
    namesMap.put("VG", "Britse Maagdeneilannen");
    namesMap.put("VI", "Amerikaanske Maagdeneilannen");
    namesMap.put("WF", "Wallis en Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Sûd-Afrika");
    namesMap.put("ZZ", "Unbekend gebiet");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Wrâld",
        "002": "Afrika",
        "003": "Noard-Amerika",
        "005": "Sûd-Amerika",
        "009": "Oceanië",
        "011": "West-Afrika",
        "013": "Midden-Amerika",
        "014": "East-Afrika",
        "015": "Noard-Afrika",
        "017": "Sintraal-Afrika",
        "018": "Sûdelijk Afrika",
        "019": "Amerika",
        "021": "Noardlik Amerika",
        "029": "Karibysk gebiet",
        "030": "East-Azië",
        "034": "Sûd-Azië",
        "035": "Sûdoost-Azië",
        "039": "Sûd-Europa",
        "053": "Australazië",
        "054": "Melanesië",
        "057": "Micronesyske regio",
        "061": "Polynesië",
        "142": "Azië",
        "143": "Sintraal-Azië",
        "145": "West-Azië",
        "150": "Europa",
        "151": "East-Europa",
        "154": "Noard-Europa",
        "155": "West-Europa",
        "419": "Latynsk-Amearika",
        "AC": "Ascension",
        "AE": "Verenigde Arabyske Emiraten",
        "AG": "Antigua en Barbuda",
        "AL": "Albanië",
        "AM": "Armenië",
        "AR": "Argentinië",
        "AS": "Amerikaansk Samoa",
        "AT": "Eastenryk",
        "AU": "Australië",
        "AX": "Ålân",
        "AZ": "Azerbeidzjan",
        "BA": "Bosnië en Herzegovina",
        "BE": "België",
        "BG": "Bulgarije",
        "BH": "Bahrein",
        "BL": "Saint Barthélemy",
        "BQ": "Karibysk Nederlân",
        "BR": "Brazilië",
        "BS": "Bahama’s",
        "BV": "Bouveteilân",
        "BY": "Wit-Ruslân",
        "CC": "Kokosilanen",
        "CD": "Congo-Kinshasa",
        "CF": "Sintraal-Afrikaanske Republyk",
        "CG": "Congo-Brazzaville",
        "CH": "Switserlân",
        "CI": "Ivoorkust",
        "CK": "Cookeilannen",
        "CL": "Chili",
        "CM": "Kameroen",
        "CN": "Sina",
        "CO": "Kolombia",
        "CP": "Clipperton",
        "CU": "Kuba",
        "CV": "Kaapverdië",
        "CX": "Krysteilan",
        "CY": "Syprus",
        "CZ": "Tsjechje",
        "DE": "Dútslân",
        "DK": "Denemarken",
        "DM": "Dominika",
        "DO": "Dominikaanske Republyk",
        "DZ": "Algerije",
        "EA": "Ceuta en Melilla",
        "EE": "Estlân",
        "EG": "Egypte",
        "EH": "Westelijke Sahara",
        "ES": "Spanje",
        "ET": "Ethiopië",
        "EU": "Europeeske Unie",
        "FI": "Finlân",
        "FK": "Falklâneilannen",
        "FM": "Micronesië",
        "FO": "Faeröer",
        "FR": "Frankrijk",
        "GB": "Verenigd Koninkrijk",
        "GE": "Georgië",
        "GF": "Frans-Guyana",
        "GL": "Grienlân",
        "GN": "Guinee",
        "GQ": "Equatoriaal-Guinea",
        "GR": "Grikelân",
        "GS": "Sûd-Georgia en Sûdlike Sandwicheilannen",
        "GW": "Guinee-Bissau",
        "HK": "Hongkong SAR van Sina",
        "HM": "Heard- en McDonaldeilannen",
        "HR": "Kroatië",
        "HT": "Haïti",
        "HU": "Hongarije",
        "IC": "Kanaryske Eilânnen",
        "ID": "Yndonesië",
        "IE": "Ierlân",
        "IL": "Israël",
        "IO": "Britse Gebieden yn de Indyske Oseaan",
        "IQ": "Irak",
        "IS": "Yslân",
        "IT": "Italië",
        "JO": "Jordanië",
        "KE": "Kenia",
        "KG": "Kirgizië",
        "KH": "Cambodja",
        "KM": "Comoren",
        "KN": "Saint Kitts en Nevis",
        "KP": "Noard-Korea",
        "KR": "Sûd-Korea",
        "KW": "Koeweit",
        "KY": "Caymaneilannen",
        "KZ": "Kazachstan",
        "LB": "Libanon",
        "LC": "Saint Lucia",
        "LT": "Litouwen",
        "LU": "Luxemburg",
        "LV": "Letlân",
        "LY": "Libië",
        "MA": "Marokko",
        "MD": "Moldavië",
        "MF": "Saint-Martin",
        "MG": "Madeiaskar",
        "MH": "Marshalleilannen",
        "MK": "Macedonië",
        "MM": "Myanmar (Birma)",
        "MN": "Mongolië",
        "MO": "Macao SAR van Sina",
        "MP": "Noardlike Marianeneilannen",
        "MR": "Mauritanië",
        "MV": "Maldiven",
        "MY": "Maleisië",
        "NA": "Namibië",
        "NC": "Nij-Caledonië",
        "NF": "Norfolkeilân",
        "NL": "Nederlân",
        "NO": "Noarwegen",
        "NZ": "Nij-Seelân",
        "PF": "Frans-Polynesië",
        "PG": "Papoea-Nij-Guinea",
        "PH": "Filipijnen",
        "PL": "Polen",
        "PM": "Saint-Pierre en Miquelon",
        "PN": "Pitcairneilannen",
        "PS": "Palestynske gebieten",
        "QO": "Oerig Oceanië",
        "RO": "Roemenië",
        "RS": "Servië",
        "RU": "Ruslân",
        "SA": "Saoedi-Arabië",
        "SB": "Salomonseilannen",
        "SC": "Seychellen",
        "SD": "Soedan",
        "SE": "Zweden",
        "SH": "Sint-Helena",
        "SI": "Slovenië",
        "SJ": "Spitsbergen en Jan Mayen",
        "SK": "Slowakije",
        "SO": "Somalië",
        "SS": "Sûd-Soedan",
        "ST": "Sao Tomé en Principe",
        "SX": "Sint-Maarten",
        "SY": "Syrië",
        "SZ": "Swazilân",
        "TC": "Turks- en Caicoseilannen",
        "TD": "Tsjaad",
        "TF": "Franse Gebieden in de zuidelijke Indyske Oseaan",
        "TH": "Thailân",
        "TJ": "Tadzjikistan",
        "TL": "East-Timor",
        "TN": "Tunesië",
        "TR": "Turkije",
        "TT": "Trinidad en Tobago",
        "UA": "Oekraïne",
        "UG": "Oeganda",
        "UM": "Lyts ôflizzen eilannen fan de Ferienigde Staten",
        "US": "Ferienigde Staten",
        "UZ": "Oezbekistan",
        "VA": "Vaticaanstêd",
        "VC": "Saint Vincent en de Grenadines",
        "VG": "Britse Maagdeneilannen",
        "VI": "Amerikaanske Maagdeneilannen",
        "WF": "Wallis en Futuna",
        "YE": "Jemen",
        "ZA": "Sûd-Afrika",
        "ZZ": "Unbekend gebiet"
    };
  }-*/;
}
