/*

    WiRouter KeyRec - Salvatore Fresta

    Contact: salvatorefresta@gmail.com

    Copyright 2010-2011 Salvatore Fresta aka Drosophila

    This program is free software; you can redistribute it and/or
    modify it under the terms of  the  GNU General Public License
    as published by the  Free Software Foundation; either version
    2 of the License, or (at your option) any later version.

    This program  is  distributed  in the hope  that  it  will be
    useful, but WITHOUT ANY WARRANTY;  without  even the  implied
    warranty  of  MERCHANTABILITY  or  FITNESS  FOR  A PARTICULAR
    PURPOSE. See the GNU General Public License for more details.

    You should have  received a copy  of  the  GNU General Public
    License along  with  this program;  if not, write to the Free
    Software Foundation,Inc., 59 Temple Place, Suite 330, Boston,
    MA 02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt

*/

#ifndef AGPF_H
#define AGPF_H

#define AGPF_DEFAULT_WEB_PAGE           "http://poc.salvatorefresta.net/agpf_config.lst"
#define AGPF_DEFAULT_CONFIG_FILE_DIR    "/etc/wirouterkeyrec/agpf_config.lst"
#define AGPF_DEFAULT_CONFIG_FILE        "agpf_config.lst"


static const unsigned char telecom_conversion_table[] = {

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,
    0x39,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
    0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,
    0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,

    0x30,0x31,0x32,0x33

};



static const unsigned char telecom_alis[] = {

    0x64,0xC6,0xDD,0xE3,0xE5,0x79,0xB6,0xD9,
    0x86,0x96,0x8D,0x34,0x45,0xD2,0x3B,0x15,
    0xCA,0xAF,0x12,0x84,0x02,0xAC,0x56,0x00,
    0x05,0xCE,0x20,0x75,0x91,0x3F,0xDC,0xE8

};



/*

    For a network could be multiple configurations.

    The following dynamic list contains the multiple technical information about
    the networks, such as the MAC Address Ethernet, the calculated WPA key,
    the complete serial number and the router configuration.

*/

typedef struct agpf_net_conf {

    unsigned char mac_eth[6];
    unsigned char wpa_key[25];
    unsigned char serial[15];

    int k;
    int q;
    int sn1;

    struct agpf_net_conf *next;

} AGPF_config;


void agpf_print_config(AGPF_config *first, int verbose);
void agpf_calculate_wpa_key(unsigned char *alis, int alissize, unsigned char serial[14], unsigned char mac[6], unsigned char wpakey[25]);
void agpf_get_mac_address_ethernet(unsigned char *ssid, unsigned char mac_eth[6], int test);
void agpf_get_serial(int q, int k, int sn1, unsigned char *ssid, unsigned char serial[14], int snsize);
void agpf_print_mac(unsigned char mac[6]);
void agpf_calculate_magic_numbers(unsigned char *ssid_in, unsigned char *serial_in, int *k, int *q);
int agpf_check_agpf(unsigned char *mac, unsigned char *ssid);
int agpf_check_file_exist(unsigned char *filename);
int agpf_update_config_file(unsigned char *filename, unsigned char *host, int port, unsigned char *url, char *delone, char *deltwo, int debug);
unsigned char *agpf_check_ssid(unsigned char *in);
unsigned char *agpf_myfgets(FILE *fd);
AGPF_config *agpf_config_free(AGPF_config *first);
AGPF_config *agpf_config_add(AGPF_config *first, unsigned char mac_eth[6], unsigned char wpa_key[25], unsigned char sn[14], int k, int q, int sn1);
AGPF_config *agpf_get_config(unsigned char *ssid, unsigned char *error, unsigned char *config_file, int debug);

#endif /* AGPF_H */
