/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.CacheEngineVersion;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CacheEngineVersionStaxUnmarshaller
implements Unmarshaller<CacheEngineVersion, StaxUnmarshallerContext> {
    private static CacheEngineVersionStaxUnmarshaller instance;

    public CacheEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheEngineVersion cacheEngineVersion = new CacheEngineVersion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cacheEngineVersion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    cacheEngineVersion.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    cacheEngineVersion.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheParameterGroupFamily", targetDepth)) {
                    cacheEngineVersion.setCacheParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheEngineDescription", targetDepth)) {
                    cacheEngineVersion.setCacheEngineDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CacheEngineVersionDescription", targetDepth)) continue;
                cacheEngineVersion.setCacheEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cacheEngineVersion;
    }

    public static CacheEngineVersionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CacheEngineVersionStaxUnmarshaller();
        }
        return instance;
    }
}

