/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.api.CarbonCluster;
import org.wso2.carbon.core.clustering.api.ClusterMember;
import org.wso2.carbon.core.clustering.api.ClusterMembershipListener;
import org.wso2.carbon.core.clustering.api.ClusterMessage;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;

public class HazelcastCarbonClusterImpl
implements CarbonCluster {
    private static final Log log = LogFactory.getLog(HazelcastCarbonClusterImpl.class);
    private HazelcastInstance hazelcastInstance;
    private List<ClusterMembershipListener> membershipListeners = new ArrayList<ClusterMembershipListener>();
    private List<ClusterMember> primaryClusterMembers = new ArrayList<ClusterMember>();

    public HazelcastCarbonClusterImpl(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public List<ClusterMember> getClusterMembers() {
        return Collections.unmodifiableList(this.primaryClusterMembers);
    }

    @Override
    public void addMembershipListener(ClusterMembershipListener membershipListener) {
        this.membershipListeners.add(membershipListener);
    }

    @Override
    public void removeMembershipListener(ClusterMembershipListener membershipListener) {
        this.membershipListeners.remove(membershipListener);
    }

    @Override
    public void sendMessage(ClusterMessage clusterMessage) {
    }

    @Override
    public void sendMessage(ClusterMessage clusterMessage, List<ClusterMember> members) {
        for (ClusterMember member : members) {
            ITopic msgTopic = this.hazelcastInstance.getTopic("$ReplayMessageQueue:" + member.getId());
            msgTopic.publish((Object)clusterMessage);
        }
    }

    public void memberAdded(Member member) {
        ClusterMember clusterMember = HazelcastUtil.toClusterMember(member);
        for (ClusterMembershipListener membershipListener : this.membershipListeners) {
            membershipListener.memberAdded(clusterMember);
        }
        this.primaryClusterMembers.add(clusterMember);
    }

    public void memberRemoved(Member member) {
        ClusterMember clusterMember = HazelcastUtil.toClusterMember(member);
        for (ClusterMembershipListener membershipListener : this.membershipListeners) {
            membershipListener.memberRemoved(clusterMember);
        }
        this.primaryClusterMembers.remove(clusterMember);
    }
}

