/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.GSISSHSubmission;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHSubmissionResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GSISSHSubmissionResource.class);
    private String submissionID;
    private String resourceJobManager;
    private int sshPort;
    private String installedPath;
    private String monitorMode;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHSubmission", new Object[0][]);
            generator.setParameter("submissionID", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHSubmission", new Object[0][]);
            generator.setParameter("submissionID", identifier);
            Query q = generator.selectQuery(em);
            GSISSHSubmission gsisshSubmission = (GSISSHSubmission)q.getSingleResult();
            GSISSHSubmissionResource gsisshSubmissionResource = (GSISSHSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_SUBMISSION, gsisshSubmission);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            GSISSHSubmissionResource gSISSHSubmissionResource = gsisshSubmissionResource;
            return gSISSHSubmissionResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> gsiSSHSubmissionResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHSubmission", new Object[0][]);
            if (fieldName.equals("monitorMode")) {
                generator.setParameter("monitorMode", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        GSISSHSubmissionResource gsisshSubmissionResource = (GSISSHSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_SUBMISSION, gsisshSubmission);
                        gsiSSHSubmissionResourceList.add(gsisshSubmissionResource);
                    }
                }
            } else if (fieldName.equals("installedPath")) {
                generator.setParameter("installedPath", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        GSISSHSubmissionResource gsisshSubmissionResource = (GSISSHSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_SUBMISSION, gsisshSubmission);
                        gsiSSHSubmissionResourceList.add(gsisshSubmissionResource);
                    }
                }
            } else if (fieldName.equals("sshPort")) {
                generator.setParameter("sshPort", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        GSISSHSubmissionResource gsisshSubmissionResource = (GSISSHSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_SUBMISSION, gsisshSubmission);
                        gsiSSHSubmissionResourceList.add(gsisshSubmissionResource);
                    }
                }
            } else if (fieldName.equals("resourceJobManager")) {
                generator.setParameter("resourceJobManager", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        GSISSHSubmissionResource gsisshSubmissionResource = (GSISSHSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_SUBMISSION, gsisshSubmission);
                        gsiSSHSubmissionResourceList.add(gsisshSubmissionResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for GSISSH submission resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for GSISSH Submission resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gsiSSHSubmissionResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> gsiSSHSubmissionResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHSubmission", new Object[0][]);
            if (fieldName.equals("submissionID")) {
                generator.setParameter("submissionID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        gsiSSHSubmissionResourceIDs.add(gsisshSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("sshPort")) {
                generator.setParameter("sshPort", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        gsiSSHSubmissionResourceIDs.add(gsisshSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("monitorMode")) {
                generator.setParameter("monitorMode", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        gsiSSHSubmissionResourceIDs.add(gsisshSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("resourceJobManager")) {
                generator.setParameter("resourceJobManager", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        gsiSSHSubmissionResourceIDs.add(gsisshSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("installedPath")) {
                generator.setParameter("installedPath", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHSubmission gsisshSubmission = (GSISSHSubmission)result;
                        gsiSSHSubmissionResourceIDs.add(gsisshSubmission.getSubmissionID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for GSISSH Submission resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for GSISSH Submission resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gsiSSHSubmissionResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GSISSHSubmission existingGSISSHSubmission = (GSISSHSubmission)em.find(GSISSHSubmission.class, (Object)this.submissionID);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingGSISSHSubmission != null) {
                existingGSISSHSubmission.setSubmissionID(this.submissionID);
                existingGSISSHSubmission.setSshPort(this.sshPort);
                existingGSISSHSubmission.setResourceJobManager(this.resourceJobManager);
                existingGSISSHSubmission.setInstalledPath(this.installedPath);
                existingGSISSHSubmission.setMonitorMode(this.monitorMode);
                em.merge((Object)existingGSISSHSubmission);
            } else {
                GSISSHSubmission gsisshSubmission = new GSISSHSubmission();
                gsisshSubmission.setSubmissionID(this.submissionID);
                gsisshSubmission.setSshPort(this.sshPort);
                gsisshSubmission.setResourceJobManager(this.resourceJobManager);
                gsisshSubmission.setInstalledPath(this.installedPath);
                gsisshSubmission.setMonitorMode(this.monitorMode);
                em.persist((Object)gsisshSubmission);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GSISSHSubmission gsisshSubmission = (GSISSHSubmission)em.find(GSISSHSubmission.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = gsisshSubmission != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getSubmissionID() {
        return this.submissionID;
    }

    public void setSubmissionID(String submissionID) {
        this.submissionID = submissionID;
    }

    public String getResourceJobManager() {
        return this.resourceJobManager;
    }

    public void setResourceJobManager(String resourceJobManager) {
        this.resourceJobManager = resourceJobManager;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getInstalledPath() {
        return this.installedPath;
    }

    public void setInstalledPath(String installedPath) {
        this.installedPath = installedPath;
    }

    public String getMonitorMode() {
        return this.monitorMode;
    }

    public void setMonitorMode(String monitorMode) {
        this.monitorMode = monitorMode;
    }
}

