/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.eclipselink;

import java.util.Properties;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.embedded.DefaultJpaCompassGps;
import org.compass.gps.device.jpa.embedded.JpaCompassGps;
import org.compass.gps.device.jpa.embedded.eclipselink.CompassSessionEventListener;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ServerSession;

public abstract class EclipseLinkHelper {
    private EclipseLinkHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Compass getCompass(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        try {
            Compass compass = EclipseLinkHelper.getCompass(em);
            return compass;
        }
        finally {
            em.close();
        }
    }

    public static Compass getCompass(EntityManager em) {
        return EclipseLinkHelper.findCompassSessionEventListener(em).getCompass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getIndexSettings(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        try {
            Properties properties = EclipseLinkHelper.getIndexSettings(em);
            return properties;
        }
        finally {
            em.close();
        }
    }

    public static Properties getIndexSettings(EntityManager em) {
        return EclipseLinkHelper.findCompassSessionEventListener(em).getIndexSettings();
    }

    public static CompassSession getCurrentCompassSession(EntityManager em) {
        ServerSession serverSession = ((JpaEntityManager)em).getServerSession();
        UnitOfWork session = ((JpaEntityManager)em).getUnitOfWork();
        return EclipseLinkHelper.findCompassSessionEventListener((Session)serverSession).getCurrentCompassSession((Session)session);
    }

    public static CompassSession getCurrentCompassSession(Session session) {
        return EclipseLinkHelper.findCompassSessionEventListener(session).getCurrentCompassSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JpaCompassGps getCompassGps(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        try {
            JpaCompassGps jpaCompassGps = EclipseLinkHelper.getCompassGps(em);
            return jpaCompassGps;
        }
        finally {
            em.close();
        }
    }

    public static JpaCompassGps getCompassGps(EntityManager em) {
        return EclipseLinkHelper.findCompassSessionEventListener(em).getJpaCompassGps();
    }

    public static JpaCompassGps createCompassGps(JpaGpsDevice device) {
        DefaultJpaCompassGps gps = new DefaultJpaCompassGps(EclipseLinkHelper.getCompass(device.getEntityManagerFactory()));
        device.setMirrorDataChanges(false);
        gps.setIndexProperties(EclipseLinkHelper.getIndexSettings(device.getEntityManagerFactory()));
        gps.addGpsDevice(device);
        return gps;
    }

    private static CompassSessionEventListener findCompassSessionEventListener(EntityManager em) throws CompassException {
        return EclipseLinkHelper.findCompassSessionEventListener((Session)((JpaEntityManager)em).getServerSession());
    }

    private static CompassSessionEventListener findCompassSessionEventListener(Session session) throws CompassException {
        Vector listeners = session.getEventManager().getListeners();
        for (Object o : listeners) {
            if (!(o instanceof CompassSessionEventListener)) continue;
            return (CompassSessionEventListener)((Object)o);
        }
        throw new CompassException("Failed to find CompassSessionEventListener, have you configured Compass with EclipseLink?");
    }
}

