/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.io.File;
import java.util.Map;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.model.appcatalog.computeresource.JobManagerCommand;
import org.apache.commons.io.FilenameUtils;

public class SlurmJobConfiguration
implements JobManagerConfiguration {
    private final Map<JobManagerCommand, String> jMCommands;
    private String jobDescriptionTemplateName;
    private String scriptExtension;
    private String installedPath;
    private OutputParser parser;

    public SlurmJobConfiguration(String jobDescriptionTemplateName, String scriptExtension, String installedPath, Map<JobManagerCommand, String> jobManagerCommands, OutputParser parser) {
        this.jobDescriptionTemplateName = jobDescriptionTemplateName;
        this.scriptExtension = scriptExtension;
        this.parser = parser;
        installedPath = installedPath.trim();
        this.installedPath = installedPath.endsWith("/") ? installedPath : installedPath + "/";
        this.jMCommands = jobManagerCommands;
    }

    public RawCommandInfo getCancelCommand(String jobID) {
        return new RawCommandInfo(this.installedPath + this.jMCommands.get(JobManagerCommand.DELETION).trim() + " " + jobID);
    }

    public String getJobDescriptionTemplateName() {
        return this.jobDescriptionTemplateName;
    }

    public void setJobDescriptionTemplateName(String jobDescriptionTemplateName) {
        this.jobDescriptionTemplateName = jobDescriptionTemplateName;
    }

    public RawCommandInfo getMonitorCommand(String jobID) {
        return new RawCommandInfo(this.installedPath + this.jMCommands.get(JobManagerCommand.JOB_MONITORING).trim() + " -j " + jobID);
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public RawCommandInfo getSubmitCommand(String workingDirectory, String pbsFilePath) {
        return new RawCommandInfo(this.installedPath + this.jMCommands.get(JobManagerCommand.SUBMISSION).trim() + " " + workingDirectory + File.separator + FilenameUtils.getName((String)pbsFilePath));
    }

    public String getInstalledPath() {
        return this.installedPath;
    }

    public void setInstalledPath(String installedPath) {
        this.installedPath = installedPath;
    }

    public OutputParser getParser() {
        return this.parser;
    }

    public void setParser(OutputParser parser) {
        this.parser = parser;
    }

    public RawCommandInfo getUserBasedMonitorCommand(String userName) {
        return new RawCommandInfo(this.installedPath + this.jMCommands.get(JobManagerCommand.JOB_MONITORING).trim() + " -u " + userName);
    }

    public RawCommandInfo getJobIdMonitorCommand(String jobName, String userName) {
        return new RawCommandInfo(this.installedPath + this.jMCommands.get(JobManagerCommand.JOB_MONITORING).trim() + " -n " + jobName + " -u " + userName);
    }

    public String getBaseCancelCommand() {
        return this.jMCommands.get(JobManagerCommand.DELETION).trim();
    }

    public String getBaseMonitorCommand() {
        return this.jMCommands.get(JobManagerCommand.JOB_MONITORING).trim();
    }

    public String getBaseSubmitCommand() {
        return this.jMCommands.get(JobManagerCommand.SUBMISSION).trim();
    }
}

