/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.util;

import de.fzj.unicore.uas.util.State;
import de.fzj.unicore.uas.util.StateInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AnnotationsStateMachine<T> {
    private final T target;
    private String initialState;

    public AnnotationsStateMachine(String initialState, T target) {
        this.target = target;
        this.initialState = initialState;
    }

    public State<T> getInitialState() {
        return new StateImpl<T>(this.initialState, this.target);
    }

    public static class StateImpl<T>
    implements State<T> {
        private String name;
        private Method method;
        private StateInfo annotation;

        public StateImpl(String state, T target) throws IllegalStateException {
            this.name = state;
            this.findMethod(target.getClass());
        }

        private void findMethod(Class<?> spec) throws IllegalStateException {
            try {
                Method[] methods;
                for (Method m : methods = spec.getDeclaredMethods()) {
                    StateInfo meta = m.getAnnotation(StateInfo.class);
                    if (meta == null) continue;
                    String stateName = meta.name();
                    boolean found = false;
                    if (this.name != null) {
                        found = this.name.equals(stateName);
                    } else {
                        found = meta.isInitial();
                        if (found) {
                            this.name = meta.name();
                        }
                    }
                    if (!found) continue;
                    this.method = m;
                    this.annotation = meta;
                    break;
                }
                if (this.method == null && !spec.getSuperclass().equals(Object.class)) {
                    this.findMethod(spec.getSuperclass());
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            if (this.method == null) {
                throw new IllegalStateException("No method found for state <" + this.name + ">");
            }
        }

        @Override
        public State<T> next(T target) throws Exception {
            try {
                this.method.invoke(target, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                if (ite.getTargetException() instanceof Error) {
                    throw (Error)ite.getTargetException();
                }
                throw ite;
            }
            if (this.annotation.isTerminal()) {
                return null;
            }
            String nextState = this.annotation.onSuccess();
            return new StateImpl<T>(nextState, target);
        }

        @Override
        public State<T> onError(T target, Exception ex) throws Exception {
            String errorState = this.annotation.onError();
            if (errorState.isEmpty()) {
                return null;
            }
            return new StateImpl<T>(errorState, target);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isPausable() {
            return this.annotation.isPausable();
        }

        @Override
        public int getNumberOfRetries() {
            return this.annotation.retryCount();
        }

        @Override
        public int getRetryDelay() {
            return this.annotation.retryDelay();
        }
    }
}

