/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.accountprovisioning;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.airavata.accountprovisioning.ConfigParam;
import org.apache.airavata.accountprovisioning.InvalidSetupException;
import org.apache.airavata.accountprovisioning.InvalidUsernameException;
import org.apache.airavata.accountprovisioning.SSHAccountProvisioner;
import org.apache.airavata.accountprovisioning.SSHAccountProvisionerFactory;
import org.apache.airavata.accountprovisioning.SSHUtil;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.client.CredentialStoreClientFactory;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.exception.CredentialStoreException;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.credential.store.SSHCredential;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.client.RegistryServiceClientFactory;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHAccountManager {
    private static final Logger logger = LoggerFactory.getLogger(SSHAccountManager.class);

    public static boolean doesUserHaveSSHAccount(String gatewayId, String computeResourceId, String userId) throws InvalidSetupException, InvalidUsernameException {
        SSHAccountProvisioner sshAccountProvisioner = SSHAccountManager.getSshAccountProvisioner(gatewayId, computeResourceId);
        try {
            return sshAccountProvisioner.hasAccount(userId);
        }
        catch (InvalidUsernameException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("hasAccount call failed for userId [" + userId + "]: " + e.getMessage(), e);
        }
    }

    private static SSHAccountProvisioner getSshAccountProvisioner(String gatewayId, String computeResourceId) throws InvalidSetupException {
        RegistryService.Client registryServiceClient = SSHAccountManager.getRegistryServiceClient();
        ComputeResourcePreference computeResourcePreference = null;
        try {
            computeResourcePreference = registryServiceClient.getGatewayComputeResourcePreference(gatewayId, computeResourceId);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to get ComputeResourcePreference for [" + gatewayId + "] and [" + computeResourceId + "]: " + e.getMessage(), e);
        }
        finally {
            if (registryServiceClient.getInputProtocol().getTransport().isOpen()) {
                registryServiceClient.getInputProtocol().getTransport().close();
            }
            if (registryServiceClient.getOutputProtocol().getTransport().isOpen()) {
                registryServiceClient.getOutputProtocol().getTransport().close();
            }
        }
        if (!computeResourcePreference.isSetSshAccountProvisioner()) {
            throw new InvalidSetupException("Compute resource [" + computeResourceId + "] does not have an SSH Account Provisioner configured for it.");
        }
        return SSHAccountManager.createSshAccountProvisioner(gatewayId, computeResourcePreference);
    }

    public static boolean isSSHAccountSetupComplete(String gatewayId, String computeResourceId, String userId, SSHCredential sshCredential) throws InvalidSetupException, InvalidUsernameException {
        SSHAccountProvisioner sshAccountProvisioner = SSHAccountManager.getSshAccountProvisioner(gatewayId, computeResourceId);
        return sshAccountProvisioner.isSSHAccountProvisioningComplete(userId, sshCredential.getPublicKey());
    }

    public static UserComputeResourcePreference setupSSHAccount(String gatewayId, String computeResourceId, String userId, SSHCredential sshCredential) throws InvalidSetupException, InvalidUsernameException {
        RegistryService.Client registryServiceClient = SSHAccountManager.getRegistryServiceClient();
        ComputeResourcePreference computeResourcePreference = null;
        ComputeResourceDescription computeResourceDescription = null;
        SSHJobSubmission sshJobSubmission = null;
        try {
            computeResourcePreference = registryServiceClient.getGatewayComputeResourcePreference(gatewayId, computeResourceId);
            computeResourceDescription = registryServiceClient.getComputeResource(computeResourceId);
            for (JobSubmissionInterface jobSubmissionInterface : computeResourceDescription.getJobSubmissionInterfaces()) {
                if (jobSubmissionInterface.getJobSubmissionProtocol() != JobSubmissionProtocol.SSH) continue;
                sshJobSubmission = registryServiceClient.getSSHJobSubmission(jobSubmissionInterface.getJobSubmissionInterfaceId());
                break;
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to retrieve compute resource information for [" + gatewayId + "] and [" + computeResourceId + "]: " + e.getMessage(), e);
        }
        finally {
            if (registryServiceClient.getInputProtocol().getTransport().isOpen()) {
                registryServiceClient.getInputProtocol().getTransport().close();
            }
            if (registryServiceClient.getOutputProtocol().getTransport().isOpen()) {
                registryServiceClient.getOutputProtocol().getTransport().close();
            }
        }
        if (sshJobSubmission == null) {
            throw new InvalidSetupException("Compute resource [" + computeResourceId + "] does not have an SSH Job Submission interface.");
        }
        if (!computeResourcePreference.isSetSshAccountProvisioner()) {
            throw new InvalidSetupException("Compute resource [" + computeResourceId + "] does not have an SSH Account Provisioner configured for it.");
        }
        SSHAccountProvisioner sshAccountProvisioner = SSHAccountManager.createSshAccountProvisioner(gatewayId, computeResourcePreference);
        boolean canCreateAccount = SSHAccountProvisionerFactory.canCreateAccount(computeResourcePreference.getSshAccountProvisioner());
        boolean hasAccount = false;
        try {
            hasAccount = sshAccountProvisioner.hasAccount(userId);
        }
        catch (InvalidUsernameException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("hasAccount call failed for userId [" + userId + "]: " + e.getMessage(), e);
        }
        if (!hasAccount && !canCreateAccount) {
            throw new InvalidSetupException("User [" + userId + "] doesn't have account and [" + computeResourceId + "] doesn't have a SSH Account Provisioner that supports creating accounts.");
        }
        String username = null;
        try {
            username = sshAccountProvisioner.installSSHKey(userId, sshCredential.getPublicKey());
        }
        catch (InvalidUsernameException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("installSSHKey call failed for userId [" + userId + "]: " + e.getMessage(), e);
        }
        String sshHostname = SSHAccountManager.getSSHHostname(computeResourceDescription, sshJobSubmission);
        int sshPort = sshJobSubmission.getSshPort();
        boolean validated = false;
        try {
            validated = SSHUtil.validate(sshHostname, sshPort, username, sshCredential);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to validate SSH public key installation for account for user [" + username + "] on host [" + sshHostname + "]: " + e.getMessage(), e);
        }
        if (!validated) {
            throw new RuntimeException("Failed to validate installation of key for [" + username + "] on [" + computeResourceDescription.getHostName() + "] using SSH Account Provisioner [" + computeResourcePreference.getSshAccountProvisioner() + "]");
        }
        String scratchLocation = sshAccountProvisioner.getScratchLocation(userId);
        try {
            SSHUtil.execute(sshHostname, sshPort, username, sshCredential, "mkdir -p " + scratchLocation);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create scratch location [" + scratchLocation + "] for user [" + username + "] on host [" + sshHostname + "]: " + e.getMessage(), e);
        }
        UserComputeResourcePreference userComputeResourcePreference = new UserComputeResourcePreference();
        userComputeResourcePreference.setComputeResourceId(computeResourceId);
        userComputeResourcePreference.setLoginUserName(username);
        userComputeResourcePreference.setScratchLocation(scratchLocation);
        userComputeResourcePreference.setValidated(true);
        return userComputeResourcePreference;
    }

    private static String getSSHHostname(ComputeResourceDescription computeResourceDescription, SSHJobSubmission sshJobSubmission) {
        String alternativeSSHHostName = sshJobSubmission.getAlternativeSSHHostName();
        if (alternativeSSHHostName != null && !"".equals(alternativeSSHHostName.trim())) {
            return alternativeSSHHostName;
        }
        return computeResourceDescription.getHostName();
    }

    private static SSHAccountProvisioner createSshAccountProvisioner(String gatewayId, ComputeResourcePreference computeResourcePreference) throws InvalidSetupException {
        String provisionerName = computeResourcePreference.getSshAccountProvisioner();
        Map<ConfigParam, String> provisionerConfig = SSHAccountManager.convertConfigParams(provisionerName, computeResourcePreference.getSshAccountProvisionerConfig());
        Map<ConfigParam, String> resolvedConfig = SSHAccountManager.resolveProvisionerConfig(gatewayId, provisionerName, provisionerConfig);
        return SSHAccountProvisionerFactory.createSSHAccountProvisioner(provisionerName, resolvedConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<ConfigParam, String> resolveProvisionerConfig(String gatewayId, String provisionerName, Map<ConfigParam, String> provisionerConfig) throws InvalidSetupException {
        CredentialStoreService.Client credentialStoreServiceClient = null;
        try {
            credentialStoreServiceClient = SSHAccountManager.getCredentialStoreClient();
            HashMap<ConfigParam, String> resolvedConfig = new HashMap<ConfigParam, String>();
            for (Map.Entry<ConfigParam, String> configEntry : provisionerConfig.entrySet()) {
                if (configEntry.getKey().getType() == ConfigParam.ConfigParamType.CRED_STORE_PASSWORD_TOKEN) {
                    try {
                        PasswordCredential password = credentialStoreServiceClient.getPasswordCredential(configEntry.getValue(), gatewayId);
                        if (password == null) {
                            throw new InvalidSetupException("Password credential doesn't exist for config param [" + configEntry.getKey().getName() + "] for token [" + configEntry.getValue() + "] for provisioner [" + provisionerName + "].");
                        }
                        resolvedConfig.put(configEntry.getKey(), password.getPassword());
                        continue;
                    }
                    catch (TException e) {
                        throw new RuntimeException("Failed to get password needed to configure " + provisionerName, e);
                    }
                }
                resolvedConfig.put(configEntry.getKey(), configEntry.getValue());
            }
            HashMap<ConfigParam, String> hashMap = resolvedConfig;
            return hashMap;
        }
        finally {
            if (credentialStoreServiceClient != null) {
                if (credentialStoreServiceClient.getInputProtocol().getTransport().isOpen()) {
                    credentialStoreServiceClient.getInputProtocol().getTransport().close();
                }
                if (credentialStoreServiceClient.getOutputProtocol().getTransport().isOpen()) {
                    credentialStoreServiceClient.getOutputProtocol().getTransport().close();
                }
            }
        }
    }

    private static Map<ConfigParam, String> convertConfigParams(String provisionerName, Map<String, String> thriftConfigParams) throws InvalidSetupException {
        List<ConfigParam> configParams = SSHAccountProvisionerFactory.getSSHAccountProvisionerConfigParams(provisionerName);
        Map configParamMap = configParams.stream().collect(Collectors.toMap(ConfigParam::getName, Function.identity()));
        Map<ConfigParam, String> result = thriftConfigParams.entrySet().stream().collect(Collectors.toMap(entry -> (ConfigParam)configParamMap.get(entry.getKey()), entry -> (String)entry.getValue()));
        for (ConfigParam configParam : configParams) {
            if (configParam.isOptional() || result.containsKey(configParam)) continue;
            throw new InvalidSetupException("Missing required ConfigParam named [" + configParam.getName() + "] for provisioner [" + provisionerName + "].");
        }
        return result;
    }

    private static RegistryService.Client getRegistryServiceClient() {
        try {
            String registryServerHost = ServerSettings.getRegistryServerHost();
            int registryServerPort = Integer.valueOf(ServerSettings.getRegistryServerPort());
            return RegistryServiceClientFactory.createRegistryClient((String)registryServerHost, (int)registryServerPort);
        }
        catch (ApplicationSettingsException | RegistryServiceException e) {
            throw new RuntimeException("Failed to create registry service client", e);
        }
    }

    private static CredentialStoreService.Client getCredentialStoreClient() {
        try {
            String credServerHost = ServerSettings.getCredentialStoreServerHost();
            int credServerPort = Integer.valueOf(ServerSettings.getCredentialStoreServerPort());
            return CredentialStoreClientFactory.createAiravataCSClient((String)credServerHost, (int)credServerPort);
        }
        catch (ApplicationSettingsException | CredentialStoreException e) {
            throw new RuntimeException("Failed to create credential store service client", e);
        }
    }
}

