/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.MTOM;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.common.config.WSDLValidatorElement;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationInstance;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationProcessor;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.JAXWSRIWSDLGenerator;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointInterfaceDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.PortInfoImpl;
import org.apache.axis2.jaxws.description.impl.ServiceDescriptionImpl;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.feature.ServerFramework;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.ServerConfiguratorRegistry;
import org.apache.axis2.jaxws.util.CatalogURIResolver;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescriptionImpl
implements EndpointDescription,
EndpointDescriptionJava,
EndpointDescriptionWSDL {
    private ServiceDescriptionImpl parentServiceDescription;
    private AxisService axisService;
    private AxisConfiguration axisConfig;
    private boolean releaseAxisServiceResources = false;
    private QName portQName;
    private QName serviceQName;
    private boolean isDynamicPort;
    private boolean isAxisServiceBuiltFromWSDL;
    private String serviceImplName;
    private EndpointInterfaceDescription endpointInterfaceDescription;
    private ServiceClient serviceClient = null;
    DescriptionBuilderComposite composite = null;
    TreeSet<String> packages = null;
    private PortInfo portInfo;
    private String clientBindingID;
    private String endpointAddress;
    private String wsdlSOAPAddress;
    private static final Log log = LogFactory.getLog(EndpointDescriptionImpl.class);
    private WebService webServiceAnnotation;
    private WebServiceProvider webServiceProviderAnnotation;
    private HandlerChain handlerChainAnnotation;
    private HandlerChainsType handlerChainsType;
    private String annotation_WsdlLocation;
    private String annotation_ServiceName;
    private String annotation_PortName;
    private String annotation_TargetNamespace;
    private String webService_EndpointInterface;
    private String webService_Name;
    private ServiceMode serviceModeAnnotation;
    private Service.Mode serviceModeValue;
    public static final Service.Mode ServiceMode_DEFAULT = Service.Mode.PAYLOAD;
    private BindingType bindingTypeAnnotation;
    private String bindingTypeValue;
    public static final String BindingType_DEFAULT = "http://schemas.xmlsoap.org/wsdl/soap/http";
    private Boolean respectBinding = false;
    private Set<WSDLValidatorElement> requiredBindings = new HashSet<WSDLValidatorElement>();
    private Integer portCompositeIndex = null;
    private List<CustomAnnotationInstance> customAnnotations;
    private Map<String, CustomAnnotationProcessor> customAnnotationProcessors;
    private ServerFramework framework = new ServerFramework();
    private Map<String, Object> properties;
    private Boolean isMTOMEnabledCache = null;
    private static long currentUniqueID = 0L;

    EndpointDescriptionImpl(Class theClass, QName portName, ServiceDescriptionImpl parent) {
        this(theClass, portName, parent, null, null);
    }

    EndpointDescriptionImpl(Class theClass, QName portName, ServiceDescriptionImpl parent, DescriptionBuilderComposite dbc, Object compositeKey) {
        this(theClass, portName, false, parent, dbc, compositeKey);
    }

    EndpointDescriptionImpl(Class theClass, QName portName, boolean dynamicPort, ServiceDescriptionImpl parent) {
        this(theClass, portName, dynamicPort, parent, null, null);
    }

    EndpointDescriptionImpl(Class theClass, QName portName, boolean dynamicPort, ServiceDescriptionImpl parent, DescriptionBuilderComposite sparseComposite, Object sparseCompositeKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entry ");
            log.debug((Object)("  theClass=" + theClass));
            log.debug((Object)("  portName= " + portName));
            log.debug((Object)("  dynamicPort= " + dynamicPort));
            log.debug((Object)("  parent=" + parent));
            log.debug((Object)("  sparseComposite=" + DescriptionUtils.dumpString(sparseComposite)));
        }
        this.axisConfig = parent.getAxisConfigContext().getAxisConfiguration();
        this.parentServiceDescription = parent;
        this.composite = new DescriptionBuilderComposite();
        this.composite.setSparseComposite(sparseCompositeKey, sparseComposite);
        this.composite.setCorrespondingClass(theClass);
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return this.getClass().getClassLoader();
            }
        });
        this.composite.setClassLoader(loader);
        this.composite.setIsServiceProvider(false);
        this.webServiceAnnotation = this.composite.getWebServiceAnnot();
        this.isDynamicPort = dynamicPort;
        this.portQName = DescriptionUtils.isEmpty(portName) ? this.selectPortToUse() : portName;
        if (this.portQName == null) {
            String msg = Messages.getMessage("endpointDescriptionErr1", theClass.getName(), parent.getClass().getName());
            throw ExceptionFactory.makeWebServiceException(msg);
        }
        this.setupAxisService(sparseCompositeKey);
        this.addToAxisService();
        this.setupReleaseResources(this.getServiceDescription().getAxisConfigContext());
        this.buildDescriptionHierachy();
        this.addAnonymousAxisOperations();
        this.getServiceClient();
        try {
            this.getServiceDescriptionImpl().getClientConfigurationFactory().completeAxis2Configuration(this.axisService);
        }
        catch (Exception e) {
            String msg = Messages.getMessage("endpointDescriptionErr2", e.getClass().getName(), parent.getClass().getName());
            throw ExceptionFactory.makeWebServiceException(msg, e);
        }
        finally {
            this.releaseAxisServiceResources();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"exit");
        }
    }

    private void setupReleaseResources(ConfigurationContext configurationContext) {
        Boolean reduceCache;
        if (configurationContext != null) {
            Parameter param;
            AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
            if (axisConfiguration != null && (param = axisConfiguration.getParameter("reduceWSDLMemoryCache")) != null) {
                this.releaseAxisServiceResources = ((String)param.getValue()).equalsIgnoreCase("true");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"EndpointDescription configured to release AxisService resources via reduceWSDLMemoryCache");
                }
            }
        } else if (this.composite != null && (reduceCache = (Boolean)this.composite.getProperties().get("reduceWSDLMemoryCache")) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieved the following reduce WSDL cache value: " + reduceCache + " from the composite: " + this.composite.getClassName()));
            }
            this.releaseAxisServiceResources = reduceCache;
        }
    }

    EndpointDescriptionImpl(ServiceDescriptionImpl parent, String serviceImplName) {
        this(parent, serviceImplName, null, null);
    }

    EndpointDescriptionImpl(ServiceDescriptionImpl parent, String serviceImplName, Map<String, Object> properties, Integer portCompositeIndex) {
        boolean isSOAP11;
        if (log.isDebugEnabled()) {
            log.debug((Object)"entry EndpointDescriptionImpl(ServiceDescriptionImpl, String, Map<String, Object>, Integer)");
            log.debug((Object)("  parent=" + parent));
            log.debug((Object)("  serviceImplName=" + parent));
            log.debug((Object)("  portCompositeIndex=" + portCompositeIndex));
        }
        this.axisConfig = parent.getAxisConfigContext().getAxisConfiguration();
        this.customAnnotations = new ArrayList<CustomAnnotationInstance>();
        this.customAnnotationProcessors = new HashMap<String, CustomAnnotationProcessor>();
        this.portCompositeIndex = portCompositeIndex;
        this.properties = properties;
        this.parentServiceDescription = parent;
        this.serviceImplName = serviceImplName;
        this.composite = parent.getServiceQName() != null ? this.getServiceDescriptionImpl().getDescriptionBuilderComposite(parent.getServiceQName(), portCompositeIndex) : this.getServiceDescriptionImpl().getDescriptionBuilderComposite(null, portCompositeIndex);
        if (this.composite == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescriptionErr3"));
        }
        if (this.composite.getHandlerChainAnnot() != null && this.composite.getHandlerChainsType() != null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerSourceFail", this.composite.getClassName()));
        }
        this.handlerChainsType = this.composite.getHandlerChainsType();
        if (this.composite.getWebServiceAnnot() != null) {
            this.webServiceAnnotation = this.composite.getWebServiceAnnot();
        } else {
            this.webServiceProviderAnnotation = this.composite.getWebServiceProviderAnnot();
        }
        this.customAnnotations.addAll(this.composite.getCustomAnnotationInstances());
        this.customAnnotationProcessors.putAll(this.composite.getCustomAnnotationProcessors());
        if (DescriptionUtils.isEmpty(this.getServiceDescription().getServiceQName())) {
            this.getServiceDescriptionImpl().setServiceQName(this.getServiceQName());
        }
        this.getPortQName();
        this.setupAxisServiceFromDBL();
        this.addToAxisService();
        this.buildDescriptionHierachy();
        WsdlComposite wsdlComposite = null;
        String bindingType = this.getBindingType();
        boolean bl = isSOAP11 = bindingType.equals(BindingType_DEFAULT) || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        if (isSOAP11) {
            DescriptionBuilderComposite seic;
            if (this.isEndpointBased() && DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface()) || !this.isEndpointBased()) {
                wsdlComposite = this.generateWSDL(this.composite);
            } else if (this.isEndpointBased() && (seic = this.getServiceDescriptionImpl().getDBCMap().get(this.composite.getWebServiceAnnot().endpointInterface())).getWsdlDefinition() == null) {
                wsdlComposite = this.generateWSDL(this.composite);
            }
        } else if (this.composite.getWsdlDefinition() == null) {
            log.warn((Object)Messages.getMessage("generateWSDLNonSoap11", this.composite.getClassName()));
        }
        if (isSOAP11) {
            ConfigurationContext cc;
            WSDLDefinitionWrapper wrap;
            URL wsdlUrl;
            Definition def;
            Parameter wsdlLocationParameter = new Parameter();
            wsdlLocationParameter.setName("WSDL_LOCATION");
            Parameter wsdlDefParameter = new Parameter();
            wsdlDefParameter.setName("wsdl4jDefinition");
            Parameter wsdlCompositeParameter = new Parameter();
            wsdlCompositeParameter.setName("WSDL_COMPOSITE");
            if (wsdlComposite != null) {
                wsdlCompositeParameter.setValue(wsdlComposite);
                wsdlLocationParameter.setValue(wsdlComposite.getWsdlFileName());
                def = this.getServiceDescriptionImpl().getGeneratedWsdlWrapper().getDefinition();
                wsdlUrl = this.getServiceDescriptionImpl().getGeneratedWsdlWrapper().getWSDLLocation();
                if (def instanceof WSDLDefinitionWrapper) {
                    wsdlDefParameter.setValue(def);
                } else {
                    wrap = null;
                    cc = this.composite.getConfigurationContext();
                    wrap = cc != null && cc.getAxisConfiguration() != null ? new WSDLDefinitionWrapper(def, wsdlUrl, cc.getAxisConfiguration()) : new WSDLDefinitionWrapper(def, wsdlUrl, true, 2);
                    wsdlDefParameter.setValue(wrap);
                }
            } else if (this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
                wsdlLocationParameter.setValue(this.getAnnoWebServiceWSDLLocation());
                def = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
                wsdlUrl = this.getServiceDescriptionImpl().getWSDLWrapper().getWSDLLocation();
                if (def instanceof WSDLDefinitionWrapper) {
                    wsdlDefParameter.setValue(def);
                } else {
                    wrap = null;
                    cc = this.composite.getConfigurationContext();
                    wrap = cc != null && cc.getAxisConfiguration() != null ? new WSDLDefinitionWrapper(def, wsdlUrl, cc.getAxisConfiguration()) : new WSDLDefinitionWrapper(def, wsdlUrl, true, 2);
                    wsdlDefParameter.setValue(wrap);
                }
            } else {
                wsdlLocationParameter.setValue(null);
                wsdlDefParameter.setValue(null);
            }
            try {
                if (wsdlComposite != null) {
                    this.axisService.addParameter(wsdlCompositeParameter);
                }
                this.axisService.addParameter(wsdlDefParameter);
                this.axisService.addParameter(wsdlLocationParameter);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescriptionErr4"));
            }
        }
        Parameter wsdlDefParameter = new Parameter();
        wsdlDefParameter.setName("wsdl4jDefinition");
        Parameter wsdlLocationParameter = new Parameter();
        wsdlLocationParameter.setName("WSDL_LOCATION");
        if (this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
            wsdlLocationParameter.setValue(this.getAnnoWebServiceWSDLLocation());
            Definition def = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
            URL wsdlUrl = this.getServiceDescriptionImpl().getWSDLWrapper().getWSDLLocation();
            if (def instanceof WSDLDefinitionWrapper) {
                wsdlDefParameter.setValue(def);
            } else {
                WSDLDefinitionWrapper wrap = null;
                ConfigurationContext cc = this.composite.getConfigurationContext();
                wrap = cc != null && cc.getAxisConfiguration() != null ? new WSDLDefinitionWrapper(def, wsdlUrl, cc.getAxisConfiguration()) : new WSDLDefinitionWrapper(def, wsdlUrl, true, 2);
                wsdlDefParameter.setValue(wrap);
            }
        } else {
            wsdlLocationParameter.setValue(null);
            wsdlDefParameter.setValue(null);
        }
        try {
            this.axisService.addParameter(wsdlDefParameter);
            this.axisService.addParameter(wsdlLocationParameter);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescriptionErr4"), e);
        }
        for (CustomAnnotationInstance annotation : this.customAnnotations) {
            CustomAnnotationProcessor processor;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for CustomAnnotationProcessor for CustomAnnotationInstance class: " + annotation.getClass().getName()));
            }
            if ((processor = this.customAnnotationProcessors.get(annotation.getClass().getName())) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found CustomAnnotationProcessor: " + processor.getClass().getName() + " for CustomAnnotationInstance: " + annotation.getClass().getName()));
            }
            processor.processTypeLevelAnnotation(this, annotation);
        }
        this.configureWebServiceFeatures();
        this.setupReleaseResources(this.composite.getConfigurationContext());
        this.releaseAxisServiceResources();
        if (log.isDebugEnabled()) {
            log.debug((Object)"exit EndpointDescriptionImpl(ServiceDescriptionImpl, String, Map<String, Object>, Integer)");
        }
    }

    private void addToAxisService() {
        if (this.axisService != null) {
            Parameter parameter = new Parameter();
            parameter.setName("org.apache.axis2.jaxws.description.EndpointDescription");
            parameter.setValue(this);
            try {
                this.axisService.addParameter(parameter);
            }
            catch (AxisFault e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescriptionErr5", "org.apache.axis2.jaxws.description.EndpointDescription"), e);
            }
        }
    }

    private void buildEndpointDescriptionFromAnnotations() {
        if (this.webServiceAnnotation != null) {
            String seiClassName = this.getAnnoWebServiceEndpointInterface();
            if (!this.composite.isServiceProvider()) {
                Class seiClass = null;
                if (DescriptionUtils.isEmpty(seiClassName)) {
                    seiClass = this.composite.getCorrespondingClass();
                }
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(seiClass, this);
            } else if (DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface())) {
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.composite, true, this);
            } else {
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.getServiceDescriptionImpl().getDBCMap().get(seiClassName), false, this);
                if (this.axisService != null) {
                    this.updateWebServiceNameParameter(((EndpointInterfaceDescriptionImpl)this.endpointInterfaceDescription).getAnnoWebServiceName(), this.axisService);
                }
            }
        } else {
            String bindingType;
            if (log.isDebugEnabled()) {
                log.debug((Object)"WebServiceProvider without WSDL encountered");
            }
            if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingType = this.getBindingType()) || BindingType_DEFAULT.equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingType) || "SOAP_HTTP_BINDING".equals(bindingType)) {
                this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.composite, this);
            }
        }
    }

    @Override
    public QName getPortQName() {
        if (this.portQName == null) {
            String name = this.getAnnoWebServicePortName();
            String tns = this.getAnnoWebServiceTargetNamespace();
            this.portQName = new QName(tns, name);
        }
        return this.portQName;
    }

    @Override
    public QName getServiceQName() {
        if (this.serviceQName == null) {
            QName serviceDescQName = this.getServiceDescription().getServiceQName();
            if (!DescriptionUtils.isEmpty(serviceDescQName)) {
                this.serviceQName = serviceDescQName;
            } else {
                String localPart = this.getAnnoWebServiceServiceName();
                String tns = this.getAnnoWebServiceTargetNamespace();
                this.serviceQName = new QName(tns, localPart);
            }
        }
        return this.serviceQName;
    }

    @Override
    public ServiceDescription getServiceDescription() {
        return this.parentServiceDescription;
    }

    public ServiceDescriptionImpl getServiceDescriptionImpl() {
        return this.parentServiceDescription;
    }

    @Override
    public EndpointInterfaceDescription getEndpointInterfaceDescription() {
        return this.endpointInterfaceDescription;
    }

    @Override
    public AxisService getAxisService() {
        return this.axisService;
    }

    boolean isDynamicPort() {
        return this.isDynamicPort;
    }

    void updateWithSEI(Class sei, DescriptionBuilderComposite sparseComposite, Object sparseCompositeKey) {
        if (this.isDynamicPort()) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("updateWithSEIErr1", this.portQName.toString()));
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("updateWithSEIErr2", this.portQName.toString()));
        }
        this.composite.setSparseComposite(sparseCompositeKey, sparseComposite);
        if (this.endpointInterfaceDescription != null) {
            ((EndpointInterfaceDescriptionImpl)this.endpointInterfaceDescription).updateWithSEI(sei);
        } else {
            this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(sei, this);
        }
    }

    private void setupAxisService(Object sparseCompositeKey) {
        if (!this.isDynamicPort && this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
            this.isAxisServiceBuiltFromWSDL = this.buildAxisServiceFromWSDL();
        } else if (this.useGeneratedWSDL()) {
            this.buildAxisServiceFromGeneratedWSDL();
        } else {
            this.buildAxisServiceFromAnnotations();
            this.addAnnotationParamToService();
        }
        if (this.axisService == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr1", this.createAxisServiceName()));
        }
        Parameter serviceNameParameter = new Parameter();
        serviceNameParameter.setName("WSDL_SERVICE_QNAME");
        serviceNameParameter.setValue(this.getServiceDescription().getServiceQName());
        Parameter portParameter = new Parameter();
        portParameter.setName("WSDL_PORT");
        portParameter.setValue(this.portQName.getLocalPart());
        Parameter serviceClassNameParam = new Parameter();
        serviceClassNameParam.setName("CLIENT_SERVICE_CLASS");
        String serviceClassName = this.getServiceDescriptionImpl().getServiceClassName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting service class name parameter to: " + serviceClassName + " on AxisService: " + this.axisService + "@" + this.axisService.hashCode()));
        }
        serviceClassNameParam.setValue(serviceClassName);
        Parameter seiClassNameParam = new Parameter();
        seiClassNameParam.setName("CLIENT_SEI_CLASS");
        String seiClassName = this.composite.getClassName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting sei class name parameter to: " + seiClassName + " on AxisService: " + this.axisService + "@" + this.axisService.hashCode()));
        }
        seiClassNameParam.setValue(seiClassName);
        Parameter serviceRefNameParam = this.getServiceRefNameParam(sparseCompositeKey);
        try {
            this.axisService.addParameter(serviceNameParameter);
            this.axisService.addParameter(portParameter);
            this.axisService.addParameter(serviceClassNameParam);
            this.axisService.addParameter(seiClassNameParam);
            if (serviceRefNameParam != null) {
                this.axisService.addParameter(serviceRefNameParam);
            }
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr2"), e);
        }
    }

    private Parameter getServiceRefNameParam(Object sparseCompositeKey) {
        Parameter serviceRefNameParam = null;
        String serviceRefName = this.getServiceDescriptionImpl().getDescriptionBuilderComposite().getServiceRefName(sparseCompositeKey);
        if (!DescriptionUtils.isEmpty(serviceRefName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting service ref name: " + serviceRefName + " on AxisService: " + this.axisService + "@" + this.axisService.hashCode()));
            }
            serviceRefNameParam = new Parameter();
            serviceRefNameParam.setName("org.apache.axis2.jaxws.description.builder.SERVICE_REF_NAME");
            serviceRefNameParam.setValue(serviceRefName);
        }
        return serviceRefNameParam;
    }

    private void setupAxisServiceFromDBL() {
        this.isAxisServiceBuiltFromWSDL = false;
        if (this.getServiceDescriptionImpl().getWSDLWrapper() != null) {
            this.isAxisServiceBuiltFromWSDL = this.buildAxisServiceFromWSDL();
        }
        if (!this.isAxisServiceBuiltFromWSDL) {
            if (this.useGeneratedWSDL()) {
                this.buildAxisServiceFromGeneratedWSDL();
            } else {
                this.buildAxisServiceFromAnnotations();
                this.addAnnotationParamToService();
            }
        }
        if (this.axisService == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr1", this.createAxisServiceName()));
        }
        Parameter portTypeNameParameter = new Parameter();
        portTypeNameParameter.setName("WSDL_PORTTYPE_NAME");
        portTypeNameParameter.setValue(this.getName());
        Parameter serviceNameParameter = new Parameter();
        serviceNameParameter.setName("WSDL_SERVICE_QNAME");
        serviceNameParameter.setValue(this.getServiceDescription().getServiceQName());
        Parameter portParameter = new Parameter();
        portParameter.setName("WSDL_PORT");
        portParameter.setValue(this.getPortQName().getLocalPart());
        Parameter serviceClassNameParameter = new Parameter();
        serviceClassNameParameter.setName("ServiceClass");
        serviceClassNameParameter.setValue(DescriptionUtils.javifyClassName(this.composite.getClassName()));
        try {
            this.axisService.addParameter(portTypeNameParameter);
            this.axisService.addParameter(serviceNameParameter);
            this.axisService.addParameter(portParameter);
            this.axisService.addParameter(serviceClassNameParameter);
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr2"), e);
        }
    }

    private boolean buildAxisServiceFromWSDL() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entry");
        }
        boolean isBuiltFromWSDL = false;
        try {
            WSDLDefinitionWrapper wrapper;
            Parameter wsdlWrapperParam;
            Definition def = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
            WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(def, this.getServiceDescription().getServiceQName(), this.getPortQName().getLocalPart());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building AxisService from wsdl: " + this.getServiceDescriptionImpl().getWSDLWrapper().getWSDLLocation()));
                log.debug((Object)"Build Axis Service from WSDL ");
                log.debug((Object)("  Service QName =" + this.getServiceDescription().getServiceQName()));
                log.debug((Object)("  Port QName = " + this.getPortQName()));
                log.debug((Object)("  WSDL = " + def.toString()));
            }
            ClassLoader classLoader = this.composite.isServiceProvider() ? this.composite.getClassLoader() : EndpointDescriptionImpl.getContextClassLoader(null);
            JAXWSCatalogManager catalogManager = this.getServiceDescriptionImpl().getCatalogManager();
            CatalogURIResolver uriResolver = new CatalogURIResolver(catalogManager, classLoader);
            serviceBuilder.setCustomResolver(uriResolver);
            if (this.getServiceDescriptionImpl().isServerSide()) {
                serviceBuilder.setServerSide(true);
            } else {
                serviceBuilder.setServerSide(false);
            }
            AxisConfiguration ac = null;
            if (this.composite.getConfigurationContext() != null && (ac = this.composite.getConfigurationContext().getAxisConfiguration()) != null) {
                serviceBuilder.useAxisConfiguration(ac);
            }
            this.axisService = serviceBuilder.populateService();
            if (ac == null && (wsdlWrapperParam = this.axisService.getParameter("wsdl4jDefinition")) != null && wsdlWrapperParam.getValue() instanceof WSDLDefinitionWrapper && (wrapper = (WSDLDefinitionWrapper)wsdlWrapperParam.getValue()).getMemoryLimitType() == 0) {
                Definition wsdlDef = wrapper.getUnwrappedDefinition();
                WSDLDefinitionWrapper wrapper2 = new WSDLDefinitionWrapper(wsdlDef, true, 2);
                wsdlWrapperParam.setValue(wrapper2);
            }
            this.axisService.setName(this.createAxisServiceName());
            isBuiltFromWSDL = true;
        }
        catch (AxisFault e) {
            String wsdlLocation = this.getServiceDescriptionImpl().getWSDLLocation() != null ? this.getServiceDescriptionImpl().getWSDLLocation().toString() : null;
            String implClassName = this.composite.getClassName();
            log.warn((Object)Messages.getMessage("bldAxisSrvcFromWSDLErr", implClassName, wsdlLocation, e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception processing WSDL file.  Impl class: " + implClassName + "; WSDL Location: " + wsdlLocation), (Throwable)e);
            }
            isBuiltFromWSDL = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exit isBuiltFromWSDL = " + isBuiltFromWSDL));
        }
        return isBuiltFromWSDL;
    }

    private void buildAxisServiceFromGeneratedWSDL() {
        this.buildAxisServiceFromAnnotations();
        Parameter serviceClassNameParameter = new Parameter();
        serviceClassNameParameter.setName("ServiceClass");
        serviceClassNameParameter.setValue(DescriptionUtils.javifyClassName(this.composite.getClassName()));
        try {
            this.axisService.addParameter(serviceClassNameParameter);
        }
        catch (AxisFault axisFault) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr2"), axisFault);
        }
        this.addToAxisService();
        JAXWSRIWSDLGenerator wsdlGenerator = new JAXWSRIWSDLGenerator(this.axisService, this.axisConfig);
        try {
            Definition def = wsdlGenerator.getWSDL(this.axisService);
            WSDL11ToAxisServiceBuilder axisServiceBuilder = new WSDL11ToAxisServiceBuilder(def, this.getServiceDescription().getServiceQName(), this.getPortQName().getLocalPart());
            if (this.getServiceDescriptionImpl().isServerSide()) {
                axisServiceBuilder.setServerSide(true);
            } else {
                axisServiceBuilder.setServerSide(false);
            }
            this.axisService = axisServiceBuilder.populateService();
            this.axisService.setName(this.getServiceDescription().getServiceQName().getLocalPart());
            this.axisService.setParent(this.axisConfig);
            for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
                axisEndpoint.setTransportInDescription("http");
                axisEndpoint.setEndpointURL(null);
            }
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr3"), e);
        }
    }

    private boolean useGeneratedWSDL() {
        Parameter param = this.axisConfig.getParameter("useGeneratedWSDLinJAXWS");
        return param != null && "true".equals(param.getValue());
    }

    private void addAnnotationParamToService() {
        try {
            this.axisService.addParameter("usedAnnotationsOnly", "true");
        }
        catch (AxisFault axisFault) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr2"), axisFault);
        }
    }

    private void buildAxisServiceFromAnnotations() {
        String serviceName = null;
        serviceName = this.portQName != null ? this.createAxisServiceName() : "anonService" + this.hashCode() + System.currentTimeMillis();
        this.axisService = new AxisService(serviceName);
        try {
            String bindingType = this.getBindingType();
            String protocol = "http";
            if (bindingType.startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                Utils.addSoap12Endpoint(this.axisService, protocol, this.getPortQName().getLocalPart());
            } else if (bindingType.startsWith("http://www.w3.org/2004/08/wsdl/http")) {
                Utils.addHttpEndpoint(this.axisService, protocol, this.getPortQName().getLocalPart());
            } else {
                Utils.addSoap11Endpoint(this.axisService, protocol, this.getPortQName().getLocalPart());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while generating the Endpoint for service :" + this.axisService.getName()));
        }
    }

    private void releaseAxisServiceResources() {
        if (this.releaseAxisServiceResources && this.axisService != null) {
            this.axisService.releaseSchemaList();
        }
    }

    private void buildDescriptionHierachy() {
        if (this.composite.isServiceProvider()) {
            if (!this.isDynamicPort && this.isWSDLFullySpecified()) {
                this.buildEndpointDescriptionFromWSDL();
            } else {
                this.buildEndpointDescriptionFromAnnotations();
            }
        } else if (!this.isDynamicPort && this.isWSDLFullySpecified()) {
            this.buildEndpointDescriptionFromWSDL();
        } else if (this.composite.getCorrespondingClass() != null) {
            this.buildEndpointDescriptionFromAnnotations();
        }
    }

    private void buildEndpointDescriptionFromWSDL() {
        Definition wsdlDefinition = this.getServiceDescriptionImpl().getWSDLWrapper().getDefinition();
        Service wsdlService = wsdlDefinition.getService(this.getServiceDescription().getServiceQName());
        if (wsdlService == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr2", this.createAxisServiceName()));
        }
        Map wsdlPorts = wsdlService.getPorts();
        boolean wsdlPortFound = false;
        if (wsdlPorts != null && wsdlPorts.size() > 0) {
            Iterator wsdlPortIterator = wsdlPorts.values().iterator();
            while (wsdlPortIterator.hasNext() && !wsdlPortFound) {
                Port wsdlPort = (Port)wsdlPortIterator.next();
                if (!wsdlPort.getName().equals(this.portQName.getLocalPart())) continue;
                if (this.composite.isServiceProvider()) {
                    String seiClassName = this.getAnnoWebServiceEndpointInterface();
                    if (DescriptionUtils.isEmpty(seiClassName)) {
                        this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.composite, true, this);
                    } else {
                        this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this.getServiceDescriptionImpl().getDBCMap().get(seiClassName), false, this);
                        if (this.axisService != null) {
                            this.updateWebServiceNameParameter(((EndpointInterfaceDescriptionImpl)this.endpointInterfaceDescription).getAnnoWebServiceName(), this.axisService);
                        }
                    }
                } else {
                    this.endpointInterfaceDescription = new EndpointInterfaceDescriptionImpl(this);
                    ((EndpointInterfaceDescriptionImpl)this.endpointInterfaceDescription).updateWithSEI(this.composite.getCorrespondingClass());
                }
                wsdlPortFound = true;
            }
        }
        if (!wsdlPortFound) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr3", this.portQName.getLocalPart()));
        }
    }

    private void addAnonymousAxisOperations() {
        if (this.axisService != null) {
            OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ServiceClient.ANON_OUT_ONLY_OP);
            this.axisService.addOperation(outOnlyOperation);
            outOnlyOperation.setSoapAction(null);
            OutInAxisOperation outInOperation = new OutInAxisOperation(ServiceClient.ANON_OUT_IN_OP);
            this.axisService.addOperation(outInOperation);
            outInOperation.setSoapAction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ServiceClient getServiceClient() {
        block7: {
            try {
                AxisConfiguration axisCfg;
                if (this.serviceClient != null) break block7;
                ConfigurationContext configCtx = this.getServiceDescription().getAxisConfigContext();
                AxisService axisSvc = this.getAxisService();
                AxisConfiguration axisConfiguration = axisCfg = configCtx.getAxisConfiguration();
                synchronized (axisConfiguration) {
                    if (axisCfg.getService(axisSvc.getName()) != null) {
                        axisSvc.setName(axisSvc.getName() + this.uniqueID());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("AxisService name is now " + axisSvc.getName() + ". This name should be unique; if not, errors might occur."));
                        }
                    }
                    this.serviceClient = new ServiceClient(configCtx, axisSvc);
                    this.serviceClient.getOptions().setProperty("ServiceClient.autoOperationCleanup", false);
                }
            }
            catch (AxisFault e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceClientCreateError"), e);
            }
        }
        return this.serviceClient;
    }

    private String createAxisServiceName() {
        return this.getServiceDescription().getServiceQName().getLocalPart();
    }

    @Override
    public boolean isWSDLFullySpecified() {
        return this.isAxisServiceBuiltFromWSDL;
    }

    @Override
    public boolean isProviderBased() {
        return this.webServiceProviderAnnotation != null;
    }

    @Override
    public boolean isEndpointBased() {
        return this.webServiceAnnotation != null;
    }

    @Override
    public String getAnnoWebServiceWSDLLocation() {
        if (this.annotation_WsdlLocation == null) {
            if (this.getAnnoWebService() != null) {
                DescriptionBuilderComposite seic;
                this.annotation_WsdlLocation = this.getAnnoWebService().wsdlLocation();
                if (this.composite.isServiceProvider() && !DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface()) && !DescriptionUtils.isEmpty((seic = this.getServiceDescriptionImpl().getDBCMap().get(this.composite.getWebServiceAnnot().endpointInterface())).getWebServiceAnnot().wsdlLocation())) {
                    this.annotation_WsdlLocation = seic.getWebServiceAnnot().wsdlLocation();
                }
            } else {
                this.annotation_WsdlLocation = this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().wsdlLocation()) ? this.getAnnoWebServiceProvider().wsdlLocation() : "";
            }
        }
        return this.annotation_WsdlLocation;
    }

    @Override
    public String getAnnoWebServiceServiceName() {
        if (this.annotation_ServiceName == null) {
            this.annotation_ServiceName = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().serviceName()) ? this.getAnnoWebService().serviceName() : (this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().serviceName()) ? this.getAnnoWebServiceProvider().serviceName() : DescriptionUtils.getSimpleJavaClassName(this.composite.getClassName()) + "Service");
        }
        return this.annotation_ServiceName;
    }

    @Override
    public String getAnnoWebServicePortName() {
        if (this.annotation_PortName == null) {
            this.annotation_PortName = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().portName()) ? this.getAnnoWebService().portName() : (this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().portName()) ? this.getAnnoWebServiceProvider().portName() : (this.isProviderBased() ? DescriptionUtils.getSimpleJavaClassName(this.composite.getClassName()) + "Port" : this.getAnnoWebServiceName() + "Port"));
        }
        return this.annotation_PortName;
    }

    @Override
    public String getAnnoWebServiceTargetNamespace() {
        if (this.annotation_TargetNamespace == null) {
            this.annotation_TargetNamespace = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().targetNamespace()) ? this.getAnnoWebService().targetNamespace() : (this.getAnnoWebServiceProvider() != null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceProvider().targetNamespace()) ? this.getAnnoWebServiceProvider().targetNamespace() : DescriptionUtils.makeNamespaceFromPackageName(DescriptionUtils.getJavaPackageName(this.composite.getClassName()), "http"));
        }
        return this.annotation_TargetNamespace;
    }

    @Override
    public WebServiceProvider getAnnoWebServiceProvider() {
        return this.webServiceProviderAnnotation;
    }

    @Override
    public WebService getAnnoWebService() {
        return this.webServiceAnnotation;
    }

    @Override
    public String getAnnoWebServiceEndpointInterface() {
        if (this.webService_EndpointInterface == null) {
            this.webService_EndpointInterface = !this.isProviderBased() && this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().endpointInterface()) ? this.getAnnoWebService().endpointInterface() : "";
        }
        return this.webService_EndpointInterface;
    }

    @Override
    public String getAnnoWebServiceName() {
        if (this.webService_Name == null) {
            this.webService_Name = !this.isProviderBased() ? (this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().name()) ? this.getAnnoWebService().name() : DescriptionUtils.getSimpleJavaClassName(this.composite.getClassName())) : "";
        }
        return this.webService_Name;
    }

    @Override
    public ServiceMode getAnnoServiceMode() {
        if (this.serviceModeAnnotation == null) {
            this.serviceModeAnnotation = this.composite.getServiceModeAnnot();
        }
        return this.serviceModeAnnotation;
    }

    @Override
    public Service.Mode getServiceMode() {
        return this.getAnnoServiceModeValue();
    }

    @Override
    public Service.Mode getAnnoServiceModeValue() {
        if (this.isProviderBased() && this.serviceModeValue == null) {
            this.serviceModeValue = this.getAnnoServiceMode() != null ? this.getAnnoServiceMode().value() : ServiceMode_DEFAULT;
        }
        return this.serviceModeValue;
    }

    @Override
    public BindingType getAnnoBindingType() {
        if (this.bindingTypeAnnotation == null) {
            this.bindingTypeAnnotation = this.composite.getBindingTypeAnnot();
        }
        return this.bindingTypeAnnotation;
    }

    @Override
    public String getBindingType() {
        return this.getAnnoBindingTypeValue();
    }

    @Override
    public String getAnnoBindingTypeValue() {
        if (this.bindingTypeValue == null) {
            this.bindingTypeValue = this.getAnnoBindingType() != null && !DescriptionUtils.isEmpty(this.getAnnoBindingType().value()) ? this.getAnnoBindingType().value() : BindingType_DEFAULT;
        }
        return this.bindingTypeValue;
    }

    @Override
    public void setHandlerChain(HandlerChainsType handlerChain) {
        this.handlerChainsType = handlerChain;
    }

    @Override
    public HandlerChainsType getHandlerChain() {
        return this.getHandlerChain(null);
    }

    @Override
    public HandlerChainsType getHandlerChain(Object sparseCompositeKey) {
        DescriptionBuilderComposite sparseComposite = null;
        if (sparseCompositeKey != null && (sparseComposite = this.composite.getSparseComposite(sparseCompositeKey)) != null && sparseComposite.getHandlerChainsType() != null) {
            HandlerChainsType hct = sparseComposite.getHandlerChainsType();
            return hct;
        }
        if (this.handlerChainsType == null) {
            this.getAnnoHandlerChainAnnotation(sparseCompositeKey);
            if (this.handlerChainAnnotation != null) {
                String handlerChainDeclaringClass;
                InputStream is;
                ClassLoader classLoader;
                String handlerFileName = this.handlerChainAnnotation.file();
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("handlerChainsTypeErr", handlerFileName, this.composite.getClassName()));
                }
                String className = this.composite.getClassName();
                ClassLoader classLoader2 = classLoader = this.composite.isServiceProvider() ? this.composite.getClassLoader() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return this.getClass().getClassLoader();
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying to load file " + handlerFileName + " relative to " + className));
                }
                if ((is = DescriptionUtils.openHandlerConfigStream(handlerFileName, className, classLoader)) == null && sparseComposite != null && (handlerChainDeclaringClass = (String)sparseComposite.getProperties().get("HANDLER_CHAIN_DECLARING_CLASS")) != null) {
                    className = handlerChainDeclaringClass;
                    is = DescriptionUtils.openHandlerConfigStream(handlerFileName, className, classLoader);
                }
                if (is == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainNS", handlerFileName, className));
                }
                ClassLoader classLoader1 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return this.getClass().getClassLoader();
                    }
                });
                this.handlerChainsType = DescriptionUtils.loadHandlerChains(is, classLoader1);
            }
        }
        return this.handlerChainsType;
    }

    public HandlerChain getAnnoHandlerChainAnnotation(Object sparseCompositeKey) {
        DescriptionBuilderComposite sparseComposite;
        if (this.handlerChainAnnotation == null) {
            if (this.composite.isServiceProvider()) {
                DescriptionBuilderComposite seic;
                this.handlerChainAnnotation = this.composite.getHandlerChainAnnot();
                if (this.handlerChainAnnotation == null && !DescriptionUtils.isEmpty(this.getAnnoWebServiceEndpointInterface()) && (seic = this.getServiceDescriptionImpl().getDBCMap().get(this.composite.getWebServiceAnnot().endpointInterface())) != null) {
                    this.handlerChainAnnotation = seic.getHandlerChainAnnot();
                }
            } else {
                this.handlerChainAnnotation = this.composite.getHandlerChainAnnot();
            }
        }
        if (this.handlerChainAnnotation == null && sparseCompositeKey != null && (sparseComposite = this.composite.getSparseComposite(sparseCompositeKey)) != null && sparseComposite.getHandlerChainAnnot() != null) {
            this.handlerChainAnnotation = sparseComposite.getHandlerChainAnnot();
        }
        return this.handlerChainAnnotation;
    }

    @Override
    public boolean isMTOMEnabled() {
        if (this.isMTOMEnabledCache != null) {
            return this.isMTOMEnabledCache;
        }
        MTOM mtomAnnotation = (MTOM)this.getAnnoFeature("http://www.w3.org/2004/08/soap/features/http-optimization");
        if (mtomAnnotation != null) {
            this.isMTOMEnabledCache = mtomAnnotation.enabled();
            return this.isMTOMEnabledCache;
        }
        String bindingType = this.getBindingType();
        this.isMTOMEnabledCache = EndpointDescriptionImpl.isMTOMBinding(bindingType);
        return this.isMTOMEnabledCache;
    }

    private static boolean isMTOMBinding(String url) {
        return url != null && (url.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || url.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || url.equals("http://www.w3.org/2010/soapjms/?mtom=true") || url.equals("http://www.w3.org/2010/soapjms/?mtom=true"));
    }

    @Override
    public boolean respectBinding() {
        return this.respectBinding;
    }

    @Override
    public void setRespectBinding(boolean r) {
        this.respectBinding = r;
    }

    @Override
    public boolean addRequiredBinding(WSDLValidatorElement element) {
        return this.requiredBindings.add(element);
    }

    @Override
    public Set<WSDLValidatorElement> getRequiredBindings() {
        return this.requiredBindings;
    }

    @Override
    public int getMTOMThreshold() {
        Parameter mtomThreshold;
        if (this.axisService != null && (mtomThreshold = this.axisService.getParameter("mtomThreshold")) != null) {
            return (Integer)mtomThreshold.getValue();
        }
        return -1;
    }

    @Override
    public Annotation getAnnoFeature(String id) {
        return this.framework.getAnnotation(id);
    }

    private void configureWebServiceFeatures() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start configureWebServiceFeatures().");
        }
        String bindingType = this.getBindingType();
        Set<String> ids = ServerConfiguratorRegistry.getIds();
        for (String id : ids) {
            ServerConfigurator configurator = ServerConfiguratorRegistry.getConfigurator(id);
            if (!configurator.supports(bindingType)) continue;
            this.framework.addConfigurator(id, configurator);
        }
        List<Annotation> features = this.composite.getWebServiceFeatures();
        if (features != null && features.size() > 0) {
            for (Annotation feature : features) {
                this.framework.addAnnotation(feature);
            }
            this.framework.configure(this);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No WebServiceFeatureAnnotation instances were found on the composite.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit configureWebServiceFeatures().");
        }
    }

    @Override
    public Definition getWSDLDefinition() {
        return ((ServiceDescriptionWSDL)((Object)this.getServiceDescription())).getWSDLDefinition();
    }

    @Override
    public Service getWSDLService() {
        Definition defn = this.getWSDLDefinition();
        if (defn != null) {
            return defn.getService(this.getServiceQName());
        }
        return null;
    }

    @Override
    public Port getWSDLPort() {
        Service service = this.getWSDLService();
        if (service != null) {
            return service.getPort(this.getPortQName().getLocalPart());
        }
        return null;
    }

    @Override
    public Binding getWSDLBinding() {
        Binding wsdlBinding = null;
        Port wsdlPort = this.getWSDLPort();
        Definition wsdlDef = this.getWSDLDefinition();
        if (wsdlPort != null && wsdlDef != null) {
            wsdlBinding = wsdlPort.getBinding();
        }
        return wsdlBinding;
    }

    @Override
    public String getWSDLBindingType() {
        String wsdlBindingType = null;
        String soapTransport = null;
        Binding wsdlBinding = this.getWSDLBinding();
        if (wsdlBinding != null) {
            List elements = wsdlBinding.getExtensibilityElements();
            for (ExtensibilityElement e : elements) {
                if (SOAPBinding.class.isAssignableFrom(e.getClass())) {
                    SOAPBinding soapBnd = (SOAPBinding)e;
                    wsdlBindingType = soapBnd.getElementType().getNamespaceURI();
                    soapTransport = soapBnd.getTransportURI();
                    break;
                }
                if (SOAP12Binding.class.isAssignableFrom(e.getClass())) {
                    SOAP12Binding soapBnd = (SOAP12Binding)e;
                    wsdlBindingType = soapBnd.getElementType().getNamespaceURI();
                    soapTransport = soapBnd.getTransportURI();
                    break;
                }
                if (!HTTPBinding.class.isAssignableFrom(e.getClass())) continue;
                HTTPBinding httpBnd = (HTTPBinding)e;
                wsdlBindingType = httpBnd.getElementType().getNamespaceURI();
                break;
            }
            wsdlBindingType = DescriptionUtils.mapBindingTypeWsdlToAnnotation(wsdlBindingType, soapTransport);
        }
        return wsdlBindingType;
    }

    @Override
    public String getName() {
        return this.getAnnoWebServiceName();
    }

    @Override
    public String getTargetNamespace() {
        return this.getAnnoWebServiceTargetNamespace();
    }

    @Override
    public PortInfo getPortInfo() {
        if (this.portInfo == null) {
            this.portInfo = new PortInfoImpl(this.getServiceQName(), this.getPortQName(), this.getBindingType());
        }
        return this.portInfo;
    }

    @Override
    public void setClientBindingID(String clientBindingID) {
        if (clientBindingID == null) {
            this.clientBindingID = BindingType_DEFAULT;
        } else if (this.validateClientBindingID(clientBindingID)) {
            this.clientBindingID = clientBindingID;
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr0", this.getPortQName().toString()));
        }
    }

    private boolean validateClientBindingID(String bindingId) {
        boolean isValid = true;
        if (!(bindingId == null || bindingId.equals(BindingType_DEFAULT) || bindingId.equals("http://www.w3.org/2004/08/wsdl/http") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || bindingId.equals("http://www.w3.org/2010/soapjms/") || bindingId.equals("http://www.w3.org/2010/soapjms/") || bindingId.equals("http://www.w3.org/2010/soapjms/?mtom=true") || bindingId.equals("http://www.w3.org/2010/soapjms/?mtom=true"))) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr0", this.getPortQName().toString()));
        }
        return isValid;
    }

    @Override
    public String getClientBindingID() {
        if (this.clientBindingID == null) {
            if (this.getWSDLDefinition() != null) {
                this.clientBindingID = this.getWSDLBindingType();
                if (this.clientBindingID == null) {
                    this.clientBindingID = BindingType_DEFAULT;
                }
            } else {
                this.clientBindingID = BindingType_DEFAULT;
            }
        }
        return this.clientBindingID;
    }

    @Override
    public void setEndpointAddress(String endpointAddress) {
        if (!DescriptionUtils.isEmpty(endpointAddress)) {
            this.endpointAddress = endpointAddress;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"A null or empty endpoint address was attempted to be set", new Throwable("Stack Traceback"));
        }
    }

    @Override
    public String getEndpointAddress() {
        if (this.endpointAddress == null) {
            this.endpointAddress = this.getWSDLSOAPAddress();
        }
        return this.endpointAddress;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    @Override
    public String getWSDLSOAPAddress() {
        Port wsdlPort;
        if (this.wsdlSOAPAddress == null && (wsdlPort = this.getWSDLPort()) != null) {
            List extElementList = wsdlPort.getExtensibilityElements();
            for (Object listElement : extElementList) {
                String soapAddress;
                ExtensibilityElement extElement = (ExtensibilityElement)listElement;
                if (!EndpointDescriptionImpl.isSOAPAddressElement(extElement) || DescriptionUtils.isEmpty(soapAddress = EndpointDescriptionImpl.getSOAPAddressFromElement(extElement))) continue;
                this.wsdlSOAPAddress = soapAddress;
            }
        }
        return this.wsdlSOAPAddress;
    }

    static boolean isSOAPAddressElement(ExtensibilityElement exElement) {
        boolean isAddress = false;
        if (exElement != null) {
            isAddress = SOAP_11_ADDRESS_ELEMENT.equals(exElement.getElementType()) || SOAP_12_ADDRESS_ELEMENT.equals(exElement.getElementType());
        }
        return isAddress;
    }

    static String getSOAPAddressFromElement(ExtensibilityElement extElement) {
        String returnAddress = null;
        if (extElement != null) {
            if (SOAP_11_ADDRESS_ELEMENT.equals(extElement.getElementType())) {
                returnAddress = ((SOAPAddress)extElement).getLocationURI();
            } else if (SOAP_12_ADDRESS_ELEMENT.equals(extElement.getElementType())) {
                returnAddress = ((SOAP12Address)extElement).getLocationURI();
            }
        }
        return returnAddress;
    }

    private QName selectPortToUse() {
        QName portToUse = null;
        portToUse = this.getWSDLService() != null ? this.selectWSDLPortToUse() : this.getPortQName();
        return portToUse;
    }

    private QName selectWSDLPortToUse() {
        List<Port> wsdlPortsUsingPortType;
        QName wsdlPortToUse = null;
        String portTypeLP = this.getName();
        String portTypeTNS = this.getTargetNamespace();
        QName portTypeQN = new QName(portTypeTNS, portTypeLP);
        ServiceDescriptionWSDL serviceDescWSDL = (ServiceDescriptionWSDL)((Object)this.getServiceDescription());
        List<Port> wsdlPortsUsingSOAPAddresses = serviceDescWSDL.getWSDLPortsUsingSOAPAddress(wsdlPortsUsingPortType = serviceDescWSDL.getWSDLPortsUsingPortType(portTypeQN));
        if (wsdlPortsUsingSOAPAddresses != null && !wsdlPortsUsingSOAPAddresses.isEmpty()) {
            Port portToUse = (Port)wsdlPortsUsingSOAPAddresses.toArray()[0];
            String portLocalPart = portToUse.getName();
            String portNamespace = serviceDescWSDL.getWSDLService().getQName().getNamespaceURI();
            wsdlPortToUse = new QName(portNamespace, portLocalPart);
        }
        return wsdlPortToUse;
    }

    private WsdlComposite generateWSDL(DescriptionBuilderComposite dbc) {
        WsdlComposite wsdlComposite = null;
        Definition defn = dbc.getWsdlDefinition(this.getServiceQName());
        if (defn == null) {
            defn = dbc.getWsdlDefinition();
        }
        if (defn == null || !this.isAxisServiceBuiltFromWSDL) {
            if (dbc.getCustomWsdlGenerator() != null) {
                String implName = null;
                implName = this.axisService == null ? DescriptionUtils.javifyClassName(this.composite.getClassName()) : (String)this.axisService.getParameterValue("ServiceClass");
                wsdlComposite = dbc.getCustomWsdlGenerator().generateWsdl(implName, this);
                if (wsdlComposite != null) {
                    if (wsdlComposite.getWsdlFileName() == null || "".equals(wsdlComposite.getWsdlFileName())) {
                        wsdlComposite.setWsdlFileName((this.getAnnoWebServiceServiceName() + ".wsdl").toLowerCase());
                    }
                    Definition wsdlDef = wsdlComposite.getRootWsdlDefinition();
                    try {
                        ConfigurationContext cc = dbc.getConfigurationContext();
                        WSDL4JWrapper wsdl4jWrapper = null;
                        wsdl4jWrapper = cc != null ? new WSDL4JWrapper(dbc.getWsdlURL(), wsdlDef, cc) : new WSDL4JWrapper(dbc.getWsdlURL(), wsdlDef, true, 2);
                        this.getServiceDescriptionImpl().setGeneratedWsdlWrapper(wsdl4jWrapper);
                    }
                    catch (Exception e) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("generateWSDLErr"), e);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"The custom WSDL generator returned null, so no generated WSDL is available");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No custom WSDL generator was supplied, so WSDL can not be generated");
            }
        }
        return wsdlComposite;
    }

    List<CustomAnnotationInstance> getCustomAnnotationInstances() {
        return this.customAnnotations;
    }

    CustomAnnotationProcessor getCustomAnnotationProcessor(String annotationInstanceClassName) {
        return this.customAnnotationProcessors != null ? this.customAnnotationProcessors.get(annotationInstanceClassName) : null;
    }

    @Override
    public DescriptionBuilderComposite getDescriptionBuilderComposite() {
        return this.composite;
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Name: " + this.getName());
            string.append("; ");
            string.append("Endpoint Address: " + this.getEndpointAddress());
            string.append("\n");
            string.append("ServiceQName: " + this.getServiceQName());
            string.append("; ");
            string.append("PortQName: " + this.getPortQName());
            string.append("; ");
            string.append("TargetNamespace: " + this.getTargetNamespace());
            string.append("\n");
            string.append("Service Mode: " + (Object)((Object)this.getServiceMode()));
            string.append("; ");
            string.append("Binding Type: " + this.getBindingType());
            string.append("; ");
            string.append("Client Binding Type: " + this.getClientBindingID());
            string.append("\n");
            string.append("Is provider-based: " + this.isProviderBased());
            string.append("; ");
            string.append("Is proxy-based: " + this.isEndpointBased());
            string.append("; ");
            string.append("Is WSDL fully specified: " + this.isWSDLFullySpecified());
            string.append("\n");
            string.append("AxisService: " + this.getAxisService());
            string.append("\n");
            EndpointInterfaceDescription endpointInterfaceDesc = this.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc != null) {
                string.append("EndpointInterfaceDescription: " + endpointInterfaceDesc.toString());
            } else {
                string.append("EndpointInterfaceDescription is null.");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for EndpointDescription");
            return string.toString();
        }
        return string.toString();
    }

    private static Annotation getAnnotation(final Class cls, final Class annotation) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getAnnotation(annotation);
            }
        });
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    void updateWebServiceNameParameter(String newName, AxisService service) {
        Parameter param;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting @WebService.name value on the " + service.getName() + " AxisService to: " + newName));
        }
        if ((param = service.getParameter("WSDL_PORTTYPE_NAME")) != null) {
            param.setValue(newName);
        } else {
            param = new Parameter();
            param.setName("WSDL_PORTTYPE_NAME");
            param.setValue(newName);
            try {
                service.addParameter(param);
            }
            catch (AxisFault e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("setupAxisServiceErr2"), e);
            }
        }
    }

    private long uniqueID() {
        if (currentUniqueID == 0L) {
            currentUniqueID = System.currentTimeMillis();
        }
        return currentUniqueID++;
    }

    void releaseResources(ConfigurationContext configurationContext) {
        block3: {
            if (configurationContext != null) {
                AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
                AxisService axisService = this.getAxisService();
                AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                try {
                    axisConfig.removeServiceGroup(axisServiceGroup.getServiceGroupName());
                }
                catch (AxisFault e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"EndpointDescriptionImpl release resources caught exception which it is ignoring", (Throwable)e);
                }
            }
        }
    }
}

