/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.infoset.xpath.jaxen.expr;

import org.xmlpull.infoset.xpath.jaxen.ContextSupport;
import org.xmlpull.infoset.xpath.jaxen.Navigator;
import org.xmlpull.infoset.xpath.jaxen.expr.DefaultStep;
import org.xmlpull.infoset.xpath.jaxen.expr.iter.IterableAxis;

public class DefaultNameStep
extends DefaultStep {
    private String prefix;
    private String localName;
    private boolean matchesAnyName;

    public DefaultNameStep(IterableAxis axis, String prefix, String localName) {
        super(axis);
        this.prefix = prefix;
        this.localName = localName;
        this.matchesAnyName = "*".equals(localName);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    @Override
    public String getText() {
        if (this.getPrefix() != null && !this.getPrefix().equals("")) {
            return this.getAxisName() + "::" + this.getPrefix() + ":" + this.getLocalName() + super.getText();
        }
        return this.getAxisName() + "::" + this.getLocalName() + super.getText();
    }

    @Override
    public String toString() {
        return "[(DefaultNameStep): " + this.getPrefix() + ":" + this.getLocalName() + "[" + super.toString() + "]]";
    }

    @Override
    public boolean matches(Object node, ContextSupport contextSupport) {
        Navigator nav = contextSupport.getNavigator();
        String myPrefix = this.getPrefix();
        String myUri = null;
        boolean hasPrefix = myPrefix != null && !"".equals(myPrefix);
        String nodeUri = null;
        String nodeName = null;
        if (nav.isElement(node)) {
            nodeUri = nav.getElementNamespaceUri(node);
            nodeName = nav.getElementName(node);
        } else if (nav.isAttribute(node)) {
            nodeUri = nav.getAttributeNamespaceUri(node);
            nodeName = nav.getAttributeName(node);
        } else {
            if (nav.isDocument(node)) {
                return !hasPrefix && this.matchesAnyName;
            }
            if (nav.isNamespace(node)) {
                nodeUri = null;
                nodeName = nav.getNamespacePrefix(node);
            } else {
                return false;
            }
        }
        if (hasPrefix) {
            myUri = contextSupport.translateNamespacePrefixToUri(myPrefix);
        } else if (this.matchesAnyName) {
            return true;
        }
        if (myUri != null && !"".equals(myUri) && (nodeUri == null || "".equals(nodeUri))) {
            return false;
        }
        if (!hasPrefix && nodeUri != null && !"".equals(nodeUri)) {
            return false;
        }
        if (this.getLocalName().equals(nodeName) || this.matchesAnyName) {
            if (!hasPrefix) {
                return true;
            }
            return this.matchesNamespaceURIs(myUri, nodeUri);
        }
        return false;
    }

    protected boolean matchesNamespaceURIs(String u1, String u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null) {
            u1 = "";
        }
        if (u2 == null) {
            u2 = "";
        }
        return u1.equals(u2);
    }
}

