/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.ldap.LDAPRoleContext;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreManager;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreConstants;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ReadWriteLDAPUserStoreManager
extends ReadOnlyLDAPUserStoreManager {
    private static Log logger = LogFactory.getLog(ReadWriteLDAPUserStoreManager.class);
    public static final String PASSWORD_HASH_METHOD = "PasswordHashMethod";
    public static final String PASSWORD_HASH_METHOD_SHA = "SHA";
    public static final String PASSWORD_HASH_METHOD_MD5 = "MD5";
    public static final String ATTR_NAME_CN = "cn";
    public static final String ATTR_NAME_SN = "sn";
    protected static final String KRB5_PRINCIPAL_NAME_ATTRIBUTE = "krb5PrincipalName";
    protected static final String KRB5_KEY_VERSION_NUMBER_ATTRIBUTE = "krb5KeyVersionNumber";
    protected static boolean isFirstStartup = true;
    private static Log log = LogFactory.getLog(ReadWriteLDAPUserStoreManager.class);
    protected static final String EMPTY_ATTRIBUTE_STRING = "";
    protected Random random = new Random();
    protected boolean kdcEnabled = false;

    public ReadWriteLDAPUserStoreManager() {
    }

    public ReadWriteLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read-Write UserStoreManager initialization started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.userRealm = realm;
        this.tenantId = tenantId;
        this.kdcEnabled = UserCoreUtil.isKdcEnabled(realmConfig);
        this.checkRequiredUserStoreConfigurations();
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        isFirstStartup = (Boolean)properties.get("FistStartupCheck");
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, tenantId, realmConfig, this.userRealm);
        this.connectionSource = (LDAPConnectionContext)properties.get("ldapConnectionSource");
        if (this.connectionSource == null) {
            this.connectionSource = new LDAPConnectionContext(realmConfig);
        }
        try {
            this.connectionSource.getContext();
            log.info((Object)"LDAP connection created successfully in read-write mode");
        }
        catch (Exception e) {
            throw new UserStoreException("Cannot create connection to LDAP server. Error message " + e.getMessage());
        }
        this.userRealm = realm;
        this.persistDomain();
        this.doInitialSetup();
        if (realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        this.initUserRolesCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read-Write UserStoreManager initialization ended " + System.currentTimeMillis()));
        }
    }

    public ReadWriteLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected String getRealmName() {
        String defaultRealmName = this.realmConfig.getUserStoreProperty("defaultRealmName");
        if (defaultRealmName != null) {
            return defaultRealmName;
        }
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String[] domainComponents = searchBase.split("dc=");
        StringBuilder builder = new StringBuilder();
        for (String dc : domainComponents) {
            if (dc.contains("=")) continue;
            String trimmedDc = dc.trim();
            if (trimmedDc.endsWith(",")) {
                builder.append(trimmedDc.replace(',', '.'));
                continue;
            }
            builder.append(trimmedDc);
        }
        return builder.toString().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.doAddUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.doAddUserValidityChecks(userName, credential);
        DirContext dirContext = this.getSearchBaseDirectoryContext();
        BasicAttributes basicAttributes = this.getAddUserBasicAttributes(userName);
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        userPassword.add(UserCoreUtil.getPasswordToStore((String)credential, this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD), this.kdcEnabled));
        basicAttributes.put(userPassword);
        this.setUserClaims(claims, basicAttributes, userName);
        try {
            NameParser ldapParser = dirContext.getNameParser(EMPTY_ATTRIBUTE_STRING);
            Name compoundName = ldapParser.parse(this.realmConfig.getUserStoreProperty("UserNameAttribute") + "=" + userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Binding user: " + compoundName));
            }
            dirContext.bind(compoundName, null, (Attributes)basicAttributes);
        }
        catch (NamingException e) {
            String errorMessage = "Can not access the directory context or user already exists in the system";
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(errorMessage);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
        try {
            this.doUpdateRoleListOfUser(userName, null, roleList);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Roles are added for user  : " + userName + " successfully."));
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "User is added. But error while updating role list of user";
            log.debug((Object)e.getMessage(), (Throwable)((Object)e));
            throw new UserStoreException(errorMessage);
        }
    }

    protected void doAddUserValidityChecks(String userName, Object credential) throws UserStoreException {
        if (!this.checkUserNameValid(userName)) {
            throw new UserStoreException("User name not valid. User name must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("UsernameJavaRegEx"));
        }
        if (!this.checkUserPasswordValid(credential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
        if (this.isExistingUser(userName)) {
            throw new UserStoreException("User " + userName + " already exist in the LDAP");
        }
    }

    protected DirContext getSearchBaseDirectoryContext() throws UserStoreException {
        DirContext mainDirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        try {
            DirContext dirContext = (DirContext)mainDirContext.lookup(searchBase);
            return dirContext;
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            String errorMessage = "Can not access the directory context oruser already exists in the system";
            throw new UserStoreException(errorMessage);
        }
        finally {
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    protected BasicAttributes getAddUserBasicAttributes(String userName) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        String userObjectClass = this.realmConfig.getUserStoreProperty("UserEntryObjectClass");
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add(userObjectClass);
        if (this.kdcEnabled) {
            objectClass.add("krb5principal");
            objectClass.add("krb5kdcentry");
            objectClass.add("subschema");
        }
        basicAttributes.put(objectClass);
        BasicAttribute userNameAttribute = new BasicAttribute(this.realmConfig.getUserStoreProperty("UserNameAttribute"));
        userNameAttribute.add(userName);
        basicAttributes.put(userNameAttribute);
        if (this.kdcEnabled) {
            String tenantDomainName;
            CarbonContext cc = CarbonContext.getCurrentContext();
            if (cc != null && !"carbon.super".equals(tenantDomainName = cc.getTenantDomain())) {
                userName = userName + '/' + tenantDomainName;
            }
            String principal = userName + "@" + this.getRealmName();
            BasicAttribute principalAttribute = new BasicAttribute(KRB5_PRINCIPAL_NAME_ATTRIBUTE);
            principalAttribute.add(principal);
            basicAttributes.put(principalAttribute);
            BasicAttribute versionNumberAttribute = new BasicAttribute(KRB5_KEY_VERSION_NUMBER_ATTRIBUTE);
            versionNumberAttribute.add("0");
            basicAttributes.put(versionNumberAttribute);
        }
        return basicAttributes;
    }

    protected void setUserClaims(Map<String, String> claims, BasicAttributes basicAttributes, String userName) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        log.debug((Object)"Processing user claims");
        boolean isSNExists = false;
        boolean isCNExists = false;
        if (claims != null) {
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                if (EMPTY_ATTRIBUTE_STRING.equals(entry.getValue())) continue;
                String claimURI = entry.getKey();
                if (debug) {
                    log.debug((Object)("Claim URI: " + claimURI));
                }
                String attributeName = null;
                try {
                    attributeName = this.getClaimAtrribute(claimURI, userName, null);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e);
                }
                if (ATTR_NAME_CN.equals(attributeName)) {
                    isCNExists = true;
                } else if (ATTR_NAME_SN.equals(attributeName)) {
                    isSNExists = true;
                }
                if (debug) {
                    log.debug((Object)("Mapped attribute: " + attributeName));
                    log.debug((Object)("Attribute value: " + claims.get(entry.getKey())));
                }
                BasicAttribute claim = new BasicAttribute(attributeName);
                claim.add(claims.get(entry.getKey()));
                basicAttributes.put(claim);
            }
        }
        if (!isCNExists) {
            BasicAttribute cn = new BasicAttribute(ATTR_NAME_CN);
            cn.add(userName);
            basicAttributes.put(cn);
        }
        if (!isSNExists) {
            BasicAttribute sn = new BasicAttribute(ATTR_NAME_SN);
            sn.add(userName);
            basicAttributes.put(sn);
        }
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        log.debug((Object)("Deleting user: " + userName));
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", userName);
        String[] returningUserAttributes = new String[]{userNameAttribute};
        DirContext mainDirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> userResults = this.searchInUserBase(searchFilter, returningUserAttributes, 2, mainDirContext);
        NamingEnumeration<SearchResult> groupResults = null;
        DirContext subDirContext = null;
        try {
            String[] rolesOfUser;
            String[] sharedRoles;
            SearchResult userResult = null;
            String userDN = null;
            while (userResults.hasMore()) {
                userResult = userResults.next();
                userDN = userResult.getName();
                log.debug((Object)("User DN: " + userDN));
            }
            ArrayList<String> roles = new ArrayList<String>();
            String[] externalRoles = this.doGetExternalRoleListOfUser(userName, "*");
            roles.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRoleListOfUser(null, userName, "*")) != null) {
                roles.addAll(Arrays.asList(sharedRoles));
            }
            if ((rolesOfUser = roles.toArray(new String[roles.size()])).length != 0) {
                String[] returningGroupAttributes = new String[]{this.realmConfig.getUserStoreProperty("MembershipAttribute")};
                for (String role : rolesOfUser) {
                    RoleContext context = this.createRoleContext(role);
                    String searchBase = ((LDAPRoleContext)context).getSearchBase();
                    searchFilter = ((LDAPRoleContext)context).getSearchFilter();
                    role = context.getRoleName();
                    if (role.indexOf("/") > -1) {
                        role = role.split("/")[1];
                    }
                    String grpSearchFilter = searchFilter.replace("?", role);
                    groupResults = this.searchInGroupBase(grpSearchFilter, returningGroupAttributes, 2, mainDirContext, searchBase);
                    SearchResult groupResult = null;
                    while (groupResults.hasMore()) {
                        groupResult = groupResults.next();
                    }
                    if (!this.isOnlyUserInRole(userDN, groupResult) || this.emptyRolesAllowed) continue;
                    String errorMessage = "User: " + userName + " is the only user " + "in " + role + "." + "There should be at " + "least one user" + " in the role. Hence can" + " not delete the user.";
                    throw new UserStoreException(errorMessage);
                }
                this.doUpdateRoleListOfUser(userName, rolesOfUser, new String[0]);
            }
            if (userResult != null && userResult.getAttributes().get(userNameAttribute).get().toString().toLowerCase().equals(userName.toLowerCase())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + userDN + " with search base " + this.userSearchBase));
                }
                subDirContext = (DirContext)mainDirContext.lookup(this.userSearchBase);
                subDirContext.destroySubcontext(userDN);
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while deleting the user. ";
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(groupResults);
            JNDIUtil.closeNamingEnumeration(userResults);
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialsValidityChecks(userName, newCredential);
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"userPassword"});
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<?> passwords = null;
        try {
            namingEnumeration = dirContext.search(searchBase, searchFilter, searchControls);
            NameClassPair searchResult = null;
            String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
            while (namingEnumeration.hasMore()) {
                searchResult = namingEnumeration.next();
                String dnName = searchResult.getName();
                subDirContext = (DirContext)dirContext.lookup(searchBase);
                BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
                passwordAttribute.add(UserCoreUtil.getPasswordToStore((String)newCredential, passwordHashMethod, this.kdcEnabled));
                BasicAttributes basicAttributes = new BasicAttributes(true);
                basicAttributes.put(passwordAttribute);
                subDirContext.modifyAttributes(dnName, 2, (Attributes)basicAttributes);
            }
            if (searchResult.getNameInNamespace().equals(this.realmConfig.getUserStoreProperty("ConnectionName"))) {
                this.connectionSource.updateCredential((String)newCredential);
            }
        }
        catch (NamingException e) {
            try {
                throw new UserStoreException("Can not access the directory service", e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(passwords);
                JNDIUtil.closeNamingEnumeration(namingEnumeration);
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(passwords);
        JNDIUtil.closeNamingEnumeration(namingEnumeration);
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        this.doUpdateCredentialsValidityChecks(userName, newCredential);
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"userPassword"});
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<?> passwords = null;
        try {
            namingEnumeration = dirContext.search(searchBase, searchFilter, searchControls);
            NameClassPair searchResult = null;
            while (namingEnumeration.hasMore()) {
                byte[] byteArray;
                String password;
                Attributes attributes;
                Attribute userPassword;
                searchResult = namingEnumeration.next();
                String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
                if (!"PLAIN_TEXT".equalsIgnoreCase(passwordHashMethod) && (passwords = (userPassword = (attributes = ((SearchResult)searchResult).getAttributes()).get("userPassword")).getAll()).hasMore() && (password = new String(byteArray = (byte[])passwords.next())).startsWith("{")) {
                    passwordHashMethod = password.substring(password.indexOf(123) + 1, password.indexOf(125));
                }
                String dnName = searchResult.getName();
                subDirContext = (DirContext)dirContext.lookup(searchBase);
                BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
                passwordAttribute.add(UserCoreUtil.getPasswordToStore((String)newCredential, passwordHashMethod, this.kdcEnabled));
                BasicAttributes basicAttributes = new BasicAttributes(true);
                basicAttributes.put(passwordAttribute);
                subDirContext.modifyAttributes(dnName, 2, (Attributes)basicAttributes);
            }
            if (searchResult.getNameInNamespace().equals(this.realmConfig.getUserStoreProperty("ConnectionName"))) {
                this.connectionSource.updateCredential((String)newCredential);
            }
        }
        catch (NamingException e) {
            throw new UserStoreException("Can not access the directory service", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(passwords);
            JNDIUtil.closeNamingEnumeration(namingEnumeration);
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
        }
    }

    protected void doUpdateCredentialsValidityChecks(String userName, Object newCredential) throws UserStoreException {
        if (!this.isExistingUser(userName)) {
            throw new UserStoreException("User " + userName + " does not exisit in the user store");
        }
        if (!this.checkUserPasswordValid(newCredential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
    }

    @Override
    public Map<String, String> getProperties(Tenant tenant) throws UserStoreException {
        Map existingProperties = this.realmConfig.getUserStoreProperties();
        String tenantSufix = this.getTenantSuffix(tenant.getDomain());
        String propertyName = null;
        HashMap<String, String> newProperties = new HashMap<String, String>();
        for (Map.Entry iter : existingProperties.entrySet()) {
            propertyName = (String)iter.getKey();
            if (propertyName.equals("UserSearchBase")) {
                newProperties.put(propertyName, tenantSufix);
                continue;
            }
            newProperties.put(propertyName, (String)iter.getValue());
        }
        return newProperties;
    }

    private String getTenantSuffix(String domain) {
        String[] domainParts = domain.split("\\.");
        StringBuffer suffixName = new StringBuffer();
        for (String domainPart : domainParts) {
            suffixName.append(",dc=").append(domainPart);
        }
        return suffixName.toString().replaceFirst(",", EMPTY_ATTRIBUTE_STRING);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        String[] userNames = userName.split("/");
        if (userNames.length > 1) {
            userName = userNames[1];
        }
        userSearchFilter = userSearchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> returnedResultList = null;
        String returnedUserEntry = null;
        try {
            returnedResultList = dirContext.search(userSearchBase, userSearchFilter, searchControls);
            returnedUserEntry = returnedResultList.next().getName();
        }
        catch (NamingException e) {
            throw new UserStoreException("Results could not be retrieved from the directory context", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(returnedResultList);
        }
        if (profileName == null) {
            profileName = "default";
        }
        if (claims.get("profileConfiguration") == null) {
            claims.put("profileConfiguration", "default");
        }
        try {
            BasicAttributes updatedAttributes = new BasicAttributes(true);
            for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
                String uidName;
                String[] uidNames;
                String claimURI = claimEntry.getKey();
                if (claimURI.equals("profileConfiguration")) continue;
                String attributeName = this.getClaimAtrribute(claimURI, userName, null);
                if (attributeName.equals("uid") && (uidNames = (uidName = claimEntry.getValue()).split("/")).length > 1) {
                    uidName = uidNames[1];
                    claimEntry.setValue(uidName);
                }
                BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                if (EMPTY_ATTRIBUTE_STRING.equals(claimEntry.getValue())) {
                    currentUpdatedAttribute.clear();
                } else if (claimEntry.getValue() != null && claimEntry.getValue().contains(",")) {
                    String[] values;
                    for (String newValue : values = claimEntry.getValue().split(",")) {
                        if (newValue == null || newValue.trim().length() <= 0) continue;
                        currentUpdatedAttribute.add(newValue.trim());
                    }
                } else {
                    currentUpdatedAttribute.add(claimEntry.getValue());
                }
                updatedAttributes.put(currentUpdatedAttribute);
            }
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
        }
        catch (InvalidAttributeValueException e) {
            try {
                String errorMessage = "One or more attribute values provided are incompatible. Please check and try again.";
                throw new UserStoreException(errorMessage, e);
                catch (InvalidAttributeIdentifierException e2) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e2);
                }
                catch (NoSuchAttributeException e3) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e3);
                }
                catch (NamingException e4) {
                    errorMessage = "Profile information could not be updated in ApacheDS LDAP user store";
                    throw new UserStoreException(errorMessage, e4);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e5) {
                    errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e5);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String value, String profileName) throws UserStoreException {
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        String[] userNames = userName.split("/");
        if (userNames.length > 1) {
            userName = userNames[1];
        }
        userSearchFilter = userSearchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> returnedResultList = null;
        String returnedUserEntry = null;
        try {
            returnedResultList = dirContext.search(userSearchBase, userSearchFilter, searchControls);
            returnedUserEntry = returnedResultList.next().getName();
        }
        catch (NamingException e) {
            throw new UserStoreException("Results could not be retrieved from the directory context", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(returnedResultList);
        }
        try {
            BasicAttributes updatedAttributes = new BasicAttributes(true);
            String attributeName = null;
            attributeName = this.getClaimAtrribute(claimURI, userName, null);
            BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
            if (EMPTY_ATTRIBUTE_STRING.equals(value)) {
                currentUpdatedAttribute.clear();
            } else if (value.contains(",")) {
                String[] values;
                for (String newValue : values = value.split(",")) {
                    if (newValue == null || newValue.trim().length() <= 0) continue;
                    currentUpdatedAttribute.add(newValue.trim());
                }
            } else {
                currentUpdatedAttribute.add(value);
            }
            updatedAttributes.put(currentUpdatedAttribute);
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
        }
        catch (InvalidAttributeValueException e) {
            try {
                String errorMessage = "One or more attribute values provided are incompatible. Please check and try again.";
                throw new UserStoreException(errorMessage, e);
                catch (InvalidAttributeIdentifierException e2) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e2);
                }
                catch (NoSuchAttributeException e3) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e3);
                }
                catch (NamingException e4) {
                    errorMessage = "Profile information could not be updated in ApacheDS LDAP user store";
                    throw new UserStoreException(errorMessage, e4);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e5) {
                    errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e5);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        roleContext.setMembers(userList);
        this.addLDAPRole(roleContext);
        if (shared && this.isSharedGroupEnabled()) {
            String tenantDomain = CarbonContext.getCurrentContext().getTenantDomain();
            roleName = roleName + "@" + tenantDomain;
            roleContext = this.createRoleContext(roleName);
            this.addLDAPRole(roleContext);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addLDAPRole(RoleContext context) throws UserStoreException {
        String roleName = context.getRoleName();
        String[] userList = context.getMembers();
        String groupEntryObjectClass = ((LDAPRoleContext)context).getGroupEntryObjectClass();
        String groupNameAttribute = ((LDAPRoleContext)context).getRoleNameProperty();
        String searchBase = ((LDAPRoleContext)context).getSearchBase();
        if (!(userList != null && userList.length != 0 || this.emptyRolesAllowed)) {
            String errorMessage = "Can not create empty role. There should be at least one user for the role.";
            throw new UserStoreException(errorMessage);
        }
        if (!(userList == null && this.emptyRolesAllowed || userList != null && userList.length > 0 && !this.emptyRolesAllowed)) {
            if (!this.emptyRolesAllowed) return;
        }
        DirContext mainDirContext = this.connectionSource.getContext();
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            BasicAttributes groupAttributes = new BasicAttributes(true);
            BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
            objectClassAttribute.add(groupEntryObjectClass);
            groupAttributes.put(objectClassAttribute);
            BasicAttribute cnAttribute = new BasicAttribute(groupNameAttribute);
            cnAttribute.add(roleName);
            groupAttributes.put(cnAttribute);
            if (userList != null && userList.length > 0) {
                String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                BasicAttribute memberAttribute = new BasicAttribute(memberAttributeName);
                for (String userName : userList) {
                    if (userName == null || userName.trim().length() == 0) continue;
                    String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
                    searchFilter = searchFilter.replace("?", userName);
                    results = this.searchInUserBase(searchFilter, new String[0], 2, mainDirContext);
                    SearchResult userResult = null;
                    if (!results.hasMore()) {
                        String errorMsg = "There is no user with the user name: " + userName + " to be added to this role.";
                        logger.error((Object)errorMsg);
                        throw new UserStoreException(errorMsg);
                    }
                    userResult = results.next();
                    String userEntryDN = userResult.getNameInNamespace();
                    memberAttribute.add(userEntryDN);
                }
                groupAttributes.put(memberAttribute);
            }
            groupContext = (DirContext)mainDirContext.lookup(searchBase);
            NameParser ldapParser = groupContext.getNameParser(EMPTY_ATTRIBUTE_STRING);
            Name compoundGroupName = ldapParser.parse("cn=" + roleName);
            groupContext.bind(compoundGroupName, null, (Attributes)groupAttributes);
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Role: " + roleName + " could not be added.";
                throw new UserStoreException(errorMsg, e);
                catch (Exception e2) {
                    errorMsg = "Role: " + roleName + " could not be added.";
                    throw new UserStoreException(errorMsg, e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(results);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(results);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        String userNameDN = this.getNameInSpaceForUserName(userName);
        String membershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
        String errorMessage = null;
        String roleSearchFilter = null;
        DirContext mainDirContext = this.connectionSource.getContext();
        try {
            String groupDN;
            SearchResult resultedGroup;
            NamingEnumeration<SearchResult> groupResults;
            String searchBase;
            String[] returningAttributes;
            String searchFilter;
            LDAPRoleContext context;
            if (deletedRoles != null && deletedRoles.length != 0) {
                for (String deletedRole : deletedRoles) {
                    context = (LDAPRoleContext)this.createRoleContext(deletedRole);
                    deletedRole = context.getRoleName();
                    searchFilter = context.getSearchFilter();
                    roleSearchFilter = searchFilter.replace("?", deletedRole);
                    returningAttributes = new String[]{membershipAttribute};
                    searchBase = context.getSearchBase();
                    groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
                    resultedGroup = null;
                    if (groupResults.hasMore()) {
                        resultedGroup = groupResults.next();
                    }
                    if (resultedGroup != null && this.isOnlyUserInRole(userNameDN, resultedGroup) && !this.emptyRolesAllowed) {
                        errorMessage = userName + " is the only user in the role: " + deletedRole + ". Hence can not delete user from role.";
                        throw new UserStoreException(errorMessage);
                    }
                    JNDIUtil.closeNamingEnumeration(groupResults);
                }
                for (String deletedRole : deletedRoles) {
                    context = (LDAPRoleContext)this.createRoleContext(deletedRole);
                    deletedRole = context.getRoleName();
                    searchFilter = context.getSearchFilter();
                    if (this.isExistingRole(deletedRole)) {
                        roleSearchFilter = searchFilter.replace("?", deletedRole);
                        returningAttributes = new String[]{membershipAttribute};
                        searchBase = context.getSearchBase();
                        groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
                        resultedGroup = null;
                        groupDN = null;
                        if (groupResults.hasMore()) {
                            resultedGroup = groupResults.next();
                            groupDN = resultedGroup.getName();
                        }
                    } else {
                        errorMessage = "The role: " + deletedRole + " does not exist.";
                        throw new UserStoreException(errorMessage);
                    }
                    this.modifyUserInRole(userNameDN, groupDN, 3, searchBase);
                    JNDIUtil.closeNamingEnumeration(groupResults);
                    this.userRealm.getAuthorizationManager().clearUserAuthorization(userName);
                }
            }
            if (newRoles != null && newRoles.length != 0) {
                for (String newRole : newRoles) {
                    context = (LDAPRoleContext)this.createRoleContext(newRole);
                    newRole = context.getRoleName();
                    searchFilter = context.getSearchFilter();
                    if (this.isExistingRole(newRole)) {
                        roleSearchFilter = searchFilter.replace("?", newRole);
                        returningAttributes = new String[]{membershipAttribute};
                        searchBase = context.getSearchBase();
                        groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
                        resultedGroup = null;
                        groupDN = null;
                        if (groupResults.hasMore()) {
                            resultedGroup = groupResults.next();
                            groupDN = resultedGroup.getName();
                        }
                        if (resultedGroup == null || this.isUserInRole(userNameDN, resultedGroup)) {
                            errorMessage = "User: " + userName + " already belongs to role: " + groupDN;
                            throw new UserStoreException(errorMessage);
                        }
                        this.modifyUserInRole(userNameDN, groupDN, 1, searchBase);
                    } else {
                        errorMessage = "The role: " + newRole + " does not exist.";
                        throw new UserStoreException(errorMessage);
                    }
                    JNDIUtil.closeNamingEnumeration(groupResults);
                }
            }
        }
        catch (NamingException e) {
            errorMessage = "Error occurred while modifying the role list of user: " + userName;
            throw new UserStoreException(errorMessage);
        }
        finally {
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        String errorMessage = null;
        NamingEnumeration<SearchResult> groupSearchResults = null;
        LDAPRoleContext ctx = (LDAPRoleContext)this.createRoleContext(roleName);
        roleName = ctx.getRoleName();
        String searchFilter = ctx.getSearchFilter();
        if (this.isExistingLDAPRole(ctx)) {
            DirContext mainDirContext = this.connectionSource.getContext();
            try {
                String userNameDN;
                searchFilter = searchFilter.replace("?", roleName);
                String membershipAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                String[] returningAttributes = new String[]{membershipAttributeName};
                String searchBase = ctx.getRoleNameProperty() + "=" + roleName + "," + ctx.getSearchBase();
                groupSearchResults = this.searchInGroupBase(searchFilter, returningAttributes, 2, mainDirContext, searchBase);
                SearchResult resultedGroup = null;
                String groupName = null;
                while (groupSearchResults.hasMoreElements()) {
                    resultedGroup = groupSearchResults.next();
                    groupName = resultedGroup.getName();
                }
                Attribute returnedMemberAttribute = resultedGroup.getAttributes().get(membershipAttributeName);
                if (!this.emptyRolesAllowed && newUsers.length - deletedUsers.length + returnedMemberAttribute.size() == 0) {
                    errorMessage = "There should be at least one member in the role. Hence can not delete all the members.";
                    throw new UserStoreException(errorMessage);
                }
                if (newUsers.length != 0) {
                    for (String newUser : newUsers) {
                        userNameDN = this.getNameInSpaceForUserName(newUser);
                        if (this.isUserInRole(userNameDN, resultedGroup)) {
                            errorMessage = "User: " + newUser + " already belongs to role: " + roleName;
                            throw new UserStoreException(errorMessage);
                        }
                        this.modifyUserInRole(userNameDN, groupName, 1, searchBase);
                    }
                }
                if (deletedUsers == null || deletedUsers.length == 0) return;
                for (String deletedUser : deletedUsers) {
                    if (deletedUser == null || deletedUser.trim().length() == 0) continue;
                    userNameDN = this.getNameInSpaceForUserName(deletedUser);
                    this.modifyUserInRole(userNameDN, groupName, 3, searchBase);
                    this.userRealm.getAuthorizationManager().clearUserAuthorization(deletedUser);
                }
                return;
            }
            catch (NamingException e) {
                errorMessage = "Error occurred while modifying the user list of role: " + roleName;
                throw new UserStoreException(errorMessage);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(mainDirContext);
            }
        } else {
            errorMessage = "The role: " + roleName + " does not exist.";
            throw new UserStoreException(errorMessage);
        }
    }

    protected void modifyUserInRole(String userNameDN, String groupRDN, int modifyType, String searchBase) throws UserStoreException {
        if (log.isDebugEnabled()) {
            logger.debug((Object)("Modifying role: " + groupRDN + " with type: " + modifyType + " user: " + userNameDN + " in search base: " + searchBase));
        }
        DirContext mainDirContext = null;
        DirContext groupContext = null;
        try {
            mainDirContext = this.connectionSource.getContext();
            groupContext = (DirContext)mainDirContext.lookup(searchBase);
            String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            BasicAttributes modifyingAttributes = new BasicAttributes(true);
            BasicAttribute memberAttribute = new BasicAttribute(memberAttributeName);
            memberAttribute.add(userNameDN);
            modifyingAttributes.put(memberAttribute);
            groupContext.modifyAttributes(groupRDN, modifyType, (Attributes)modifyingAttributes);
            if (log.isDebugEnabled()) {
                logger.debug((Object)("User: " + userNameDN + " was successfully " + "modified in LDAP group: " + groupRDN));
            }
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while modifying user entry: " + userNameDN + " in LDAP role: " + groupRDN;
                log.error((Object)"LDAP Error", (Throwable)e);
                throw new UserStoreException(errorMessage);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    protected boolean isUserInRole(String userDN, SearchResult groupEntry) throws UserStoreException {
        boolean isUserInRole = false;
        try {
            Attributes groupAttributes = groupEntry.getAttributes();
            if (groupAttributes != null) {
                NamingEnumeration<? extends Attribute> attributes = groupAttributes.getAll();
                while (attributes.hasMoreElements()) {
                    Attribute memberAttribute = attributes.next();
                    String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                    if (!memberAttributeName.equalsIgnoreCase(memberAttribute.getID())) continue;
                    for (int i = 0; i < memberAttribute.size(); ++i) {
                        if (!userDN.equalsIgnoreCase((String)memberAttribute.get(i))) continue;
                        return true;
                    }
                }
                attributes.close();
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while looping through attributes set of group: " + groupEntry.getNameInNamespace();
            throw new UserStoreException(errorMessage, e);
        }
        return isUserInRole;
    }

    protected boolean isOnlyUserInRole(String userDN, SearchResult groupEntry) throws UserStoreException {
        boolean isOnlyUserInRole = false;
        try {
            Attributes groupAttributes = groupEntry.getAttributes();
            if (groupAttributes != null) {
                NamingEnumeration<? extends Attribute> attributes = groupAttributes.getAll();
                while (attributes.hasMoreElements()) {
                    String attributeID;
                    Attribute memberAttribute = attributes.next();
                    String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                    if (!memberAttributeName.equals(attributeID = memberAttribute.getID()) || memberAttribute.size() != 1 || !userDN.equals(memberAttribute.get())) continue;
                    return true;
                }
                attributes.close();
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while looping through attributes set of group: " + groupEntry.getNameInNamespace();
            throw new UserStoreException(errorMessage, e);
        }
        return isOnlyUserInRole;
    }

    protected void updateLDAPRoleName(RoleContext context, String newRoleName) throws UserStoreException {
        String roleName = context.getRoleName();
        String groupSearchFilter = ((LDAPRoleContext)context).getSearchFilter();
        String roleNameAttributeName = ((LDAPRoleContext)context).getRoleNameProperty();
        String searchBase = ((LDAPRoleContext)context).getSearchBase();
        DirContext mainContext = this.connectionSource.getContext();
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            groupSearchFilter = groupSearchFilter.replace("?", roleName);
            String[] returningAttributes = new String[]{roleNameAttributeName};
            groupSearchResults = this.searchInGroupBase(groupSearchFilter, returningAttributes, 2, mainContext, searchBase);
            SearchResult resultedGroup = null;
            while (groupSearchResults.hasMoreElements()) {
                resultedGroup = groupSearchResults.next();
            }
            if (resultedGroup == null) {
                throw new UserStoreException("Could not find user role " + roleName + " in LDAP server.");
            }
            String groupNameRDN = resultedGroup.getName();
            String newGroupNameRDN = roleNameAttributeName + "=" + newRoleName;
            groupContext = (DirContext)mainContext.lookup(this.groupSearchBase);
            groupContext.rename(groupNameRDN, newGroupNameRDN);
            String roleNameWithDomain = UserCoreUtil.addDomainToName(roleName, this.getMyDomainName());
            String newRoleNameWithDomain = UserCoreUtil.addDomainToName(newRoleName, this.getMyDomainName());
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleNameWithDomain, newRoleNameWithDomain);
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while modifying the name of role: " + roleName;
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(groupSearchResults);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainContext);
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        this.updateLDAPRoleName(roleContext, newRoleName);
        if (roleContext.isShared()) {
            roleName = roleName + "@" + CarbonContext.getCurrentContext().getTenantDomain();
            roleContext = this.createRoleContext(roleName);
            this.updateLDAPRoleName(roleContext, newRoleName);
        }
    }

    protected void deleteLDAPRole(RoleContext context) throws UserStoreException {
        String roleName = context.getRoleName();
        String groupSearchFilter = ((LDAPRoleContext)context).getSearchFilter();
        groupSearchFilter = groupSearchFilter.replace("?", context.getRoleName());
        String[] returningAttributes = new String[]{((LDAPRoleContext)context).getRoleNameProperty()};
        String searchBase = ((LDAPRoleContext)context).getSearchBase();
        DirContext mainDirContext = null;
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            mainDirContext = this.connectionSource.getContext();
            groupSearchResults = this.searchInGroupBase(groupSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
            SearchResult resultedGroup = null;
            while (groupSearchResults.hasMoreElements()) {
                resultedGroup = groupSearchResults.next();
            }
            if (resultedGroup == null) {
                throw new UserStoreException("Could not find specified group/role - " + roleName);
            }
            String groupName = resultedGroup.getName();
            groupContext = (DirContext)mainDirContext.lookup(this.groupSearchBase);
            String groupNameAttributeValue = (String)resultedGroup.getAttributes().get(this.realmConfig.getUserStoreProperty("GroupNameAttribute")).get();
            if (groupNameAttributeValue.equals(roleName)) {
                groupContext.destroySubcontext(groupName);
            }
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while deleting the role: " + roleName;
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(groupSearchResults);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        this.deleteLDAPRole(roleContext);
        if (roleContext.isShared()) {
            roleName = roleName + "@" + CarbonContext.getCurrentContext().getTenantDomain();
            roleContext = this.createRoleContext(roleName);
            this.deleteLDAPRole(roleContext);
        }
    }

    private NamingEnumeration<SearchResult> searchInUserBase(String searchFilter, String[] returningAttributes, int searchScope, DirContext rootContext) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching user with " + searchFilter));
        }
        String userBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setReturningAttributes(returningAttributes);
        userSearchControl.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> userSearchResults = null;
        try {
            userSearchResults = rootContext.search(userBase, searchFilter, userSearchControl);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in user base.";
            throw new UserStoreException(errorMessage, e);
        }
        return userSearchResults;
    }

    protected NamingEnumeration<SearchResult> searchInGroupBase(String searchFilter, String[] returningAttributes, int searchScope, DirContext rootContext, String searchBase) throws UserStoreException {
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setReturningAttributes(returningAttributes);
        userSearchControl.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            groupSearchResults = rootContext.search(searchBase, searchFilter, userSearchControl);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in group base.";
            throw new UserStoreException(errorMessage, e);
        }
        return groupSearchResults;
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        super.checkRequiredUserStoreConfigurations();
        String userObjectClass = this.realmConfig.getUserStoreProperty("UserEntryObjectClass");
        if (userObjectClass == null || userObjectClass.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required UserEntryObjectClass property is not set at the LDAP configurations");
        }
        if (this.realmConfig.getUserStoreProperty("WriteGroups") != null) {
            this.writeGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("WriteGroups"));
            log.debug((Object)("Write LDAP groups enabled: " + this.writeGroupsEnabled));
        }
        if (!this.writeGroupsEnabled) {
            if (this.realmConfig.getUserStoreProperty("ReadGroups") != null) {
                this.readGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("ReadGroups"));
                log.debug((Object)("Read LDAP groups enabled: " + this.readGroupsEnabled));
            }
        } else {
            this.readGroupsEnabled = true;
            log.debug((Object)"Read LDAP groups enabled: true");
        }
        this.emptyRolesAllowed = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("EmptyRolesAllowed"));
        String groupEntryObjectClass = this.realmConfig.getUserStoreProperty("GroupEntryObjectClass");
        if (groupEntryObjectClass == null || groupEntryObjectClass.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required GroupEntryObjectClass property is not set at the LDAP configurations");
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
    }

    @Override
    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(ReadWriteLDAPUserStoreConstants.RWLDAP_USERSTORE_PROPERTIES.toArray(new Property[ReadWriteLDAPUserStoreConstants.RWLDAP_USERSTORE_PROPERTIES.size()]));
        properties.setOptionalProperties(ReadWriteLDAPUserStoreConstants.OPTINAL_RWLDAP_USERSTORE_PROPERTIES.toArray(new Property[ReadWriteLDAPUserStoreConstants.OPTINAL_RWLDAP_USERSTORE_PROPERTIES.size()]));
        return properties;
    }
}

