/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.messaging;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.dbevent.DBEventMessageContext;
import org.apache.airavata.model.error.DuplicateEntryException;
import org.apache.airavata.model.user.UserProfile;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.sharing.registry.client.SharingRegistryServiceClientFactory;
import org.apache.airavata.sharing.registry.messaging.SharingServiceDBEventMessagingFactory;
import org.apache.airavata.sharing.registry.models.Domain;
import org.apache.airavata.sharing.registry.models.EntityType;
import org.apache.airavata.sharing.registry.models.PermissionType;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.User;
import org.apache.airavata.sharing.registry.service.cpi.SharingRegistryService;
import org.apache.airavata.sharing.registry.utils.ThriftDataModelConversion;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingServiceDBEventHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(SharingServiceDBEventHandler.class);
    private final SharingRegistryService.Client sharingRegistryClient;

    SharingServiceDBEventHandler() throws ApplicationSettingsException, SharingRegistryException {
        log.info("Starting sharing registry client.....");
        this.sharingRegistryClient = SharingRegistryServiceClientFactory.createSharingRegistryClient((String)ServerSettings.getSetting((String)"sharing.registry.server.host"), (int)Integer.parseInt(ServerSettings.getSetting((String)"sharing.registry.server.port")));
    }

    public void onMessage(MessageContext messageContext) {
        log.info("New DB Event message to sharing service.");
        try {
            byte[] bytes = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
            DBEventMessage dbEventMessage = new DBEventMessage();
            ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)dbEventMessage);
            log.info("DB Event message to sharing service from " + dbEventMessage.getPublisherService());
            DBEventMessageContext dBEventMessageContext = dbEventMessage.getMessageContext();
            try {
                block8 : switch (dBEventMessageContext.getPublisher().getPublisherContext().getEntityType()) {
                    case USER_PROFILE: {
                        log.info("User profile specific DB Event communicated by " + dbEventMessage.getPublisherService());
                        UserProfile userProfile = new UserProfile();
                        ThriftUtils.createThriftFromBytes((byte[])dBEventMessageContext.getPublisher().getPublisherContext().getEntityDataModel(), (TBase)userProfile);
                        User user = ThriftDataModelConversion.getUser(userProfile);
                        switch (dBEventMessageContext.getPublisher().getPublisherContext().getCrudType()) {
                            case CREATE: {
                                log.info("Creating user. User Id : " + user.getUserId());
                                this.sharingRegistryClient.createUser(user);
                                log.debug("User created. User Id : " + user.getUserId());
                                break block8;
                            }
                            case READ: {
                                break block8;
                            }
                            case UPDATE: {
                                log.info("Updating user. User Id : " + user.getUserId());
                                this.sharingRegistryClient.updatedUser(user);
                                log.debug("User updated. User Id : " + user.getUserId());
                                break block8;
                            }
                            case DELETE: {
                                log.info("Deleting user. User Id : " + user.getUserId());
                                this.sharingRegistryClient.deleteUser(user.getDomainId(), user.getUserId());
                                log.debug("User deleted. User Id : " + user.getUserId());
                            }
                        }
                        break;
                    }
                    case TENANT: {
                        log.info("Tenant specific DB Event communicated by " + dbEventMessage.getPublisherService());
                        Gateway gateway = new Gateway();
                        ThriftUtils.createThriftFromBytes((byte[])dBEventMessageContext.getPublisher().getPublisherContext().getEntityDataModel(), (TBase)gateway);
                        switch (dBEventMessageContext.getPublisher().getPublisherContext().getCrudType()) {
                            case CREATE: 
                            case UPDATE: {
                                if (this.sharingRegistryClient.isDomainExists(gateway.getGatewayId())) break;
                                log.info("Creating domain. Id : " + gateway.getGatewayId());
                                Domain domain = new Domain();
                                domain.setDomainId(gateway.getGatewayId());
                                domain.setName(gateway.getGatewayName());
                                domain.setDescription("Domain entry for " + domain.name);
                                try {
                                    this.sharingRegistryClient.createDomain(domain);
                                    log.debug("Domain created. Id : " + gateway.getGatewayId());
                                }
                                catch (DuplicateEntryException ex) {
                                    log.warn("DuplicateEntryException while consuming TENANT create message, ex: " + ex.getMessage() + ", Domain Id : " + gateway.getGatewayId(), (Throwable)ex);
                                }
                                log.info("Creating entity type. Id : " + domain.domainId + ":PROJECT");
                                EntityType entityType = new EntityType();
                                entityType.setEntityTypeId(domain.domainId + ":PROJECT");
                                entityType.setDomainId(domain.domainId);
                                entityType.setName("PROJECT");
                                entityType.setDescription("Project entity type");
                                try {
                                    this.sharingRegistryClient.createEntityType(entityType);
                                    log.debug("Entity type created. Id : " + domain.domainId + ":PROJECT");
                                }
                                catch (DuplicateEntryException ex) {
                                    log.warn("DuplicateEntryException while consuming TENANT create message, ex: " + ex.getMessage() + ", Entity Id : " + domain.domainId + ":PROJECT", (Throwable)ex);
                                }
                                log.info("Creating entity type. Id : " + domain.domainId + ":EXPERIMENT");
                                entityType = new EntityType();
                                entityType.setEntityTypeId(domain.domainId + ":EXPERIMENT");
                                entityType.setDomainId(domain.domainId);
                                entityType.setName("EXPERIMENT");
                                entityType.setDescription("Experiment entity type");
                                try {
                                    this.sharingRegistryClient.createEntityType(entityType);
                                    log.debug("Entity type created. Id : " + domain.domainId + ":EXPERIMENT");
                                }
                                catch (DuplicateEntryException ex) {
                                    log.warn("DuplicateEntryException while consuming TENANT create message, ex: " + ex.getMessage() + ", Entity Id : " + domain.domainId + ":EXPERIMENT", (Throwable)ex);
                                }
                                log.info("Creating entity type. Id : " + domain.domainId + ":FILE");
                                entityType = new EntityType();
                                entityType.setEntityTypeId(domain.domainId + ":FILE");
                                entityType.setDomainId(domain.domainId);
                                entityType.setName("FILE");
                                entityType.setDescription("File entity type");
                                try {
                                    this.sharingRegistryClient.createEntityType(entityType);
                                    log.debug("Entity type created. Id : " + domain.domainId + ":FILE");
                                }
                                catch (DuplicateEntryException ex) {
                                    log.warn("DuplicateEntryException while consuming TENANT create message, ex: " + ex.getMessage() + ", Entity Id : " + domain.domainId + ":FILE", (Throwable)ex);
                                }
                                log.info("Creating Permission Type. Id : " + domain.domainId + ":READ");
                                PermissionType permissionType = new PermissionType();
                                permissionType.setPermissionTypeId(domain.domainId + ":READ");
                                permissionType.setDomainId(domain.domainId);
                                permissionType.setName("READ");
                                permissionType.setDescription("Read permission type");
                                try {
                                    this.sharingRegistryClient.createPermissionType(permissionType);
                                    log.debug("Permission Type created. Id : " + domain.domainId + ":READ");
                                }
                                catch (DuplicateEntryException ex) {
                                    log.warn("DuplicateEntryException while consuming TENANT create message, ex: " + ex.getMessage() + ", Permission Id : " + domain.domainId + ":READ", (Throwable)ex);
                                }
                                log.info("Creating Permission Type. Id : " + domain.domainId + ":WRITE");
                                permissionType = new PermissionType();
                                permissionType.setPermissionTypeId(domain.domainId + ":WRITE");
                                permissionType.setDomainId(domain.domainId);
                                permissionType.setName("WRITE");
                                permissionType.setDescription("Write permission type");
                                try {
                                    this.sharingRegistryClient.createPermissionType(permissionType);
                                    log.debug("Permission Type created. Id : " + domain.domainId + ":WRITE");
                                    break;
                                }
                                catch (DuplicateEntryException ex) {
                                    log.warn("DuplicateEntryException while consuming TENANT create message, ex: " + ex.getMessage() + ", Permission Id : " + domain.domainId + ":WRITE", (Throwable)ex);
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        log.error("Handler not defined for " + dBEventMessageContext.getPublisher().getPublisherContext().getEntityType());
                        break;
                    }
                }
            }
            catch (DuplicateEntryException ex) {
                log.warn("DuplicateEntryException while consuming db-event message, ex: " + ex.getMessage(), (Throwable)ex);
            }
            log.info("Sending ack. Message Delivery Tag : " + messageContext.getDeliveryTag());
            SharingServiceDBEventMessagingFactory.getDBEventSubscriber().sendAck(messageContext.getDeliveryTag());
        }
        catch (TException e) {
            log.error("Error processing message.", (Throwable)e);
        }
        catch (ApplicationSettingsException e) {
            log.error("Error fetching application settings.", (Throwable)e);
        }
        catch (AiravataException e) {
            log.error("Error sending ack. Message Delivery Tag : " + messageContext.getDeliveryTag(), (Throwable)e);
        }
    }
}

