/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal.client;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.RestManagementConstants;
import org.apache.aries.jax.rs.rest.management.feature.RestManagementFeature;
import org.apache.aries.jax.rs.rest.management.schema.BundleExceptionSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleHeaderSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleListSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchemaListSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleStateSchema;
import org.apache.aries.jax.rs.rest.management.schema.FrameworkStartLevelSchema;
import org.apache.aries.jax.rs.rest.management.schema.ServiceListSchema;
import org.apache.aries.jax.rs.rest.management.schema.ServiceSchemaListSchema;
import org.osgi.framework.BundleException;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.service.rest.client.RestClient;

public class RestClientImpl
implements RestClient {
    private final WebTarget webTarget;

    public RestClientImpl(WebTarget webTarget) {
        this.webTarget = webTarget;
        this.webTarget.register(RestManagementFeature.class);
    }

    public FrameworkStartLevelDTO getFrameworkStartLevel() throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("startlevel").request().get());){
            FrameworkStartLevelDTO frameworkStartLevelDTO = (FrameworkStartLevelDTO)response.readEntity(FrameworkStartLevelSchema.class);
            return frameworkStartLevelDTO;
        }
    }

    public void setFrameworkStartLevel(FrameworkStartLevelDTO startLevel) throws Exception {
        Response response = this.maybeThrow(this.webTarget.path("framework").path("startlevel").request().put(Entity.entity((Object)((Object)FrameworkStartLevelSchema.build(startLevel)), (String)"application/org.osgi.frameworkstartlevel+json")));
        if (response != null) {
            response.close();
        }
    }

    public Collection<String> getBundlePaths() throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundles").request().get());){
            List<String> list = ((BundleListSchema)((Object)response.readEntity(BundleListSchema.class))).bundles;
            return list;
        }
    }

    public Collection<BundleDTO> getBundles() throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundles").path("representations").request().get());){
            Collection collection = ((BundleSchemaListSchema)((Object)response.readEntity(BundleSchemaListSchema.class))).bundles.stream().map(BundleDTO.class::cast).collect(Collectors.toList());
            return collection;
        }
    }

    public BundleDTO getBundle(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").resolveTemplate("bundleid", (Object)id).request().get());){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO getBundle(String bundlePath) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path(bundlePath).request().get());){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public int getBundleState(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("state").resolveTemplate("bundleid", (Object)id).request().get());){
            int n = ((BundleStateSchema)((Object)response.readEntity(BundleStateSchema.class))).state;
            return n;
        }
    }

    public int getBundleState(String bundlePath) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("state").request().get());){
            int n = ((BundleStateSchema)((Object)response.readEntity(BundleStateSchema.class))).state;
            return n;
        }
    }

    public void startBundle(long id) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 32;
        Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("state").resolveTemplate("bundleid", (Object)id).request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void startBundle(String bundlePath) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 32;
        Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("state").request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void startBundle(long id, int options) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 32;
        bundleStateDTO.options = options;
        Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("state").resolveTemplate("bundleid", (Object)id).request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void startBundle(String bundlePath, int options) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 32;
        bundleStateDTO.options = options;
        Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("state").request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void stopBundle(long id) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 4;
        Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("state").resolveTemplate("bundleid", (Object)id).request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void stopBundle(String bundlePath) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 4;
        Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("state").request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void stopBundle(long id, int options) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 4;
        bundleStateDTO.options = options;
        Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("state").resolveTemplate("bundleid", (Object)id).request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void stopBundle(String bundlePath, int options) throws Exception {
        BundleStateSchema bundleStateDTO = new BundleStateSchema();
        bundleStateDTO.state = 4;
        bundleStateDTO.options = options;
        Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("state").request().put(Entity.entity((Object)((Object)bundleStateDTO), (MediaType)RestManagementConstants.APPLICATION_BUNDLESTATE_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public Map<String, String> getBundleHeaders(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("header").resolveTemplate("bundleid", (Object)id).request().get());){
            Map map = (Map)response.readEntity(BundleHeaderSchema.class);
            return map;
        }
    }

    public Map<String, String> getBundleHeaders(String bundlePath) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path(bundlePath).request().get());){
            Map map = (Map)response.readEntity(BundleHeaderSchema.class);
            return map;
        }
    }

    public BundleStartLevelDTO getBundleStartLevel(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("startlevel").resolveTemplate("bundleid", (Object)id).request().get());){
            BundleStartLevelDTO bundleStartLevelDTO = (BundleStartLevelDTO)response.readEntity(BundleStartLevelDTO.class);
            return bundleStartLevelDTO;
        }
    }

    public BundleStartLevelDTO getBundleStartLevel(String bundlePath) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("startlevel").request().get());){
            BundleStartLevelDTO bundleStartLevelDTO = (BundleStartLevelDTO)response.readEntity(BundleStartLevelDTO.class);
            return bundleStartLevelDTO;
        }
    }

    public void setBundleStartLevel(long id, int startLevel) throws Exception {
        BundleStartLevelDTO bundleStartLevelDTO = new BundleStartLevelDTO();
        bundleStartLevelDTO.startLevel = startLevel;
        Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").path("startlevel").resolveTemplate("bundleid", (Object)id).request().put(Entity.entity((Object)bundleStartLevelDTO, (MediaType)RestManagementConstants.APPLICATION_BUNDLESTARTLEVEL_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public void setBundleStartLevel(String bundlePath, int startLevel) throws Exception {
        BundleStartLevelDTO bundleStartLevelDTO = new BundleStartLevelDTO();
        bundleStartLevelDTO.startLevel = startLevel;
        Response response = this.maybeThrow(this.webTarget.path(bundlePath).path("startlevel").request().put(Entity.entity((Object)bundleStartLevelDTO, (MediaType)RestManagementConstants.APPLICATION_BUNDLESTARTLEVEL_JSON_TYPE)));
        if (response != null) {
            response.close();
        }
    }

    public BundleDTO installBundle(String location) throws Exception {
        try (Response response = this.maybeThrow(() -> {
            Response r = this.webTarget.path("framework").path("bundles").request(new String[]{"application/org.osgi.bundle+json"}).post(Entity.entity((Object)location, (String)"text/plain"));
            Response.StatusType statusInfo = r.getStatusInfo();
            if (statusInfo.getStatusCode() == 400) {
                BundleExceptionSchema bundleExceptionSchema = (BundleExceptionSchema)r.readEntity(BundleExceptionSchema.class);
                throw new BundleException(bundleExceptionSchema.message, bundleExceptionSchema.typecode);
            }
            return r;
        });){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO installBundle(String location, InputStream in) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundles").request(new String[]{"application/org.osgi.bundle+json"}).header("Content-Location", (Object)location).post(Entity.entity((Object)in, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE)));){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO uninstallBundle(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").resolveTemplate("bundleid", (Object)id).request(new String[]{"application/org.osgi.bundle+json"}).delete());){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO uninstallBundle(String bundlePath) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path(bundlePath).request(new String[]{"application/org.osgi.bundle+json"}).delete());){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO updateBundle(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").resolveTemplate("bundleid", (Object)id).request(new String[]{"application/org.osgi.bundle+json"}).put(Entity.entity((Object)"", (MediaType)MediaType.TEXT_PLAIN_TYPE)));){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO updateBundle(long id, String url) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").resolveTemplate("bundleid", (Object)id).request(new String[]{"application/org.osgi.bundle+json"}).put(Entity.entity((Object)url, (MediaType)MediaType.TEXT_PLAIN_TYPE)));){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public BundleDTO updateBundle(long id, InputStream in) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("bundle").path("{bundleid}").resolveTemplate("bundleid", (Object)id).request(new String[]{"application/org.osgi.bundle+json"}).put(Entity.entity((Object)in, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE)));){
            BundleDTO bundleDTO = (BundleDTO)response.readEntity(BundleSchema.class);
            return bundleDTO;
        }
    }

    public Collection<String> getServicePaths() throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("services").request(new MediaType[]{RestManagementConstants.APPLICATION_SERVICES_JSON_TYPE}).get());){
            List<String> list = ((ServiceListSchema)((Object)response.readEntity(ServiceListSchema.class))).services;
            return list;
        }
    }

    public Collection<String> getServicePaths(String filter) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("services").queryParam("filter", new Object[]{filter}).request(new MediaType[]{RestManagementConstants.APPLICATION_SERVICES_JSON_TYPE}).get());){
            List<String> list = ((ServiceListSchema)((Object)response.readEntity(ServiceListSchema.class))).services;
            return list;
        }
    }

    public Collection<ServiceReferenceDTO> getServiceReferences() throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("services").path("representations").request(new MediaType[]{RestManagementConstants.APPLICATION_SERVICES_REPRESENTATIONS_JSON_TYPE}).get());){
            Collection collection = ((ServiceSchemaListSchema)((Object)response.readEntity(ServiceSchemaListSchema.class))).services.stream().map(ServiceReferenceDTO.class::cast).collect(Collectors.toList());
            return collection;
        }
    }

    public Collection<ServiceReferenceDTO> getServiceReferences(String filter) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("services").path("representations").queryParam("filter", new Object[]{filter}).request(new MediaType[]{RestManagementConstants.APPLICATION_SERVICES_REPRESENTATIONS_JSON_TYPE}).get());){
            Collection collection = ((ServiceSchemaListSchema)((Object)response.readEntity(ServiceSchemaListSchema.class))).services.stream().map(ServiceReferenceDTO.class::cast).collect(Collectors.toList());
            return collection;
        }
    }

    public ServiceReferenceDTO getServiceReference(long id) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path("framework").path("service").path("{serviceid}").resolveTemplate("serviceid", (Object)id).request(new MediaType[]{RestManagementConstants.APPLICATION_SERVICE_JSON_TYPE}).get());){
            ServiceReferenceDTO serviceReferenceDTO = (ServiceReferenceDTO)response.readEntity(ServiceReferenceDTO.class);
            return serviceReferenceDTO;
        }
    }

    public ServiceReferenceDTO getServiceReference(String servicePath) throws Exception {
        try (Response response = this.maybeThrow(this.webTarget.path(servicePath).request(new MediaType[]{RestManagementConstants.APPLICATION_SERVICE_JSON_TYPE}).get());){
            ServiceReferenceDTO serviceReferenceDTO = (ServiceReferenceDTO)response.readEntity(ServiceReferenceDTO.class);
            return serviceReferenceDTO;
        }
    }

    private Response maybeThrow(Response response) throws Exception {
        return this.maybeThrow(() -> response);
    }

    private Response maybeThrow(Callable<Response> alternate) throws Exception {
        Response response = alternate.call();
        Response.StatusType statusInfo = response.getStatusInfo();
        if (statusInfo.getStatusCode() >= 300) {
            throw new Exception(statusInfo.getReasonPhrase());
        }
        return response;
    }
}

