/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp.config;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.squareup.okhttp.OkHttpClient;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.SSLModule;
import org.jclouds.http.okhttp.OkHttpClientSupplier;
import org.jclouds.http.okhttp.OkHttpCommandExecutorService;

@ConfiguresHttpCommandExecutorService
public class OkHttpCommandExecutorServiceModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SSLModule());
        this.bind(HttpCommandExecutorService.class).to(OkHttpCommandExecutorService.class).in(Scopes.SINGLETON);
        this.bind(OkHttpClient.class).toProvider(OkHttpClientProvider.class).in(Scopes.SINGLETON);
    }

    private static final class OkHttpClientProvider
    implements Provider<OkHttpClient> {
        private final HostnameVerifier verifier;
        private final Supplier<SSLContext> untrustedSSLContextProvider;
        private final HttpUtils utils;
        private final OkHttpClientSupplier clientSupplier;

        @Inject
        OkHttpClientProvider(HttpUtils utils, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, OkHttpClientSupplier clientSupplier) {
            this.utils = utils;
            this.verifier = verifier;
            this.untrustedSSLContextProvider = untrustedSSLContextProvider;
            this.clientSupplier = clientSupplier;
        }

        public OkHttpClient get() {
            OkHttpClient client = (OkHttpClient)this.clientSupplier.get();
            client.setConnectTimeout((long)this.utils.getConnectionTimeout(), TimeUnit.MILLISECONDS);
            client.setReadTimeout((long)this.utils.getSocketOpenTimeout(), TimeUnit.MILLISECONDS);
            client.setFollowRedirects(false);
            if (this.utils.relaxHostname()) {
                client.setHostnameVerifier(this.verifier);
            }
            if (this.utils.trustAllCerts()) {
                client.setSslSocketFactory(((SSLContext)this.untrustedSSLContextProvider.get()).getSocketFactory());
            }
            return client;
        }
    }
}

