/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.module.api;

import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.internal.UiModuleImpl;
import org.apache.karaf.web.WebBundle;
import org.apache.karaf.web.WebContainerService;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.ops4j.pax.web.service.spi.WebListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class UiModuleListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(UiModuleListener.class);
    private static final Dictionary<String, ?> EMPTY_DICTIONARY = new Hashtable();
    public static final String CONFIG_PATH = "/WEB-INF/classes/ui-module/config.yaml";
    private ServiceRegistration<UiModule> registration;
    private AtomicReference<WebListener> listener = new AtomicReference();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        UiModule uiModule = this.createUiModule(servletContextEvent.getServletContext());
        Object moduleBundle = servletContextEvent.getServletContext().getAttribute("osgi-bundlecontext");
        Bundle bundle = moduleBundle instanceof BundleContext ? ((BundleContext)moduleBundle).getBundle() : FrameworkUtil.getBundle(this.getClass());
        this.initWebListener(bundle);
        try {
            if (bundle.getState() != 32) {
                Duration TIMEOUT = Duration.ofMinutes(2L);
                LOG.warn("Bundle [{}] not ACTIVE to register Brooklyn UI module [{}], bundle current state [{}], will wait up to {}", new Object[]{bundle.getSymbolicName(), uiModule.getName(), bundle.getState(), TIMEOUT});
                this.blockUntilBundleStarted(bundle, TIMEOUT);
            }
            LOG.info("Registering new Brooklyn UI module {}:{} [{}] called '{}' on context-path '{}'", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), bundle.getVersion(), uiModule.getName(), uiModule.getPath()});
            this.registration = bundle.getBundleContext().registerService(UiModule.class, (Object)uiModule, EMPTY_DICTIONARY);
            LOG.trace("ServletContextListener on initializing UI module " + bundle.getSymbolicName() + " [" + bundle.getBundleId() + "] to " + uiModule.getPath() + ", checking whether any bundles need stopping");
            this.stopAnyExistingOrSuperseded(uiModule, bundle);
        }
        catch (Exception e) {
            LOG.error("Failed registration of Brooklyn UI module [" + uiModule.getName() + "] to [" + uiModule.getPath() + "]: " + e, (Throwable)e);
        }
    }

    private void initWebListener(Bundle bundle) {
        if (this.listener.compareAndSet(null, new UiModuleWebListener())) {
            bundle.getBundleContext().registerService(WebListener.class, (Object)this.listener.get(), null);
        }
    }

    protected void stopAnyExistingOrSuperseded(UiModule uiModule, Bundle bundle) throws Exception {
        if (uiModule.getStopExisting()) {
            this.stopExistingModulesListeningOnOurEndpoint(bundle, uiModule);
        }
        if (!uiModule.getSupersedesBundles().isEmpty()) {
            this.stopSupersededBundles(bundle, uiModule);
        }
    }

    private void stopExistingModulesListeningOnOurEndpoint(Bundle bundle, UiModule uiModule) throws Exception {
        ServiceReference webS = bundle.getBundleContext().getServiceReference(WebContainerService.class);
        WebContainerService web = (WebContainerService)bundle.getBundleContext().getService(webS);
        for (WebBundle bi : web.list()) {
            if (bi.getBundleId() == bundle.getBundleId() || !uiModule.getPath().equals(bi.getContextPath()) && (!uiModule.getPath().equals("") || !bi.getContextPath().equals("/"))) continue;
            Bundle bb = bundle.getBundleContext().getBundle(bi.getBundleId());
            Collection modules = bundle.getBundleContext().getServiceReferences(UiModule.class, null);
            for (ServiceReference modS : modules) {
                UiModule mod;
                if (modS.getBundle() == null || modS.getBundle().getBundleId() != bi.getBundleId() || !this.isBundleSuperseded(mod = (UiModule)bundle.getBundleContext().getService(modS), bundle)) continue;
                this.stopBundle(bundle, "context path " + bi.getContextPath() + " is in use by " + bb.getSymbolicName() + " [" + bb.getBundleId() + "]");
                return;
            }
            if (bb.getBundleId() >= bundle.getBundleId()) continue;
            this.stopBundle(bb, "context path " + bi.getContextPath() + " is needed for installation of " + bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]");
        }
    }

    private void stopSupersededBundles(Bundle bundle, UiModule uiModule) {
        LOG.trace("Calling stopSuperseded on install of " + bundle.getSymbolicName() + "; will stop any of " + uiModule.getSupersedesBundles());
        for (Bundle b : bundle.getBundleContext().getBundles()) {
            if (b.getBundleId() == bundle.getBundleId() || !this.isBundleSuperseded(uiModule, b)) continue;
            this.stopBundle(b, "it is superseded by " + bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]");
        }
    }

    private boolean isBundleSuperseded(UiModule module, Bundle bundle) {
        if (module.getSupersedesBundles() != null) {
            Iterator<String> iterator = module.getSupersedesBundles().iterator();
            while (iterator.hasNext()) {
                String superseded;
                String bn = superseded = iterator.next();
                String version = null;
                int split = bn.indexOf(58);
                if (split >= 0) {
                    version = bn.substring(split + 1);
                    bn = bn.substring(0, split);
                }
                if (!bundle.getSymbolicName().matches(bn) || version != null && !bundle.getVersion().toString().matches(version)) continue;
                return true;
            }
        }
        return false;
    }

    protected void stopBundle(Bundle bundleToStop, String reason) {
        boolean isActive = this.isBundleStartingOrActive(bundleToStop);
        String message = "stopping bundle " + bundleToStop.getSymbolicName() + " [" + bundleToStop.getBundleId() + "]; " + reason;
        if (!isActive) {
            LOG.trace("Not " + message + "; but that conflicting bundle is not starting or active");
            return;
        }
        LOG.info("UiModules: " + message);
        new Thread(() -> {
            try {
                bundleToStop.stop();
            }
            catch (Exception e) {
                LOG.warn("UiModules: error " + message + ": " + e, (Throwable)e);
            }
        }).start();
    }

    protected boolean isBundleStartingOrActive(Bundle bundleToStop) {
        switch (bundleToStop.getState()) {
            case 1: 
            case 8: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private void blockUntilBundleStarted(Bundle bundle, Duration timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout.toMillis();
        do {
            TimeUnit.MILLISECONDS.sleep(100L);
            LOG.trace("Waiting for bundle [{}] to be ACTIVE, current state [{}]", (Object)bundle.getSymbolicName(), (Object)bundle.getState());
            if (bundle.getState() != 32) continue;
            return;
        } while (System.currentTimeMillis() < endTime);
        throw new IllegalStateException("Bundle " + bundle.getSymbolicName() + ":" + bundle.getVersion() + " is not ACTIVE, even after waiting");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOG.info("Unregistering Brooklyn UI module at [{}]", (Object)servletContextEvent.getServletContext().getContextPath());
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException e) {
                if (e.toString().contains("already unregistered")) {
                    LOG.debug("In {}, service already unregistered, on contextDestroyed for context {}", (Object)this, (Object)servletContextEvent);
                }
                LOG.warn("Problem unregistering service in " + this + ", on contextDestroyed for context " + servletContextEvent + " (continuing)", (Throwable)e);
            }
            this.registration = null;
        }
    }

    private UiModule createUiModule(ServletContext servletContext) {
        InputStream is = servletContext.getResourceAsStream(CONFIG_PATH);
        String path = servletContext.getContextPath();
        return this.createUiModule(is, path);
    }

    protected UiModule createUiModule(InputStream is, String path) {
        if (is == null) {
            throw new RuntimeException(String.format("Module on path [%s] will not be registered as it does not have any configuration", path));
        }
        Map config = (Map)new Yaml().load(is);
        return UiModuleImpl.createFromMap(config).path(path);
    }

    public class UiModuleWebListener
    implements WebListener {
        long lastId = -1L;

        public void webEvent(WebEvent event) {
            try {
                if (event.getType() == 1 && this.lastId != event.getBundleId()) {
                    this.lastId = event.getBundleId();
                    URL config = event.getBundle().getResource(UiModuleListener.CONFIG_PATH);
                    if (config != null) {
                        LOG.trace("WebListener on deploying UI module " + event.getBundle().getSymbolicName() + " [" + event.getBundleId() + "] to " + event.getContextPath() + ", checking whether any bundles need stopping");
                        UiModuleListener.this.stopAnyExistingOrSuperseded(UiModuleListener.this.createUiModule(config.openStream(), event.getContextPath()), event.getBundle());
                    }
                }
            }
            catch (Exception e) {
                if (!UiModuleListener.this.isBundleStartingOrActive(event.getBundle())) {
                    LOG.debug("Error listening to UI module bundle " + event.getBundleName() + " in state " + event.getBundle().getState() + " (not starting/active, so not a serious problem, esp if we just stopped it): " + e);
                }
                LOG.warn("Error listening to UI module bundle " + event.getBundleName() + " start: " + e, (Throwable)e);
            }
        }
    }
}

