/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.repeat;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.MoreExecutors;
import groovy.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repeater
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(Repeater.class);
    public static final org.apache.brooklyn.util.time.Duration DEFAULT_REAL_QUICK_PERIOD = org.apache.brooklyn.util.time.Duration.millis(10);
    private final String description;
    private Callable<?> body = Callables.returning(null);
    private Callable<Boolean> exitCondition;
    private Function<? super Integer, org.apache.brooklyn.util.time.Duration> delayOnIteration = null;
    private org.apache.brooklyn.util.time.Duration timeLimit = null;
    private int iterationLimit = 0;
    private boolean rethrowException = false;
    private Predicate<? super Throwable> rethrowImmediatelyCondition = Exceptions.isFatalPredicate();
    private boolean warnOnUnRethrownException = true;
    private boolean shutdown = false;
    private ExecutorService executor = MoreExecutors.newDirectExecutorService();

    public Repeater() {
        this(null);
    }

    public Repeater(String description) {
        this.description = description != null ? description : "Repeater";
    }

    public static Repeater create() {
        return Repeater.create(null);
    }

    public static Repeater create(String description) {
        return new Repeater(description);
    }

    public Repeater repeat(Runnable body) {
        Preconditions.checkNotNull((Object)body, (Object)"body must not be null");
        this.body = body instanceof Callable ? (Callable<Object>)((Object)body) : Executors.callable(body);
        return this;
    }

    public Repeater repeat(Callable<?> body) {
        Preconditions.checkNotNull(body, (Object)"body must not be null");
        this.body = body;
        return this;
    }

    public Repeater threaded() {
        this.executor = Executors.newSingleThreadExecutor();
        this.shutdown = true;
        return this;
    }

    public Repeater threaded(ExecutorService executor) {
        this.executor = executor;
        this.shutdown = false;
        return this;
    }

    public Repeater every(long period, TimeUnit unit) {
        return this.every(org.apache.brooklyn.util.time.Duration.of(period, unit));
    }

    public Repeater every(org.apache.brooklyn.util.time.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration must not be null");
        Preconditions.checkArgument((boolean)duration.isPositive(), (String)"period must be positive: %s", (Object[])new Object[]{duration});
        return this.delayOnIteration((Function<? super Integer, org.apache.brooklyn.util.time.Duration>)Functions.constant((Object)duration));
    }

    @Deprecated
    public Repeater every(Duration duration) {
        return this.every(org.apache.brooklyn.util.time.Duration.of(duration));
    }

    public Repeater delayOnIteration(Function<? super Integer, org.apache.brooklyn.util.time.Duration> delayFunction) {
        Preconditions.checkNotNull(delayFunction, (Object)"delayFunction must not be null");
        this.delayOnIteration = delayFunction;
        return this;
    }

    public Repeater backoff(final org.apache.brooklyn.util.time.Duration initialDelay, final double multiplier, final @Nullable org.apache.brooklyn.util.time.Duration finalDelay) {
        Preconditions.checkNotNull((Object)initialDelay, (Object)"initialDelay");
        Preconditions.checkArgument((multiplier >= 1.0 ? 1 : 0) != 0, (Object)"multiplier >= 1.0");
        return this.delayOnIteration((Function<? super Integer, org.apache.brooklyn.util.time.Duration>)new Function<Integer, org.apache.brooklyn.util.time.Duration>(){

            public org.apache.brooklyn.util.time.Duration apply(Integer iteration) {
                org.apache.brooklyn.util.time.Duration result = initialDelay;
                for (int i = 0; i < iteration; ++i) {
                    result = result.multiply(multiplier);
                    if (finalDelay == null || result.compareTo(finalDelay) <= 0) continue;
                    return finalDelay;
                }
                return result;
            }
        });
    }

    public Repeater backoffTo(org.apache.brooklyn.util.time.Duration finalDelay) {
        return this.backoff(org.apache.brooklyn.util.time.Duration.millis(10), 1.2, finalDelay);
    }

    public Repeater until(Callable<Boolean> exitCondition) {
        Preconditions.checkNotNull(exitCondition, (Object)"exitCondition must not be null");
        this.exitCondition = exitCondition;
        return this;
    }

    public <T> Repeater until(final T target, final Predicate<T> exitCondition) {
        Preconditions.checkNotNull(exitCondition, (Object)"exitCondition must not be null");
        return this.until(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return exitCondition.apply(target);
            }
        });
    }

    public <T> Repeater until(final Supplier<T> supplier, final Predicate<T> exitCondition) {
        Preconditions.checkNotNull(supplier, (Object)"supplier must not be null");
        Preconditions.checkNotNull(exitCondition, (Object)"exitCondition must not be null");
        return this.until(new Callable<Boolean>(){
            private Maybe<T> lastValue = Maybe.absent();

            @Override
            public Boolean call() throws Exception {
                this.lastValue = Maybe.ofAllowingNull(supplier.get());
                return exitCondition.apply(this.lastValue.get());
            }

            public String toString() {
                return "" + (this.lastValue.isPresent() ? this.lastValue.get() : supplier) + " " + exitCondition;
            }
        });
    }

    public Repeater rethrowException() {
        this.rethrowException = true;
        return this;
    }

    public Repeater rethrowExceptionImmediately() {
        this.rethrowImmediatelyCondition = Predicates.alwaysTrue();
        return this;
    }

    public Repeater rethrowExceptionImmediately(Predicate<? super Throwable> val) {
        this.rethrowImmediatelyCondition = (Predicate)Preconditions.checkNotNull(val, (Object)"rethrowExceptionImmediately predicate");
        return this;
    }

    public Repeater suppressWarnings() {
        this.warnOnUnRethrownException = false;
        return this;
    }

    public Repeater limitIterationsTo(int iterationLimit) {
        Preconditions.checkArgument((iterationLimit > 0 ? 1 : 0) != 0, (String)"iterationLimit must be positive: %s", (Object[])new Object[]{iterationLimit});
        this.iterationLimit = iterationLimit;
        return this;
    }

    public Repeater limitTimeTo(long deadline, TimeUnit unit) {
        return this.limitTimeTo(org.apache.brooklyn.util.time.Duration.of(deadline, unit));
    }

    public Repeater limitTimeTo(org.apache.brooklyn.util.time.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration must not be null");
        Preconditions.checkArgument((boolean)duration.isPositive(), (String)"deadline must be positive: %s", (Object[])new Object[]{duration});
        this.timeLimit = duration;
        return this;
    }

    public boolean run() {
        return this.runKeepingError().getWithoutError();
    }

    public void runRequiringTrue() {
        Stopwatch timer = Stopwatch.createStarted();
        ReferenceWithError<Boolean> result = this.runKeepingError();
        result.checkNoError();
        if (!result.get().booleanValue()) {
            throw new IllegalStateException(this.description + " unsatisfied after " + org.apache.brooklyn.util.time.Duration.of(timer) + ": " + this.exitCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceWithError<Boolean> runKeepingError() {
        Preconditions.checkNotNull(this.body, (Object)"repeat() method has not been called to set the body");
        Preconditions.checkNotNull(this.exitCondition, (Object)"until() method has not been called to set the exit condition");
        Preconditions.checkNotNull(this.delayOnIteration, (Object)"every() method (or other delaySupplier() / backoff() method) has not been called to set the loop delay");
        boolean hasLoggedTransientException = false;
        Throwable lastError = null;
        int iterations = 0;
        CountdownTimer timer = this.timeLimit != null ? CountdownTimer.newInstanceStarted(this.timeLimit) : CountdownTimer.newInstancePaused(org.apache.brooklyn.util.time.Duration.PRACTICALLY_FOREVER);
        try {
            while (true) {
                ReferenceWithError<Boolean> referenceWithError;
                boolean done;
                org.apache.brooklyn.util.time.Duration delayThisIteration;
                block29: {
                    delayThisIteration = (org.apache.brooklyn.util.time.Duration)this.delayOnIteration.apply((Object)iterations);
                    if (timer.isNotPaused() && delayThisIteration.isLongerThan(timer.getDurationRemaining())) {
                        delayThisIteration = timer.getDurationRemaining();
                    }
                    ++iterations;
                    Future<?> call = this.executor.submit(this.body);
                    try {
                        call.get(delayThisIteration.toMilliseconds(), TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable e) {
                        log.warn(this.description, e);
                        if (this.rethrowImmediatelyCondition.apply((Object)e)) {
                            throw Exceptions.propagate(e);
                        }
                    }
                    finally {
                        call.cancel(true);
                    }
                    done = false;
                    try {
                        lastError = null;
                        done = this.exitCondition.call();
                        hasLoggedTransientException = false;
                    }
                    catch (Throwable e) {
                        if (hasLoggedTransientException) {
                            log.debug("{}: repeated failure; excluding stacktrace: {}", (Object)this.description, (Object)e.toString());
                        } else {
                            log.debug(this.description, e);
                            hasLoggedTransientException = true;
                        }
                        lastError = e;
                        if (!this.rethrowImmediatelyCondition.apply((Object)e)) break block29;
                        throw Exceptions.propagate(e);
                    }
                }
                if (done) {
                    log.debug("{}: condition satisfied", (Object)this.description);
                    ReferenceWithError<Boolean> e = ReferenceWithError.newInstanceWithoutError(true);
                    return e;
                }
                if (log.isDebugEnabled()) {
                    String msg = String.format("%s: unsatisfied during iteration %s %s", this.description, iterations, (this.iterationLimit > 0 ? "(max " + this.iterationLimit + " attempts)" : "") + (timer.isNotPaused() ? "(" + Time.makeTimeStringRounded(timer.getDurationRemaining()) + " remaining)" : ""));
                    if (iterations == 1) {
                        log.debug(msg);
                    } else {
                        log.trace(msg);
                    }
                }
                if (this.iterationLimit > 0 && iterations >= this.iterationLimit) {
                    log.debug("{}: condition not satisfied and exceeded iteration limit", (Object)this.description);
                    if (this.rethrowException && lastError != null) {
                        log.warn("{}: error caught checking condition (rethrowing): {}", (Object)this.description, (Object)lastError.getMessage());
                        throw Exceptions.propagate(lastError);
                    }
                    if (this.warnOnUnRethrownException && lastError != null) {
                        log.warn("{}: error caught checking condition: {}", (Object)this.description, (Object)lastError.getMessage());
                    }
                    referenceWithError = ReferenceWithError.newInstanceMaskingError(false, lastError);
                    return referenceWithError;
                }
                if (timer.isExpired()) {
                    log.debug("{}: condition not satisfied, with {} elapsed (limit {})", new Object[]{this.description, Time.makeTimeStringRounded(timer.getDurationElapsed()), Time.makeTimeStringRounded(this.timeLimit)});
                    if (this.rethrowException && lastError != null) {
                        log.error("{}: error caught checking condition: {}", (Object)this.description, (Object)lastError.getMessage());
                        throw Exceptions.propagate(lastError);
                    }
                    referenceWithError = ReferenceWithError.newInstanceMaskingError(false, lastError);
                    return referenceWithError;
                }
                Time.sleep(delayThisIteration);
            }
        }
        finally {
            if (this.shutdown) {
                this.executor.shutdownNow();
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public org.apache.brooklyn.util.time.Duration getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public Boolean call() throws Exception {
        return this.run();
    }
}

