/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.io.StringWriter;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.persist.XmlMementoSerializer;
import org.apache.brooklyn.core.mgmt.rebind.dto.MementosGenerators;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogPredicates {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogPredicates.class);
    public static final Predicate<CatalogItem<Application, EntitySpec<? extends Application>>> IS_TEMPLATE = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.TEMPLATE);
    public static final Predicate<CatalogItem<Entity, EntitySpec<?>>> IS_APPLICATION = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.APPLICATION);
    public static final Predicate<CatalogItem<Entity, EntitySpec<?>>> IS_ENTITY = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.ENTITY);
    public static final Predicate<CatalogItem<Policy, PolicySpec<?>>> IS_POLICY = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.POLICY);
    public static final Predicate<CatalogItem<Enricher, EnricherSpec<?>>> IS_ENRICHER = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.ENRICHER);
    public static final Predicate<CatalogItem<Location, LocationSpec<?>>> IS_LOCATION = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.LOCATION);
    private static final Function<CatalogItem<?, ?>, String> ID_OF_ITEM_TRANSFORMER_ANONYMOUS = new Function<CatalogItem<?, ?>, String>(){

        @Nullable
        public String apply(@Nullable CatalogItem<?, ?> input) {
            if (input == null) {
                return null;
            }
            return input.getId();
        }
    };
    public static final Function<CatalogItem<?, ?>, String> ID_OF_ITEM_TRANSFORMER = new IdOfItemTransformer();

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> isCatalogItemType(final CatalogItem.CatalogItemType ciType) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && item.getCatalogItemType() == ciType;
            }
        };
        return new CatalogItemTypeEqualTo(ciType);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> deprecated(final boolean deprecated) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && item.isDeprecated() == deprecated;
            }
        };
        return new DeprecatedEqualTo(deprecated);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> disabled(boolean disabled) {
        return new DisabledEqualTo(disabled);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> displayName(final Predicate<? super String> filter) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.getDisplayName());
            }
        };
        return new DisplayNameMatches(filter);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> symbolicName(final Predicate<? super String> filter) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.getSymbolicName());
            }
        };
        return new SymbolicNameMatches(filter);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> javaType(final Predicate<? super String> filter) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.getJavaType());
            }
        };
        return new JavaTypeMatches(filter);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> stringRepresentationMatches(Predicate<? super String> filter) {
        return new StringRepresentationMatches((Predicate<? super String>)((Predicate)Preconditions.checkNotNull(filter, (Object)"filter")));
    }

    private static <T, SpecT> Predicate<CatalogItem<T, SpecT>> xml(Predicate<? super String> filter) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                throw new IllegalStateException();
            }
        };
        throw new UnsupportedOperationException();
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> entitledToSee(final ManagementContext mgmt) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && Entitlements.isEntitled(mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, item.getCatalogItemId());
            }
        };
        return new EntitledToSee(mgmt);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> isBestVersion(final ManagementContext mgmt) {
        new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return CatalogUtils.isBestVersion(mgmt, item);
            }
        };
        return new IsBestVersion(mgmt);
    }

    private static class IsBestVersion<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final ManagementContext mgmt;

        public IsBestVersion(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return CatalogUtils.isBestVersion(this.mgmt, item);
        }

        public String toString() {
            return "IsBestVersion()";
        }
    }

    private static class EntitledToSee<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final ManagementContext mgmt;

        public EntitledToSee(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && Entitlements.isEntitled(this.mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, item.getCatalogItemId());
        }

        public String toString() {
            return "EntitledToSee()";
        }
    }

    private static class XmlMatches<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final Predicate<? super String> filter;

        public XmlMatches(Predicate<? super String> filter) {
            throw new IllegalStateException();
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            throw new IllegalStateException();
        }

        public String toString() {
            return "XmlMatches(" + this.filter + ")";
        }
    }

    private static class StringRepresentationMatches<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final Predicate<? super String> filter;

        StringRepresentationMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            try {
                Memento memento = MementosGenerators.newBasicMemento(item);
                XmlMementoSerializer serializer = new XmlMementoSerializer(CatalogPredicates.class.getClassLoader(), (Map<String, String>)ImmutableMap.of());
                StringWriter writer = new StringWriter();
                serializer.serialize(memento, writer);
                return this.filter.apply((Object)writer.toString());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.debug("Problem producing string representation of " + item + "; assuming no match, and continuing", (Throwable)e);
                return false;
            }
        }
    }

    private static class JavaTypeMatches<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final Predicate<? super String> filter;

        public JavaTypeMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && this.filter.apply((Object)item.getJavaType());
        }

        public String toString() {
            return "JavaTypeMatches(" + this.filter + ")";
        }
    }

    private static class SymbolicNameMatches<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final Predicate<? super String> filter;

        public SymbolicNameMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && this.filter.apply((Object)item.getSymbolicName());
        }

        public String toString() {
            return "SymbolicNameMatches(" + this.filter + ")";
        }
    }

    private static class DisplayNameMatches<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final Predicate<? super String> filter;

        public DisplayNameMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && this.filter.apply((Object)item.getDisplayName());
        }

        public String toString() {
            return "DisplayNameMatches(" + this.filter + ")";
        }
    }

    private static class IdOfItemTransformer
    implements Function<CatalogItem<?, ?>, String> {
        private IdOfItemTransformer() {
        }

        @Nullable
        public String apply(@Nullable CatalogItem<?, ?> input) {
            if (input == null) {
                return null;
            }
            return input.getId();
        }
    }

    private static class DisabledEqualTo<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final boolean disabled;

        public DisabledEqualTo(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && item.isDisabled() == this.disabled;
        }

        public String toString() {
            return "DisabledEqualTo(" + this.disabled + ")";
        }
    }

    private static class DeprecatedEqualTo<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final boolean deprecated;

        public DeprecatedEqualTo(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && item.isDeprecated() == this.deprecated;
        }

        public String toString() {
            return "DeprecatedEqualTo(" + this.deprecated + ")";
        }
    }

    private static class CatalogItemTypeEqualTo<T, SpecT>
    implements Predicate<CatalogItem<T, SpecT>> {
        private final CatalogItem.CatalogItemType ciType;

        public CatalogItemTypeEqualTo(CatalogItem.CatalogItemType ciType) {
            this.ciType = ciType;
        }

        public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
            return item != null && item.getCatalogItemType() == this.ciType;
        }

        public String toString() {
            return "CatalogItemTypeEqualTo(" + this.ciType + ")";
        }
    }
}

