/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.storm;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.messaging.storm.StormImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Storm Node", description="Apache Storm is a distributed realtime computation system. Storm makes it easy to reliably process unbounded streams of data, doing for realtime processing what Hadoop did for batch processing", iconUrl="classpath:///apache-storm-logo.png")
@ImplementedBy(value=StormImpl.class)
public interface Storm
extends SoftwareProcess,
UsesJmx {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"0.8.2");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"storm-%s");
    @SetFromFlag(value="nimbusHostname")
    public static final ConfigKey<String> NIMBUS_HOSTNAME = ConfigKeys.newStringConfigKey((String)"storm.nimbus.hostname");
    @SetFromFlag(value="nimbusEntity")
    public static final ConfigKey<Entity> NIMBUS_ENTITY = ConfigKeys.newConfigKey(Entity.class, (String)"storm.nimbus.entity");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"https://dl.dropboxusercontent.com/s/fl4kr7w0oc8ihdw/storm-${version}.zip");
    public static final ConfigKey<Object> START_MUTEX = ConfigKeys.newConfigKey(Object.class, (String)"storm.start.mutex");
    @SetFromFlag(value="role")
    public static final ConfigKey<Role> ROLE = ConfigKeys.newConfigKey(Role.class, (String)"storm.role", (String)"The Storm server role");
    @SetFromFlag(value="localDir")
    public static final ConfigKey<String> LOCAL_DIR = ConfigKeys.newStringConfigKey((String)"storm.local.dir", (String)"Setting for Storm local dir");
    @SetFromFlag(value="uiPort")
    public static final PortAttributeSensorAndConfigKey UI_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"storm.ui.port", (String)"Storm UI port", (Object)"8080+");
    @SetFromFlag(value="thriftPort")
    public static final PortAttributeSensorAndConfigKey THRIFT_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"storm.thrift.port", (String)"Storm Thrift port", (Object)"6627");
    @SetFromFlag(value="zookeeperEnsemble")
    public static final ConfigKey<ZooKeeperEnsemble> ZOOKEEPER_ENSEMBLE = ConfigKeys.newConfigKey(ZooKeeperEnsemble.class, (String)"storm.zookeeper.ensemble", (String)"Zookeeper ensemble entity");
    @SetFromFlag(value="stormConfigTemplateUrl")
    public static final ConfigKey<String> STORM_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"storm.config.templateUrl", (String)"Template file (in freemarker format) for the storm.yaml config file", (String)"classpath://org/apache/brooklyn/entity/messaging/storm/storm.yaml");
    @SetFromFlag(value="zeromqVersion")
    public static final ConfigKey<String> ZEROMQ_VERSION = ConfigKeys.newStringConfigKey((String)"storm.zeromq.version", (String)"zeromq version", (String)"2.1.7");
    public static final AttributeSensor<Boolean> SERVICE_UP_JMX = Sensors.newBooleanSensor((String)"storm.service.jmx.up", (String)"Whether JMX is up for this service");
    public static final AttributeSensor<String> STORM_UI_URL = StormUiUrl.STORM_UI_URL;

    public String getStormConfigTemplateUrl();

    public String getHostname();

    public Role getRole();

    public static class StormUiUrl {
        public static final AttributeSensor<String> STORM_UI_URL = Sensors.newStringSensor((String)"storm.ui.url", (String)"URL");

        static {
            RendererHints.register(STORM_UI_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
        }
    }

    public static enum Role {
        NIMBUS,
        SUPERVISOR,
        UI;

    }
}

