/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.internal.TrueIfNullOrDeletedRefreshAndDoubleCheckOnFalse;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;

public class AtomicNodeTerminated
extends TrueIfNullOrDeletedRefreshAndDoubleCheckOnFalse<NodeMetadata.Status, NodeMetadata> {
    private final GetNodeMetadataStrategy client;

    @Inject
    public AtomicNodeTerminated(GetNodeMetadataStrategy client) {
        super(NodeMetadata.Status.TERMINATED);
        this.client = (GetNodeMetadataStrategy)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    @Override
    protected NodeMetadata refreshOrNull(NodeMetadata resource) {
        if (resource == null || resource.getId() == null) {
            return null;
        }
        return this.client.getNode(resource.getId());
    }
}

