/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Offer;
import org.jclouds.azurecompute.arm.domain.Publisher;
import org.jclouds.azurecompute.arm.domain.SKU;
import org.jclouds.azurecompute.arm.domain.Version;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;

@Path(value="/providers/Microsoft.Compute/locations/{location}")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface OSImageApi {
    @Named(value="publisher:list")
    @GET
    @Path(value="/publishers")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Publisher> listPublishers();

    @Named(value="offer:list")
    @GET
    @Path(value="/publishers/{publisher}/artifacttypes/vmimage/offers")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Offer> listOffers(@PathParam(value="publisher") String var1);

    @Named(value="sku:list")
    @GET
    @Path(value="/publishers/{publisher}/artifacttypes/vmimage/offers/{offer}/skus")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<SKU> listSKUs(@PathParam(value="publisher") String var1, @PathParam(value="offer") String var2);

    @Named(value="version:list")
    @GET
    @Path(value="/publishers/{publisher}/artifacttypes/vmimage/offers/{offer}/skus/{sku}/versions")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Version> listVersions(@PathParam(value="publisher") String var1, @PathParam(value="offer") String var2, @PathParam(value="sku") String var3);

    @Named(value="version:get")
    @GET
    @Path(value="/publishers/{publisher}/artifacttypes/vmimage/offers/{offer}/skus/{sku}/versions/{version}")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public Version getVersion(@PathParam(value="publisher") String var1, @PathParam(value="offer") String var2, @PathParam(value="sku") String var3, @PathParam(value="version") String var4);
}

