/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.sensor.BasicSensorEvent;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransformer<T, U>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransformer.class);
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity with the trigger sensor (defaults to the enricher's entity)");
    public static final ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor", "The sensor whose change triggers re-evaluation of the target value");
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor", "The sensor to be set on the associated entity with the value computed here");
    public static final ConfigKey<List<? extends Sensor<?>>> TRIGGER_SENSORS = ConfigKeys.newConfigKey(new TypeToken<List<? extends Sensor<?>>>(){}, "enricher.triggerSensors", "Sensors that will trigger re-evaluation", ImmutableList.of());
    public static final ConfigKey<Boolean> ALLOW_CYCLIC_PUBLISHING = ConfigKeys.newBooleanConfigKey("enricher.allowCyclicPublishing", "Whether to all a transformer to publish to the same sensor (on the same entity) to which it's subscribed, thus risking an infinite loop. Defaults to false. Use with caution (e.g. if transformer implementation is very selective about when to publish, filters out duplicates, etc", false);
    protected Entity producer;
    protected Sensor<T> sourceSensor;
    protected Sensor<U> targetSensor;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensor = this.getConfig(SOURCE_SENSOR);
        Sensor<?> targetSensorSpecified = this.getConfig(TARGET_SENSOR);
        ImmutableList triggerSensorsSpecified = this.getConfig(TRIGGER_SENSORS);
        ImmutableList triggerSensors = triggerSensorsSpecified != null ? triggerSensorsSpecified : ImmutableList.of();
        Object object = this.targetSensor = targetSensorSpecified != null ? targetSensorSpecified : this.sourceSensor;
        if (this.targetSensor == null) {
            throw new IllegalArgumentException("Enricher " + JavaClassNames.simpleClassName((Object)this) + " has no " + TARGET_SENSOR.getName() + ", and it cannot be inferred as " + SOURCE_SENSOR.getName() + " is also not set");
        }
        if (this.sourceSensor == null && triggerSensors.isEmpty()) {
            throw new IllegalArgumentException("Enricher " + JavaClassNames.simpleClassName((Object)this) + " has no " + SOURCE_SENSOR.getName() + " and no " + TRIGGER_SENSORS.getName());
        }
        if (this.producer.equals(entity) && (this.targetSensor.equals(this.sourceSensor) || triggerSensors.contains(this.targetSensor))) {
            boolean allowCyclicPublishing = Boolean.TRUE.equals(this.getConfig(ALLOW_CYCLIC_PUBLISHING));
            if (allowCyclicPublishing) {
                LOG.debug("Permitting cyclic publishing, though detected enricher will read and publish on the same sensor: " + this.producer + "->" + this.targetSensor + " (computing transformation with " + JavaClassNames.simpleClassName((Object)this) + ")");
            } else {
                LOG.error("Refusing to add an enricher which reads and publishes on the same sensor: " + this.producer + "->" + this.targetSensor + " (computing transformation with " + JavaClassNames.simpleClassName((Object)this) + ")");
                return;
            }
        }
        if (this.sourceSensor != null) {
            this.subscriptions().subscribe((Map<String, ?>)MutableMap.of((Object)"notifyOfInitialValue", (Object)true), this.producer, this.sourceSensor, this);
        }
        if (triggerSensors.size() > 0) {
            SensorEventListener<Object> triggerListener = new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    if (AbstractTransformer.this.sourceSensor != null) {
                        Object value = AbstractTransformer.this.producer.getAttribute((AttributeSensor)AbstractTransformer.this.sourceSensor);
                        AbstractTransformer.this.onEvent(new BasicSensorEvent<Object>(AbstractTransformer.this.sourceSensor, AbstractTransformer.this.producer, value, event.getTimestamp()));
                    } else {
                        AbstractTransformer.this.onEvent(null);
                    }
                }
            };
            for (Object sensor : triggerSensors) {
                if (sensor instanceof String) {
                    AttributeSensor<Object> resolvedSensor = entity.getEntityType().getSensor((String)sensor);
                    if (resolvedSensor == null) {
                        resolvedSensor = Sensors.newSensor(Object.class, (String)sensor);
                    }
                    sensor = resolvedSensor;
                }
                this.subscriptions().subscribe((Map<String, ?>)MutableMap.of((Object)"notifyOfInitialValue", (Object)true), this.producer, (Sensor)sensor, triggerListener);
            }
        }
        this.highlightTriggers(MutableList.of(this.sourceSensor).appendAll((Iterable)triggerSensors), (Object)this.producer);
    }

    protected abstract Function<SensorEvent<T>, U> getTransformation();

    public void onEvent(SensorEvent<T> event) {
        this.emit(this.targetSensor, this.compute(event));
    }

    protected Object compute(SensorEvent<T> event) {
        Object result = this.getTransformation().apply(event);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Enricher " + this + " computed " + result + " from " + event);
        }
        return result;
    }
}

