/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.http;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.feed.http.JsonFunctions;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.http.HttpToolResponse;

public class HttpValueFunctions {
    private HttpValueFunctions() {
    }

    public static Function<HttpToolResponse, Integer> responseCode() {
        return new ResponseCode();
    }

    @Deprecated
    private static Function<HttpToolResponse, Integer> responseCodeLegacy() {
        return new Function<HttpToolResponse, Integer>(){

            public Integer apply(HttpToolResponse input) {
                return input.getResponseCode();
            }
        };
    }

    public static Function<HttpToolResponse, Boolean> responseCodeEquals(int expected) {
        return Functionals.chain(HttpValueFunctions.responseCode(), (Function)Functions.forPredicate((Predicate)Predicates.equalTo((Object)expected)));
    }

    public static Function<HttpToolResponse, Boolean> responseCodeEquals(int ... expected) {
        ArrayList expectedList = Lists.newArrayList();
        for (int e : expected) {
            expectedList.add(e);
        }
        return Functionals.chain(HttpValueFunctions.responseCode(), (Function)Functions.forPredicate((Predicate)Predicates.in((Collection)expectedList)));
    }

    public static Function<HttpToolResponse, String> stringContentsFunction() {
        return new StringContents();
    }

    @Deprecated
    private static Function<HttpToolResponse, String> stringContentsFunctionLegacy() {
        return new Function<HttpToolResponse, String>(){

            public String apply(HttpToolResponse input) {
                return input.getContentAsString();
            }
        };
    }

    public static Function<HttpToolResponse, JsonElement> jsonContents() {
        return Functionals.chain(HttpValueFunctions.stringContentsFunction(), JsonFunctions.asJson());
    }

    public static <T> Function<HttpToolResponse, T> jsonContents(String element, Class<T> expected) {
        return HttpValueFunctions.jsonContents(new String[]{element}, expected);
    }

    public static <T> Function<HttpToolResponse, T> jsonContents(String[] elements, Class<T> expected) {
        return Functionals.chain(HttpValueFunctions.jsonContents(), JsonFunctions.walk(elements), JsonFunctions.cast(expected));
    }

    public static <T> Function<HttpToolResponse, T> jsonContentsFromPath(String path) {
        return Functionals.chain(HttpValueFunctions.jsonContents(), JsonFunctions.getPath(path));
    }

    public static Function<HttpToolResponse, Long> latency() {
        return new Latency();
    }

    @Deprecated
    private static Function<HttpToolResponse, Long> latencyLegacy() {
        return new Function<HttpToolResponse, Long>(){

            public Long apply(HttpToolResponse input) {
                return input.getLatencyFullContent();
            }
        };
    }

    public static Function<HttpToolResponse, Boolean> containsHeader(String header) {
        return new ContainsHeader(header);
    }

    @Deprecated
    public static <A, B, C> Function<A, C> chain(Function<A, ? extends B> f1, Function<B, C> f2) {
        return Functionals.chain(f1, f2);
    }

    @Deprecated
    public static <A, B, C, D> Function<A, D> chain(Function<A, ? extends B> f1, Function<B, ? extends C> f2, Function<C, D> f3) {
        return Functionals.chain(f1, f2, f3);
    }

    @Deprecated
    public static <A, B, C, D, E> Function<A, E> chain(Function<A, ? extends B> f1, Function<B, ? extends C> f2, Function<C, ? extends D> f3, Function<D, E> f4) {
        return Functionals.chain(f1, f2, f3, f4);
    }

    private static class ContainsHeader
    implements Function<HttpToolResponse, Boolean> {
        private final String header;

        public ContainsHeader(String header) {
            this.header = header;
        }

        public Boolean apply(HttpToolResponse input) {
            List actual = (List)input.getHeaderLists().get(this.header);
            return actual != null && actual.size() > 0;
        }
    }

    private static class Latency
    implements Function<HttpToolResponse, Long> {
        private Latency() {
        }

        public Long apply(HttpToolResponse input) {
            return input.getLatencyFullContent();
        }
    }

    private static class StringContents
    implements Function<HttpToolResponse, String> {
        private StringContents() {
        }

        public String apply(HttpToolResponse input) {
            return input.getContentAsString();
        }
    }

    private static class ResponseCode
    implements Function<HttpToolResponse, Integer> {
        private ResponseCode() {
        }

        public Integer apply(HttpToolResponse input) {
            return input.getResponseCode();
        }
    }
}

