/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.digitalocean2.domain.Size;

@Singleton
public class SizeToHardware
implements Function<Size, Hardware> {
    public Hardware apply(Size input) {
        HardwareBuilder builder = new HardwareBuilder();
        builder.id(input.slug());
        builder.providerId(input.slug());
        builder.name(input.slug());
        builder.ram(input.memory());
        builder.processor(new Processor((double)input.vcpus(), (double)input.vcpus()));
        builder.volume(new VolumeBuilder().size(Float.valueOf(input.disk())).type(Volume.Type.LOCAL).build());
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        metadata.put((Object)"costPerHour", (Object)String.valueOf(input.priceHourly()));
        metadata.put((Object)"costPerMonth", (Object)String.valueOf(input.priceMonthly()));
        builder.userMetadata((Map)metadata.build());
        return builder.build();
    }
}

