/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.AttributePollHandler;
import org.apache.brooklyn.core.feed.DelegatingPollHandler;
import org.apache.brooklyn.core.feed.PollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.feed.jmx.JmxNotificationSubscriptionConfig;
import org.apache.brooklyn.feed.jmx.JmxOperationPollConfig;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxFeed
extends AbstractFeed {
    public static final Logger log = LoggerFactory.getLogger(JmxFeed.class);
    public static final long JMX_CONNECTION_TIMEOUT_MS = 120000L;
    public static final ConfigKey<JmxHelper> HELPER = ConfigKeys.newConfigKey(JmxHelper.class, (String)"helper");
    public static final ConfigKey<Boolean> OWN_HELPER = ConfigKeys.newBooleanConfigKey((String)"ownHelper");
    public static final ConfigKey<String> JMX_URI = ConfigKeys.newStringConfigKey((String)"jmxUri");
    public static final ConfigKey<Long> JMX_CONNECTION_TIMEOUT = ConfigKeys.newLongConfigKey((String)"jmxConnectionTimeout");
    public static final ConfigKey<SetMultimap<String, JmxAttributePollConfig<?>>> ATTRIBUTE_POLLS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<SetMultimap<String, JmxAttributePollConfig<?>>>(){}, (String)"attributePolls");
    public static final ConfigKey<SetMultimap<List<?>, JmxOperationPollConfig<?>>> OPERATION_POLLS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<SetMultimap<List<?>, JmxOperationPollConfig<?>>>(){}, (String)"operationPolls");
    public static final ConfigKey<SetMultimap<NotificationFilter, JmxNotificationSubscriptionConfig<?>>> NOTIFICATION_SUBSCRIPTIONS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<SetMultimap<NotificationFilter, JmxNotificationSubscriptionConfig<?>>>(){}, (String)"notificationPolls");
    private final SetMultimap<ObjectName, NotificationListener> notificationListeners = HashMultimap.create();

    public static Builder builder() {
        return new Builder();
    }

    public JmxFeed() {
    }

    protected JmxFeed(Builder builder) {
        if (builder.helper != null) {
            JmxHelper helper = builder.helper;
            this.config().set(HELPER, (Object)helper);
            this.config().set(OWN_HELPER, (Object)false);
            this.config().set(JMX_URI, (Object)helper.getUrl());
        }
        this.config().set(JMX_CONNECTION_TIMEOUT, (Object)builder.jmxConnectionTimeout);
        HashMultimap attributePolls = HashMultimap.create();
        for (Object config : builder.attributePolls) {
            if (!config.isEnabled()) continue;
            JmxAttributePollConfig configCopy = new JmxAttributePollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period, builder.periodUnits);
            }
            attributePolls.put((Object)(configCopy.getObjectName().getCanonicalName() + configCopy.getAttributeName()), configCopy);
        }
        this.config().set(ATTRIBUTE_POLLS, (Object)attributePolls);
        HashMultimap operationPolls = HashMultimap.create();
        for (JmxOperationPollConfig config : builder.operationPolls) {
            if (!config.isEnabled()) continue;
            JmxOperationPollConfig configCopy = new JmxOperationPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period, builder.periodUnits);
            }
            operationPolls.put(configCopy.buildOperationIdentity(), configCopy);
        }
        this.config().set(OPERATION_POLLS, (Object)operationPolls);
        HashMultimap notificationSubscriptions = HashMultimap.create();
        for (JmxNotificationSubscriptionConfig config : builder.notificationSubscriptions) {
            if (!config.isEnabled()) continue;
            notificationSubscriptions.put((Object)config.getNotificationFilter(), (Object)config);
        }
        this.config().set(NOTIFICATION_SUBSCRIPTIONS, (Object)notificationSubscriptions);
        this.initUniqueTag(builder.uniqueTag, new Object[]{attributePolls, operationPolls, notificationSubscriptions});
    }

    public void setEntity(EntityLocal entity) {
        if (this.getConfig(HELPER) == null) {
            JmxHelper helper = new JmxHelper((Entity)entity);
            this.config().set(HELPER, (Object)helper);
            this.config().set(OWN_HELPER, (Object)true);
            this.config().set(JMX_URI, (Object)helper.getUrl());
        }
        super.setEntity(entity);
    }

    public String getJmxUri() {
        return (String)this.getConfig(JMX_URI);
    }

    protected JmxHelper getHelper() {
        return (JmxHelper)this.getConfig(HELPER);
    }

    protected Poller<Object> getPoller() {
        return super.getPoller();
    }

    protected boolean isConnected() {
        return super.isConnected() && this.getHelper().isConnected();
    }

    protected void preStart() {
        final SetMultimap notificationSubscriptions = (SetMultimap)this.getConfig(NOTIFICATION_SUBSCRIPTIONS);
        SetMultimap operationPolls = (SetMultimap)this.getConfig(OPERATION_POLLS);
        SetMultimap attributePolls = (SetMultimap)this.getConfig(ATTRIBUTE_POLLS);
        this.getPoller().submit((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                JmxFeed.this.getHelper().connect((Long)JmxFeed.this.getConfig(JMX_CONNECTION_TIMEOUT));
                return null;
            }

            public String toString() {
                return "Connect JMX " + JmxFeed.this.getHelper().getUrl();
            }
        });
        for (final NotificationFilter filter : notificationSubscriptions.keySet()) {
            this.getPoller().submit((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    Set configs = notificationSubscriptions.get((Object)filter);
                    NotificationListener listener = JmxFeed.this.registerNotificationListener(configs);
                    ObjectName objectName = ((JmxNotificationSubscriptionConfig)((Object)Iterables.get((Iterable)configs, (int)0))).getObjectName();
                    JmxFeed.this.notificationListeners.put((Object)objectName, (Object)listener);
                    return null;
                }

                public String toString() {
                    return "Register JMX notifications: " + notificationSubscriptions.get((Object)filter);
                }
            });
        }
        for (String jmxAttributeName : attributePolls.keys()) {
            this.registerAttributePoller(attributePolls.get((Object)jmxAttributeName));
        }
        for (List operationIdentifier : operationPolls.keys()) {
            this.registerOperationPoller(operationPolls.get((Object)operationIdentifier));
        }
    }

    protected void preStop() {
        super.preStop();
        for (Map.Entry entry : this.notificationListeners.entries()) {
            this.unregisterNotificationListener((ObjectName)entry.getKey(), (NotificationListener)entry.getValue());
        }
        this.notificationListeners.clear();
    }

    protected void postStop() {
        super.postStop();
        JmxHelper helper = this.getHelper();
        Boolean ownHelper = (Boolean)this.getConfig(OWN_HELPER);
        if (helper != null && ownHelper.booleanValue()) {
            helper.terminate();
        }
    }

    private void registerOperationPoller(Set<JmxOperationPollConfig<?>> configs) {
        LinkedHashSet handlers = Sets.newLinkedHashSet();
        long minPeriod = Integer.MAX_VALUE;
        final ObjectName objectName = ((JmxOperationPollConfig)((Object)Iterables.get(configs, (int)0))).getObjectName();
        final String operationName = ((JmxOperationPollConfig)((Object)Iterables.get(configs, (int)0))).getOperationName();
        final List<String> signature = ((JmxOperationPollConfig)((Object)Iterables.get(configs, (int)0))).getSignature();
        final List<?> params = ((JmxOperationPollConfig)((Object)Iterables.get(configs, (int)0))).getParams();
        for (JmxOperationPollConfig<?> config : configs) {
            handlers.add(new AttributePollHandler(config, (Entity)this.getEntity(), (AbstractFeed)this));
            if (config.getPeriod() <= 0L) continue;
            minPeriod = Math.min(minPeriod, config.getPeriod());
        }
        this.getPoller().scheduleAtFixedRate((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug("jmx operation polling for {} sensors at {} -> {}", new Object[]{JmxFeed.this.getEntity(), JmxFeed.this.getJmxUri(), operationName});
                }
                if (signature.size() == params.size()) {
                    return JmxFeed.this.getHelper().operation(objectName, operationName, signature, params);
                }
                return JmxFeed.this.getHelper().operation(objectName, operationName, params.toArray());
            }
        }, (PollHandler)new DelegatingPollHandler((Iterable)handlers), minPeriod);
    }

    private void registerAttributePoller(Set<JmxAttributePollConfig<?>> configs) {
        LinkedHashSet handlers = Sets.newLinkedHashSet();
        long minPeriod = Integer.MAX_VALUE;
        final ObjectName objectName = ((JmxAttributePollConfig)((Object)Iterables.get(configs, (int)0))).getObjectName();
        final String jmxAttributeName = ((JmxAttributePollConfig)((Object)Iterables.get(configs, (int)0))).getAttributeName();
        for (JmxAttributePollConfig<?> config : configs) {
            handlers.add(new AttributePollHandler(config, (Entity)this.getEntity(), (AbstractFeed)this));
            if (config.getPeriod() <= 0L) continue;
            minPeriod = Math.min(minPeriod, config.getPeriod());
        }
        this.getPoller().scheduleAtFixedRate((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (log.isTraceEnabled()) {
                    log.trace("jmx attribute polling for {} sensors at {} -> {}", new Object[]{JmxFeed.this.getEntity(), JmxFeed.this.getJmxUri(), jmxAttributeName});
                }
                return JmxFeed.this.getHelper().getAttribute(objectName, jmxAttributeName);
            }
        }, (PollHandler)new DelegatingPollHandler((Iterable)handlers), minPeriod);
    }

    private NotificationListener registerNotificationListener(Set<JmxNotificationSubscriptionConfig<?>> configs) {
        ArrayList handlers = Lists.newArrayList();
        ObjectName objectName = ((JmxNotificationSubscriptionConfig)((Object)Iterables.get(configs, (int)0))).getObjectName();
        NotificationFilter filter = ((JmxNotificationSubscriptionConfig)((Object)Iterables.get(configs, (int)0))).getNotificationFilter();
        for (final JmxNotificationSubscriptionConfig<?> config : configs) {
            AttributePollHandler<Notification> handler = new AttributePollHandler<Notification>(config, (Entity)this.getEntity(), (AbstractFeed)this){

                protected Object transformValueOnSuccess(Notification val) {
                    if (config.getOnNotification() != null) {
                        return config.getOnNotification().apply((Object)val);
                    }
                    Object result = super.transformValueOnSuccess((Object)val);
                    if (result instanceof Notification) {
                        return ((Notification)result).getUserData();
                    }
                    return result;
                }
            };
            handlers.add(handler);
        }
        DelegatingPollHandler compoundHandler = new DelegatingPollHandler((Iterable)handlers);
        NotificationListener listener = new NotificationListener((PollHandler)compoundHandler){
            final /* synthetic */ PollHandler val$compoundHandler;
            {
                this.val$compoundHandler = pollHandler;
            }

            @Override
            public void handleNotification(Notification notification, Object handback) {
                this.val$compoundHandler.onSuccess((Object)notification);
            }
        };
        this.getHelper().addNotificationListener(objectName, listener, filter);
        return listener;
    }

    private void unregisterNotificationListener(ObjectName objectName, NotificationListener listener) {
        try {
            this.getHelper().removeNotificationListener(objectName, listener);
        }
        catch (RuntimeException e) {
            log.warn("Failed to unregister listener: " + objectName + ", " + listener + "; continuing...", (Throwable)e);
        }
    }

    public String toString() {
        return "JmxFeed[" + (this.getManagementContext() != null && this.getManagementContext().isRunning() ? this.getJmxUri() : "mgmt-not-running") + "]";
    }

    public static class Builder {
        private Entity entity;
        private JmxHelper helper;
        private long jmxConnectionTimeout = 120000L;
        private long period = 500L;
        private TimeUnit periodUnits = TimeUnit.MILLISECONDS;
        private List<JmxAttributePollConfig<?>> attributePolls = Lists.newArrayList();
        private List<JmxOperationPollConfig<?>> operationPolls = Lists.newArrayList();
        private List<JmxNotificationSubscriptionConfig<?>> notificationSubscriptions = Lists.newArrayList();
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(Entity val) {
            this.entity = val;
            return this;
        }

        public Builder helper(JmxHelper val) {
            this.helper = val;
            return this;
        }

        public Builder period(Duration duration) {
            return this.period(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            this.period = val;
            this.periodUnits = units;
            return this;
        }

        public Builder pollAttribute(JmxAttributePollConfig<?> config) {
            this.attributePolls.add(config);
            return this;
        }

        public Builder pollOperation(JmxOperationPollConfig<?> config) {
            this.operationPolls.add(config);
            return this;
        }

        public Builder subscribeToNotification(JmxNotificationSubscriptionConfig<?> config) {
            this.notificationSubscriptions.add(config);
            return this;
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public JmxFeed build() {
            this.built = true;
            JmxFeed result = new JmxFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)((EntityLocal)this.entity), (Object)"entity"));
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("JmxFeed.Builder created, but build() never called");
            }
        }
    }
}

