/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.rubyrep;

import java.net.URI;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.database.rubyrep.RubyRepDriver;
import org.apache.brooklyn.entity.database.rubyrep.RubyRepNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.util.time.Duration;

public class RubyRepNodeImpl
extends SoftwareProcessImpl
implements RubyRepNode {
    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
    }

    public void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    protected void preStart() {
        DatastoreMixins.DatastoreCommon rightNode;
        super.preStart();
        DatastoreMixins.DatastoreCommon leftNode = (DatastoreMixins.DatastoreCommon)this.getConfig(LEFT_DATABASE);
        if (leftNode != null) {
            this.sensors().set(LEFT_DATASTORE_URL, ((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)leftNode, (AttributeSensor)DatastoreMixins.DatastoreCommon.DATASTORE_URL))).getUnchecked(this.getDatabaseStartupDelay()));
        }
        if ((rightNode = (DatastoreMixins.DatastoreCommon)this.getConfig(RIGHT_DATABASE)) != null) {
            this.sensors().set(RIGHT_DATASTORE_URL, ((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)rightNode, (AttributeSensor)DatastoreMixins.DatastoreCommon.DATASTORE_URL))).getUnchecked(this.getDatabaseStartupDelay()));
        }
    }

    public Class<?> getDriverInterface() {
        return RubyRepDriver.class;
    }

    public Duration getDatabaseStartupDelay() {
        return Duration.seconds((Number)((Number)this.getConfig(DATABASE_STARTUP_TIMEOUT)));
    }

    public int getReplicationInterval() {
        return (Integer)this.getConfig(REPLICATION_INTERVAL);
    }

    public String getTableRegex() {
        return (String)this.getConfig(TABLE_REGEXP);
    }

    public URI getLeftDatabaseUrl() {
        return URI.create((String)this.getAttribute(LEFT_DATASTORE_URL));
    }

    public String getLeftDatabaseName() {
        return (String)this.getConfig(LEFT_DATABASE_NAME);
    }

    public String getLeftUsername() {
        return (String)this.getConfig(LEFT_USERNAME);
    }

    public String getLeftPassword() {
        return (String)this.getConfig(LEFT_PASSWORD);
    }

    public URI getRightDatabaseUrl() {
        return URI.create((String)this.getAttribute(RIGHT_DATASTORE_URL));
    }

    public String getRightDatabaseName() {
        return (String)this.getConfig(RIGHT_DATABASE_NAME);
    }

    public String getRightUsername() {
        return (String)this.getConfig(RIGHT_USERNAME);
    }

    public String getRightPassword() {
        return (String)this.getConfig(RIGHT_PASSWORD);
    }
}

